/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.mule.tooling.platform.component.IPlatformComponent;
import org.mule.tooling.platform.component.IProjectComponent;
import org.mule.tooling.platform.component.IProjectComponentFactory;
import org.mule.tooling.platform.component.PlatformComponentManager;
import org.mule.tooling.platform.events.DefaultProjectEventListener;
import org.mule.tooling.platform.events.ProjectEventManager;
import org.mule.tooling.platform.utils.ProjectHelper;
import org.mule.tooling.platform.utils.SafeRunner;
import org.mule.tooling.utils.Pair;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public class ProjectComponentManager
implements IPlatformComponent {
    private Map<IProject, Map<Class<? extends IProjectComponent>, Pair<ProjectComponentExtension, IProjectComponent>>> services = new HashMap<IProject, Map<Class<? extends IProjectComponent>, Pair<ProjectComponentExtension, IProjectComponent>>>();
    private List<ProjectComponentExtension> extensions = this.getExtensions();

    public static ProjectComponentManager getInstance() {
        return PlatformComponentManager.getPlatformComponent(ProjectComponentManager.class).get();
    }

    @Override
    public void start() {
    }

    @Override
    public void wire() {
        ProjectEventManager.getInstance().addListener(new DefaultProjectEventListener(){

            @Override
            public void onProjectOpened(IProject project) {
                ProjectComponentManager.this.startProjectComponentsFor(project);
            }

            @Override
            public void onProjectClosed(IProject project) {
                ProjectComponentManager.this.stopProjectComponentsFor(project, true);
            }
        });
    }

    protected void stopProjectComponentsFor(IProject project, boolean remove) {
        Optional.ofNullable(this.services.get(project)).ifPresent(components -> {
            Collection values = components.values();
            for (Pair projectComponent : values) {
                SafeRunner.exec(() -> ((IProjectComponent)projectComponent.getRight()).stop(), "Stopping Project Component: " + String.valueOf(projectComponent));
            }
        });
        if (remove) {
            this.services.remove(project);
        }
    }

    protected synchronized void startProjectComponentsFor(IProject project) {
        Map<Object, Object> projectComponents;
        HashMap newComponents = new HashMap();
        if (this.services.containsKey(project)) {
            projectComponents = this.services.get(project);
        } else {
            projectComponents = new HashMap();
            this.services.put(project, projectComponents);
        }
        for (ProjectComponentExtension projectComponentExtension : this.extensions) {
            Pair removed;
            IProjectComponentFactory<?> factory = projectComponentExtension.getFactory();
            Class<?> serviceInterface = factory.getServiceInterface();
            if (this.accepts(project, projectComponentExtension)) {
                if (projectComponents.containsKey(serviceInterface)) continue;
                newComponents.put(serviceInterface, new Pair((Object)projectComponentExtension, factory.createServiceImplementation(project)));
                continue;
            }
            if (!projectComponents.containsKey(serviceInterface) || ((Pair)projectComponents.get(serviceInterface)).getLeft() != projectComponentExtension || (removed = (Pair)projectComponents.remove(serviceInterface)) == null) continue;
            ((IProjectComponent)removed.getRight()).stop();
        }
        projectComponents.putAll(newComponents);
        Collection components = newComponents.values();
        for (Pair component : components) {
            SafeRunner.exec(() -> ((IProjectComponent)component.getRight()).wire(), "Wireing Project Component " + String.valueOf(component));
        }
        for (Pair component : components) {
            SafeRunner.exec(() -> ((IProjectComponent)component.getRight()).start(), "Starting Project Component " + String.valueOf(component));
        }
    }

    private boolean accepts(IProject project, ProjectComponentExtension extension) {
        if (extension.getNatureId().isPresent()) {
            return ProjectHelper.hasNature(project, extension.getNatureId().get());
        }
        return true;
    }

    @Override
    public void stop() {
        Set<IProject> projects = this.services.keySet();
        for (IProject project : projects) {
            this.stopProjectComponentsFor(project, false);
        }
        this.services.clear();
    }

    public static <T extends IProjectComponent> List<T> getProjectComponents(Class<T> service) {
        return ProjectComponentManager.getInstance().services.values().stream().map(services -> (Pair)services.get(service)).filter(v -> v != null).map(s -> (IProjectComponent)service.cast(s.getRight())).collect(Collectors.toList());
    }

    public static <T extends IProjectComponent> T projectComponentWith(IProject project, Class<T> service) {
        return (T)((IProjectComponent)ProjectComponentManager.getProjectComponent(project, service).orElseThrow(() -> new RuntimeException(service.getSimpleName() + " was not found project natures are " + String.join((CharSequence)",", ProjectHelper.getNatures(project)))));
    }

    public static <T extends IProjectComponent> Optional<T> getProjectComponent(IProject project, Class<T> service) {
        if (!project.isOpen()) {
            return Optional.empty();
        }
        if (!ProjectComponentManager.getInstance().services.containsKey(project)) {
            ProjectComponentManager.getInstance().startProjectComponentsFor(project);
        }
        Optional<Map<Class<? extends IProjectComponent>, Pair<ProjectComponentExtension, IProjectComponent>>> projectServices = Optional.ofNullable(ProjectComponentManager.getInstance().services.get(project));
        return projectServices.flatMap(components -> Optional.ofNullable((Pair)components.get(service))).map(c -> (IProjectComponent)service.cast(c.getRight()));
    }

    protected List<ProjectComponentExtension> getExtensions() {
        return IExtensionPointReader.create(ProjectComponentExtension.class).readAll();
    }

    @ExtensionPoint(extensionPointId="org.mule.component.projectComponent")
    public static class ProjectComponentExtension {
        @ExtensionAttribute(attributeName="class")
        private IProjectComponentFactory<?> factory;
        @ExtensionAttribute(attributeName="natureId", optional=true)
        private String natureId;

        public IProjectComponentFactory<?> getFactory() {
            return this.factory;
        }

        public void setFactory(IProjectComponentFactory<?> factory) {
            this.factory = factory;
        }

        public Optional<String> getNatureId() {
            return Optional.ofNullable(this.natureId);
        }

        public void setNatureId(String natureId) {
            this.natureId = natureId;
        }
    }
}

