/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.tooling.platform.component.ComponentLifecycle;
import org.mule.tooling.platform.component.IPlatformComponent;
import org.mule.tooling.platform.component.IPlatformComponentFactory;
import org.mule.tooling.platform.utils.SafeRunner;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public class PlatformComponentManager {
    private static PlatformComponentManager instance = new PlatformComponentManager();
    private Map<Class<? extends IPlatformComponent>, IPlatformComponent> services = new HashMap<Class<? extends IPlatformComponent>, IPlatformComponent>();
    private boolean started = false;

    public static PlatformComponentManager getInstance() {
        return instance;
    }

    public PlatformComponentManager() {
        this.getExtensions().forEach(ext -> {
            IPlatformComponentFactory<?> factory = ext.getFactory();
            this.services.put((Class<? extends IPlatformComponent>)factory.getServiceInterface(), (IPlatformComponent)factory.createServiceImplementation());
        });
    }

    public void start() {
        if (!this.started) {
            this.started = true;
            for (ComponentLifecycle componentLifecycle : this.services.values()) {
                SafeRunner.exec(() -> component.wire(), "Wireing Platform Component: " + String.valueOf(componentLifecycle));
            }
            for (ComponentLifecycle componentLifecycle : this.services.values()) {
                SafeRunner.exec(() -> component.start(), "Starting Platform Component: " + String.valueOf(componentLifecycle));
            }
        }
    }

    public void stop() {
        if (this.started) {
            this.started = false;
            for (ComponentLifecycle componentLifecycle : this.services.values()) {
                SafeRunner.exec(() -> component.stop(), "Stopping Platform Component: " + String.valueOf(componentLifecycle));
            }
        }
    }

    public static <T extends ComponentLifecycle> Optional<T> getPlatformComponent(Class<T> service) {
        return Optional.ofNullable((ComponentLifecycle)service.cast(PlatformComponentManager.getInstance().services.get(service)));
    }

    protected List<PlatformComponentExtension> getExtensions() {
        return IExtensionPointReader.create(PlatformComponentExtension.class).readAll();
    }

    @ExtensionPoint(extensionPointId="org.mule.component.platformComponent")
    public static class PlatformComponentExtension {
        @ExtensionAttribute(attributeName="class")
        private IPlatformComponentFactory<?> factory;

        public IPlatformComponentFactory<?> getFactory() {
            return this.factory;
        }

        public void setFactory(IPlatformComponentFactory<?> factory) {
            this.factory = factory;
        }
    }
}

