/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.builder.events;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.platform.builder.events.IDependenciesClasspathEventListener;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public class DependencyRemovedEvent
implements IEvent<IDependenciesClasspathEventListener> {
    private final IProject project;
    private List<MavenDependency> dependency;
    public static final EventType<IDependenciesClasspathEventListener> ON_DEPENDENCY_REMOVED = EventType.id((String)"ON_API_SPEC_REMOVED");

    public DependencyRemovedEvent(List<MavenDependency> dependency, IProject project) {
        this.dependency = dependency;
        this.project = project;
    }

    public EventType<IDependenciesClasspathEventListener> getAssociatedType() {
        return ON_DEPENDENCY_REMOVED;
    }

    public void dispatch(IDependenciesClasspathEventListener handler) {
        handler.onDependencyRemovedFromClasspath(this.dependency, this.project);
    }

    public String toString() {
        return "DependencyRemovedEvent [removedDependency=" + this.dependency.toString() + ", project=" + String.valueOf(this.project) + "]";
    }
}

