/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.builder.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.mule.tooling.core.utils.ProjectUtils;
import org.mule.tooling.platform.PlatformPlugin;
import org.mule.tooling.platform.builder.IProjectBuilder;
import org.mule.tooling.platform.builder.ProjectBuilderResult;
import org.mule.tooling.platform.builder.events.ArtifactsBuiltEvent;
import org.mule.tooling.platform.component.ProjectComponentManager;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.eventbus.IEvent;

public class InstallLocalHandler
extends AbstractHandler {
    private static final String ERROR_ON_INSTALLING_ARTIFACT_TITLE = "Error on installing artifact";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ProjectUtils.getIProjectFromSelection((ISelection)currentSelection).ifPresent(this::installLocal);
        return Status.OK_STATUS;
    }

    void installLocal(final IProject project) {
        final Optional<IProjectBuilder> projectComponent = this.getIProjectBuilderComponent(project);
        if (projectComponent.isPresent()) {
            try {
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(WidgetUtils.getShell());
                progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        final ProjectBuilderResult result = ((IProjectBuilder)projectComponent.get()).installLocal(monitor);
                        WidgetUtils.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!result.getResultStatus().isOK()) {
                                    InstallLocalHandler.this.showException(project, result.getResultStatus().getMessage());
                                } else {
                                    PlatformPlugin.getEventBus().fireEvent((IEvent)new ArtifactsBuiltEvent(result.getInstalledArtifacts()));
                                    MessageDialog.openInformation((Shell)WidgetUtils.getShell(), (String)"Artifacts Installed", (String)("`" + project.getName() + "` was installed successfully."));
                                }
                            }
                        });
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                WidgetUtils.showException((String)ERROR_ON_INSTALLING_ARTIFACT_TITLE, (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void showException(IProject project, String message) {
        message = message == null ? "" : message;
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        String[] stringArray = message.split(System.lineSeparator());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            childStatuses.add(new Status(4, "org.mule.tooling.ui.widgets", line));
            ++n2;
        }
        int mostSignificativeElements = 3;
        Object trimmedMessage = childStatuses.stream().skip(Math.max(0, childStatuses.size() - mostSignificativeElements)).map(s -> s.getMessage()).collect(Collectors.joining(System.lineSeparator()));
        trimmedMessage = (String)trimmedMessage + System.lineSeparator() + "(showing last " + mostSignificativeElements + " lines)";
        MultiStatus ms = new MultiStatus("org.mule.tooling.ui.widgets", 4, (IStatus[])childStatuses.toArray(new Status[0]), (String)trimmedMessage, null);
        String shortDescription = "There was a problem while installing arfitacts for `" + project.getName() + "`.";
        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ERROR_ON_INSTALLING_ARTIFACT_TITLE, (String)shortDescription, (IStatus)ms);
    }

    private Optional<IProjectBuilder> getIProjectBuilderComponent(IProject project) {
        return ProjectComponentManager.getProjectComponent(project, IProjectBuilder.class);
    }

    public boolean isEnabled() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        ISelectionService selectionService = workbenchWindow.getSelectionService();
        IStructuredSelection structured = (IStructuredSelection)selectionService.getSelection();
        return ProjectUtils.getIProjectFromSelection((ISelection)structured).map(o -> o.isOpen() && this.getIProjectBuilderComponent((IProject)o).isPresent()).orElseGet(() -> false);
    }
}

