/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform.builder;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.m2.dependency.MavenDependency;

public class ProjectBuilderResult {
    private List<MavenDependency> installedArtifacts;
    private IStatus resultStatus;

    public ProjectBuilderResult(List<MavenDependency> installedArtifacts, IStatus resultStatus) {
        this.installedArtifacts = installedArtifacts;
        this.resultStatus = resultStatus;
    }

    public List<MavenDependency> getInstalledArtifacts() {
        return this.installedArtifacts;
    }

    public IStatus getResultStatus() {
        return this.resultStatus;
    }

    public static ProjectBuilderResult createErrorResult(IStatus errorStatus) {
        return new ProjectBuilderResult(Collections.emptyList(), errorStatus);
    }

    public static ProjectBuilderResult createOkResult(MavenDependency ... artifacts) {
        return new ProjectBuilderResult(Arrays.asList(artifacts), Status.OK_STATUS);
    }

    public static ProjectBuilderResult createOkResult(List<MavenDependency> artifacts) {
        return new ProjectBuilderResult(artifacts, Status.OK_STATUS);
    }
}

