/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.platform;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.utils.eventbus.EventBus;
import org.osgi.framework.BundleContext;

public class PlatformPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.mule.tooling.platform";
    private static PlatformPlugin instance;
    private IEclipseContext serviceContext;
    private EventBus eventBus;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.serviceContext = EclipseContextFactory.createServiceContext((BundleContext)context);
        instance = this;
        this.eventBus = new EventBus();
    }

    public static EventBus getEventBus() {
        return PlatformPlugin.getInstance().eventBus;
    }

    public static IEclipseContext getServiceContext() {
        return PlatformPlugin.getInstance().serviceContext;
    }

    public static void logError(String message, Throwable t) {
        ILog logger;
        PlatformPlugin instance = PlatformPlugin.getInstance();
        if (instance != null && (logger = instance.getLog()) != null) {
            logger.log((IStatus)PlatformPlugin.createErrorStatus(message, t));
        }
    }

    public static void logError(String message) {
        ILog logger;
        PlatformPlugin instance = PlatformPlugin.getInstance();
        if (instance != null && (logger = instance.getLog()) != null) {
            logger.log((IStatus)PlatformPlugin.createErrorStatus(message));
        }
    }

    public static Status createErrorStatus(String message, Throwable t) {
        return new Status(4, ID, message, t);
    }

    public static Status createErrorStatus(String message) {
        return new Status(4, ID, message);
    }

    public static Status createInfoStatus(String message) {
        return new Status(1, ID, message);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static PlatformPlugin getInstance() {
        return instance;
    }
}

