/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility.dispatcher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.utility.GraalImageCode;
import net.bytebuddy.utility.Invoker;
import net.bytebuddy.utility.MethodComparator;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.privilege.GetSystemPropertyAction;

/*
 * Exception performing whole class analysis ignored.
 */
@HashCodeAndEqualsPlugin.Enhance
public class JavaDispatcher<T>
implements PrivilegedAction<T> {
    public static final String GENERATE_PROPERTY = "net.bytebuddy.generate";
    private static final boolean GENERATE;
    private static final DynamicClassLoader.Resolver RESOLVER;
    private static final Invoker INVOKER;
    private final Class<T> proxy;
    @MaybeNull
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
    private final ClassLoader classLoader;
    private final boolean generate;
    private static final boolean ACCESS_CONTROLLER;

    protected JavaDispatcher(Class<T> proxy, @MaybeNull ClassLoader classLoader, boolean generate) {
        this.proxy = proxy;
        this.classLoader = classLoader;
        this.generate = generate;
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return action.run();
    }

    public static <T> PrivilegedAction<T> of(Class<T> type) {
        return JavaDispatcher.of(type, null);
    }

    public static <T> PrivilegedAction<T> of(Class<T> type, @MaybeNull ClassLoader classLoader) {
        return JavaDispatcher.of(type, (ClassLoader)classLoader, (boolean)GENERATE);
    }

    protected static <T> PrivilegedAction<T> of(Class<T> type, @MaybeNull ClassLoader classLoader, boolean generate) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Expected an interface instead of " + type);
        }
        if (!type.isAnnotationPresent(Proxied.class)) {
            throw new IllegalArgumentException("Expected " + type.getName() + " to be annotated with " + Proxied.class.getName());
        }
        if (type.getAnnotation(Proxied.class).value().startsWith("java.security.")) {
            throw new IllegalArgumentException("Classes related to Java security cannot be proxied: " + type.getName());
        }
        return new JavaDispatcher(type, classLoader, generate);
    }

    @Override
    public T run() {
        Class<?> target;
        try {
            Object securityManager = System.class.getMethod("getSecurityManager", new Class[0]).invoke(null, new Object[0]);
            if (securityManager != null) {
                Object permission = Class.forName("java.lang.RuntimePermission").getConstructor(String.class).newInstance("net.bytebuddy.createJavaDispatcher");
                Class.forName("java.lang.SecurityManager").getMethod("checkPermission", Permission.class).invoke(securityManager, permission);
            }
        }
        catch (NoSuchMethodException securityManager) {
        }
        catch (ClassNotFoundException securityManager) {
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Failed to assert access rights using security manager", cause);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("Failed to access security manager", exception);
        }
        catch (InstantiationException exception) {
            throw new IllegalStateException("Failed to instantiate runtime permission", exception);
        }
        HashMap dispatchers = this.generate ? new LinkedHashMap() : new HashMap();
        boolean defaults = this.proxy.isAnnotationPresent(Defaults.class);
        String name = this.proxy.getAnnotation(Proxied.class).value();
        try {
            target = Class.forName(name, false, this.classLoader);
        }
        catch (ClassNotFoundException exception) {
            for (Method method : this.generate ? (Method[])GraalImageCode.getCurrent().sorted((Object[])this.proxy.getMethods(), (Comparator)MethodComparator.INSTANCE) : this.proxy.getMethods()) {
                if (method.getDeclaringClass() == Object.class) continue;
                if (method.isAnnotationPresent(Instance.class)) {
                    if (method.getParameterTypes().length != 1 || method.getParameterTypes()[0].isPrimitive() || method.getParameterTypes()[0].isArray()) {
                        throw new IllegalStateException("Instance check requires a single regular-typed argument: " + method);
                    }
                    if (method.getReturnType() != Boolean.TYPE) {
                        throw new IllegalStateException("Instance check requires a boolean return type: " + method);
                    }
                    dispatchers.put(method, Dispatcher.ForDefaultValue.BOOLEAN);
                    continue;
                }
                dispatchers.put(method, defaults || method.isAnnotationPresent(Defaults.class) ? Dispatcher.ForDefaultValue.of(method.getReturnType()) : new Dispatcher.ForUnresolvedMethod("Type not available on current VM: " + exception.getMessage()));
            }
            if (this.generate) {
                return (T)DynamicClassLoader.proxy((Class)this.proxy, dispatchers);
            }
            return (T)Proxy.newProxyInstance(this.proxy.getClassLoader(), new Class[]{this.proxy}, (InvocationHandler)new ProxiedInvocationHandler(name, dispatchers));
        }
        boolean generate = this.generate;
        for (Method method : generate ? (Method[])GraalImageCode.getCurrent().sorted((Object[])this.proxy.getMethods(), (Comparator)MethodComparator.INSTANCE) : this.proxy.getMethods()) {
            if (method.getDeclaringClass() == Object.class) continue;
            if (method.isAnnotationPresent(Instance.class)) {
                if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(target)) {
                    throw new IllegalStateException("Instance check requires a single regular-typed argument: " + method);
                }
                if (method.getReturnType() != Boolean.TYPE) {
                    throw new IllegalStateException("Instance check requires a boolean return type: " + method);
                }
                dispatchers.put(method, new Dispatcher.ForInstanceCheck(target));
                continue;
            }
            if (method.isAnnotationPresent(Container.class)) {
                if (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Integer.TYPE) {
                    throw new IllegalStateException("Container creation requires a single int-typed argument: " + method);
                }
                if (!method.getReturnType().isArray() || !method.getReturnType().getComponentType().isAssignableFrom(target)) {
                    throw new IllegalStateException("Container creation requires an assignable array as return value: " + method);
                }
                dispatchers.put(method, new Dispatcher.ForContainerCreation(target));
                continue;
            }
            if (target.getName().equals("java.lang.invoke.MethodHandles") && method.getName().equals("lookup")) {
                throw new UnsupportedOperationException("Cannot resolve Byte Buddy lookup via dispatcher");
            }
            try {
                int offset;
                Class<?>[] parameterType = method.getParameterTypes();
                if (method.isAnnotationPresent(IsStatic.class) || method.isAnnotationPresent(IsConstructor.class)) {
                    offset = 0;
                } else {
                    offset = 1;
                    if (parameterType.length == 0) {
                        throw new IllegalStateException("Expected self type: " + method);
                    }
                    if (!parameterType[0].isAssignableFrom(target)) {
                        throw new IllegalStateException("Cannot assign self type: " + target + " on " + method);
                    }
                    Class[] adjusted = new Class[parameterType.length - 1];
                    System.arraycopy(parameterType, 1, adjusted, 0, adjusted.length);
                    parameterType = adjusted;
                }
                Annotation[][] parameterAnnotation = method.getParameterAnnotations();
                block14: for (int index = 0; index < parameterType.length; ++index) {
                    for (Annotation annotation : parameterAnnotation[index + offset]) {
                        if (!(annotation instanceof Proxied)) continue;
                        int arity = 0;
                        while (parameterType[index].isArray()) {
                            ++arity;
                            parameterType[index] = parameterType[index].getComponentType();
                        }
                        if (arity > 0) {
                            if (parameterType[index].isPrimitive()) {
                                throw new IllegalStateException("Primitive values are not supposed to be proxied: " + index + " of " + method);
                            }
                            if (!parameterType[index].isAssignableFrom(Class.forName(((Proxied)annotation).value(), false, this.classLoader))) {
                                throw new IllegalStateException("Cannot resolve to component type: " + ((Proxied)annotation).value() + " at " + index + " of " + method);
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            while (arity-- > 0) {
                                stringBuilder.append('[');
                            }
                            parameterType[index] = Class.forName(stringBuilder.append('L').append(((Proxied)annotation).value()).append(';').toString(), false, this.classLoader);
                            continue block14;
                        }
                        Class<?> resolved = Class.forName(((Proxied)annotation).value(), false, this.classLoader);
                        if (!parameterType[index].isAssignableFrom(resolved)) {
                            throw new IllegalStateException("Cannot resolve to type: " + resolved.getName() + " at " + index + " of " + method);
                        }
                        parameterType[index] = resolved;
                        continue block14;
                    }
                }
                if (method.isAnnotationPresent(IsConstructor.class)) {
                    Constructor<?> resolved = target.getConstructor(parameterType);
                    if (!method.getReturnType().isAssignableFrom(target)) {
                        throw new IllegalStateException("Cannot assign " + resolved.getDeclaringClass().getName() + " to " + method);
                    }
                    if ((resolved.getModifiers() & 1) == 0 || (target.getModifiers() & 1) == 0) {
                        resolved.setAccessible(true);
                        generate = false;
                    }
                    dispatchers.put(method, new Dispatcher.ForConstructor(resolved));
                    continue;
                }
                Proxied proxied = method.getAnnotation(Proxied.class);
                Method resolved = target.getMethod(proxied == null ? method.getName() : proxied.value(), parameterType);
                if (!method.getReturnType().isAssignableFrom(resolved.getReturnType())) {
                    throw new IllegalStateException("Cannot assign " + resolved.getReturnType().getName() + " to " + method);
                }
                block18: for (Class<?> type : resolved.getExceptionTypes()) {
                    if (RuntimeException.class.isAssignableFrom(type) || Error.class.isAssignableFrom(type)) continue;
                    for (Class<?> exception : method.getExceptionTypes()) {
                        if (exception.isAssignableFrom(type)) continue block18;
                    }
                    throw new IllegalStateException("Resolved method for " + method + " throws undeclared checked exception " + type.getName());
                }
                if ((resolved.getModifiers() & 1) == 0 || (resolved.getDeclaringClass().getModifiers() & 1) == 0) {
                    resolved.setAccessible(true);
                    generate = false;
                }
                if (Modifier.isStatic(resolved.getModifiers())) {
                    if (!method.isAnnotationPresent(IsStatic.class)) {
                        throw new IllegalStateException("Resolved method for " + method + " was expected to be static: " + resolved);
                    }
                    dispatchers.put(method, new Dispatcher.ForStaticMethod(resolved));
                    continue;
                }
                if (method.isAnnotationPresent(IsStatic.class)) {
                    throw new IllegalStateException("Resolved method for " + method + " was expected to be virtual: " + resolved);
                }
                dispatchers.put(method, new Dispatcher.ForNonStaticMethod(resolved));
            }
            catch (ClassNotFoundException exception) {
                dispatchers.put(method, defaults || method.isAnnotationPresent(Defaults.class) ? Dispatcher.ForDefaultValue.of(method.getReturnType()) : new Dispatcher.ForUnresolvedMethod("Class not available on current VM: " + exception.getMessage()));
            }
            catch (NoSuchMethodException exception) {
                dispatchers.put(method, defaults || method.isAnnotationPresent(Defaults.class) ? Dispatcher.ForDefaultValue.of(method.getReturnType()) : new Dispatcher.ForUnresolvedMethod("Method not available on current VM: " + exception.getMessage()));
            }
            catch (Throwable throwable) {
                dispatchers.put(method, new Dispatcher.ForUnresolvedMethod("Unexpected error: " + throwable.getMessage()));
            }
        }
        if (generate) {
            return (T)DynamicClassLoader.proxy((Class)this.proxy, dispatchers);
        }
        return (T)Proxy.newProxyInstance(this.proxy.getClassLoader(), new Class[]{this.proxy}, (InvocationHandler)new ProxiedInvocationHandler(target.getName(), (Map)dispatchers));
    }

    static /* synthetic */ Invoker access$100() {
        return INVOKER;
    }

    static /* synthetic */ Object access$200(PrivilegedAction x0) {
        return JavaDispatcher.doPrivileged((PrivilegedAction)x0);
    }

    static /* synthetic */ DynamicClassLoader.Resolver access$300() {
        return RESOLVER;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        GENERATE = Boolean.parseBoolean((String)JavaDispatcher.doPrivileged((PrivilegedAction)new GetSystemPropertyAction("net.bytebuddy.generate")));
        RESOLVER = (DynamicClassLoader.Resolver)JavaDispatcher.doPrivileged((PrivilegedAction)DynamicClassLoader.Resolver.CreationAction.INSTANCE);
        INVOKER = (Invoker)JavaDispatcher.doPrivileged((PrivilegedAction)new InvokerCreationAction(null));
    }

    public boolean equals(@MaybeNull Object object) {
        block12: {
            block11: {
                ClassLoader classLoader;
                block10: {
                    ClassLoader classLoader2;
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (this.generate != ((JavaDispatcher)object).generate) {
                        return false;
                    }
                    if (!this.proxy.equals(((JavaDispatcher)object).proxy)) {
                        return false;
                    }
                    ClassLoader classLoader3 = ((JavaDispatcher)object).classLoader;
                    classLoader = classLoader2 = this.classLoader;
                    if (classLoader3 == null) break block10;
                    if (classLoader == null) break block11;
                    if (!classLoader2.equals(classLoader3)) {
                        return false;
                    }
                    break block12;
                }
                if (classLoader == null) break block12;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = (this.getClass().hashCode() * 31 + this.proxy.hashCode()) * 31;
        ClassLoader classLoader = this.classLoader;
        if (classLoader != null) {
            n = n + classLoader.hashCode();
        }
        return n * 31 + this.generate;
    }
}

