/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.module.ModuleDescription;
import net.bytebuddy.description.type.PackageDescription;
import net.bytebuddy.utility.JavaModule;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class JavaModule
implements NamedElement.WithOptionalName,
AnnotationSource {
    @AlwaysNull
    public static final JavaModule UNSUPPORTED;
    protected static final Resolver RESOLVER;
    protected static final Module MODULE;
    private final AnnotatedElement module;
    private static final boolean ACCESS_CONTROLLER;

    protected JavaModule(AnnotatedElement module) {
        this.module = module;
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return action.run();
    }

    @MaybeNull
    public static JavaModule ofType(Class<?> type) {
        Object module = RESOLVER.getModule(type);
        return module == null ? UNSUPPORTED : new JavaModule((AnnotatedElement)module);
    }

    public static JavaModule of(Object module) {
        if (!MODULE.isInstance(module)) {
            throw new IllegalArgumentException("Not a Java module: " + module);
        }
        return new JavaModule((AnnotatedElement)module);
    }

    public static boolean isSupported() {
        return ClassFileVersion.ofThisVm((ClassFileVersion)ClassFileVersion.JAVA_V5).isAtLeast(ClassFileVersion.JAVA_V9);
    }

    public boolean isNamed() {
        return MODULE.isNamed((Object)this.module);
    }

    public String getActualName() {
        return MODULE.getName((Object)this.module);
    }

    public Set<String> getPackages() {
        return MODULE.getPackages((Object)this.module);
    }

    @MaybeNull
    public InputStream getResourceAsStream(String name) throws IOException {
        return MODULE.getResourceAsStream((Object)this.module, name);
    }

    @MaybeNull
    public ClassLoader getClassLoader() {
        return MODULE.getClassLoader((Object)this.module);
    }

    public Object unwrap() {
        return this.module;
    }

    public boolean canRead(JavaModule module) {
        return MODULE.canRead((Object)this.module, module.unwrap());
    }

    public boolean isExported(@MaybeNull PackageDescription packageDescription, JavaModule module) {
        return packageDescription == null || packageDescription.isDefault() || MODULE.isExported((Object)this.module, packageDescription.getName(), module.unwrap());
    }

    public boolean isOpened(@MaybeNull PackageDescription packageDescription, JavaModule module) {
        return packageDescription == null || packageDescription.isDefault() || MODULE.isOpen((Object)this.module, packageDescription.getName(), module.unwrap());
    }

    public AnnotationList getDeclaredAnnotations() {
        return new AnnotationList.ForLoadedAnnotations(this.module.getDeclaredAnnotations());
    }

    public ModuleDescription toDescription() {
        return ModuleDescription.ForLoadedModule.of((Object)this.module);
    }

    public int hashCode() {
        return this.module.hashCode();
    }

    public boolean equals(@MaybeNull Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaModule)) {
            return false;
        }
        JavaModule javaModule = (JavaModule)other;
        return this.module.equals(javaModule.module);
    }

    public String toString() {
        return this.module.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        UNSUPPORTED = null;
        RESOLVER = (Resolver)JavaModule.doPrivileged((PrivilegedAction)JavaDispatcher.of(Resolver.class));
        MODULE = (Module)JavaModule.doPrivileged((PrivilegedAction)JavaDispatcher.of(Module.class));
    }
}

