/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.matcher.AccessibilityMatcher;
import net.bytebuddy.matcher.AnnotationTargetMatcher;
import net.bytebuddy.matcher.AnnotationTypeMatcher;
import net.bytebuddy.matcher.ArrayTypeMatcher;
import net.bytebuddy.matcher.BooleanMatcher;
import net.bytebuddy.matcher.CachingMatcher;
import net.bytebuddy.matcher.ClassFileVersionMatcher;
import net.bytebuddy.matcher.ClassLoaderHierarchyMatcher;
import net.bytebuddy.matcher.ClassLoaderParentMatcher;
import net.bytebuddy.matcher.CollectionElementMatcher;
import net.bytebuddy.matcher.CollectionErasureMatcher;
import net.bytebuddy.matcher.CollectionItemMatcher;
import net.bytebuddy.matcher.CollectionOneToOneMatcher;
import net.bytebuddy.matcher.CollectionSizeMatcher;
import net.bytebuddy.matcher.DeclaringAnnotationMatcher;
import net.bytebuddy.matcher.DeclaringFieldMatcher;
import net.bytebuddy.matcher.DeclaringMethodMatcher;
import net.bytebuddy.matcher.DeclaringTypeMatcher;
import net.bytebuddy.matcher.DefinedShapeMatcher;
import net.bytebuddy.matcher.DescriptorMatcher;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.EqualityMatcher;
import net.bytebuddy.matcher.ErasureMatcher;
import net.bytebuddy.matcher.FailSafeMatcher;
import net.bytebuddy.matcher.FieldTypeMatcher;
import net.bytebuddy.matcher.HasSuperClassMatcher;
import net.bytebuddy.matcher.HasSuperTypeMatcher;
import net.bytebuddy.matcher.InheritedAnnotationMatcher;
import net.bytebuddy.matcher.InstanceTypeMatcher;
import net.bytebuddy.matcher.IsNamedMatcher;
import net.bytebuddy.matcher.MethodExceptionTypeMatcher;
import net.bytebuddy.matcher.MethodOverrideMatcher;
import net.bytebuddy.matcher.MethodParameterTypeMatcher;
import net.bytebuddy.matcher.MethodParameterTypesMatcher;
import net.bytebuddy.matcher.MethodParametersMatcher;
import net.bytebuddy.matcher.MethodReturnTypeMatcher;
import net.bytebuddy.matcher.MethodSortMatcher;
import net.bytebuddy.matcher.ModifierMatcher;
import net.bytebuddy.matcher.NameMatcher;
import net.bytebuddy.matcher.NegatingMatcher;
import net.bytebuddy.matcher.NullMatcher;
import net.bytebuddy.matcher.PrimitiveTypeMatcher;
import net.bytebuddy.matcher.RecordMatcher;
import net.bytebuddy.matcher.SignatureTokenMatcher;
import net.bytebuddy.matcher.StringMatcher;
import net.bytebuddy.matcher.StringSetMatcher;
import net.bytebuddy.matcher.SubTypeMatcher;
import net.bytebuddy.matcher.SuperTypeMatcher;
import net.bytebuddy.matcher.TypeSortMatcher;
import net.bytebuddy.matcher.VisibilityMatcher;
import net.bytebuddy.utility.JavaModule;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ElementMatchers {
    private ElementMatchers() {
        throw new UnsupportedOperationException("This class is a utility class and not supposed to be instantiated");
    }

    public static <T> ElementMatcher.Junction<T> failSafe(ElementMatcher<? super T> matcher) {
        return new FailSafeMatcher(matcher, false);
    }

    public static <T> ElementMatcher.Junction<T> cached(ElementMatcher<? super T> matcher, ConcurrentMap<? super T, Boolean> map) {
        return new CachingMatcher(matcher, map);
    }

    public static <T> ElementMatcher.Junction<T> cached(ElementMatcher<? super T> matcher, int evictionSize) {
        if (evictionSize < 1) {
            throw new IllegalArgumentException("Eviction size must be a positive number: " + evictionSize);
        }
        return new CachingMatcher.WithInlineEviction(matcher, new ConcurrentHashMap(), evictionSize);
    }

    public static <T> ElementMatcher.Junction<T> is(@MaybeNull Object value) {
        return value == null ? NullMatcher.make() : new EqualityMatcher(value);
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> is(Field field) {
        return ElementMatchers.is((FieldDescription.InDefinedShape)new FieldDescription.ForLoadedField(field));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> is(FieldDescription.InDefinedShape field) {
        return ElementMatchers.definedField((ElementMatcher)new EqualityMatcher((Object)field));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> definedField(ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
        return new DefinedShapeMatcher(matcher);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(Method method) {
        return ElementMatchers.is((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(method));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(Constructor<?> constructor) {
        return ElementMatchers.is((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> is(MethodDescription.InDefinedShape method) {
        return ElementMatchers.definedMethod((ElementMatcher)new EqualityMatcher((Object)method));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> definedMethod(ElementMatcher<? super MethodDescription.InDefinedShape> matcher) {
        return new DefinedShapeMatcher(matcher);
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> is(ParameterDescription.InDefinedShape parameter) {
        return ElementMatchers.definedParameter((ElementMatcher)new EqualityMatcher((Object)parameter));
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> definedParameter(ElementMatcher<? super ParameterDescription.InDefinedShape> matcher) {
        return new DefinedShapeMatcher(matcher);
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> hasType(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasGenericType((ElementMatcher)ElementMatchers.erasure(matcher));
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> hasGenericType(ElementMatcher<? super TypeDescription.Generic> matcher) {
        return new MethodParameterTypeMatcher(matcher);
    }

    public static <T extends ParameterDescription> ElementMatcher.Junction<T> isMandated() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.MANDATED);
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> is(Type type) {
        return ElementMatchers.is((Object)TypeDefinition.Sort.describe((Type)type));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> is(Annotation annotation) {
        return ElementMatchers.is((Object)AnnotationDescription.ForLoadedAnnotation.of((Annotation)annotation));
    }

    public static <T> ElementMatcher.Junction<T> not(ElementMatcher<? super T> matcher) {
        return new NegatingMatcher(matcher);
    }

    public static <T> ElementMatcher.Junction<T> any() {
        return BooleanMatcher.of((boolean)true);
    }

    public static <T> ElementMatcher.Junction<T> none() {
        return BooleanMatcher.of((boolean)false);
    }

    public static <T> ElementMatcher.Junction<T> anyOf(Object ... value) {
        return ElementMatchers.anyOf(Arrays.asList(value));
    }

    public static <T> ElementMatcher.Junction<T> anyOf(Iterable<?> values) {
        ElementMatcher.Junction matcher = null;
        for (Object value : values) {
            matcher = matcher == null ? ElementMatchers.is(value) : matcher.or((ElementMatcher)ElementMatchers.is(value));
        }
        return matcher == null ? ElementMatchers.none() : matcher;
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> anyOf(Type ... value) {
        return ElementMatchers.anyOf((Iterable)new TypeList.Generic.ForLoadedTypes(value));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> anyOf(Constructor<?> ... value) {
        return ElementMatchers.definedMethod((ElementMatcher)ElementMatchers.anyOf((Iterable)new MethodList.ForLoadedMethods((Constructor[])value, new Method[0])));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> anyOf(Method ... value) {
        return ElementMatchers.definedMethod((ElementMatcher)ElementMatchers.anyOf((Iterable)new MethodList.ForLoadedMethods(new Constructor[0], value)));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> anyOf(Field ... value) {
        return ElementMatchers.definedField((ElementMatcher)ElementMatchers.anyOf((Iterable)new FieldList.ForLoadedFields(value)));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> anyOf(Annotation ... value) {
        return ElementMatchers.anyOf((Iterable)new AnnotationList.ForLoadedAnnotations(value));
    }

    public static <T> ElementMatcher.Junction<T> noneOf(Object ... value) {
        return ElementMatchers.noneOf(Arrays.asList(value));
    }

    public static <T> ElementMatcher.Junction<T> noneOf(Iterable<?> values) {
        ElementMatcher.Junction matcher = null;
        for (Object value : values) {
            matcher = matcher == null ? ElementMatchers.not((ElementMatcher)ElementMatchers.is(value)) : matcher.and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.is(value)));
        }
        return matcher == null ? ElementMatchers.any() : matcher;
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> noneOf(Type ... value) {
        return ElementMatchers.noneOf((Iterable)new TypeList.Generic.ForLoadedTypes(value));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> noneOf(Constructor<?> ... value) {
        return ElementMatchers.definedMethod((ElementMatcher)ElementMatchers.noneOf((Iterable)new MethodList.ForLoadedMethods((Constructor[])value, new Method[0])));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> noneOf(Method ... value) {
        return ElementMatchers.definedMethod((ElementMatcher)ElementMatchers.noneOf((Iterable)new MethodList.ForLoadedMethods(new Constructor[0], value)));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> noneOf(Field ... value) {
        return ElementMatchers.definedField((ElementMatcher)ElementMatchers.noneOf((Iterable)new FieldList.ForLoadedFields(value)));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> noneOf(Annotation ... value) {
        return ElementMatchers.noneOf((Iterable)new AnnotationList.ForLoadedAnnotations(value));
    }

    public static <T> ElementMatcher.Junction<Iterable<? extends T>> whereAny(ElementMatcher<? super T> matcher) {
        return new CollectionItemMatcher(matcher);
    }

    public static <T> ElementMatcher.Junction<Iterable<? extends T>> whereNone(ElementMatcher<? super T> matcher) {
        return ElementMatchers.not((ElementMatcher)ElementMatchers.whereAny(matcher));
    }

    public static <T extends TypeDescription.Generic> ElementMatcher.Junction<T> erasure(Class<?> type) {
        return ElementMatchers.erasure((ElementMatcher)ElementMatchers.is(type));
    }

    public static <T extends TypeDescription.Generic> ElementMatcher.Junction<T> erasure(TypeDescription type) {
        return ElementMatchers.erasure((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends TypeDescription.Generic> ElementMatcher.Junction<T> erasure(ElementMatcher<? super TypeDescription> matcher) {
        return new ErasureMatcher(matcher);
    }

    public static <T extends Iterable<? extends TypeDescription.Generic>> ElementMatcher.Junction<T> erasures(Class<?> ... type) {
        return ElementMatchers.erasures((Iterable)new TypeList.ForLoadedTypes((Class[])type));
    }

    public static <T extends Iterable<? extends TypeDescription.Generic>> ElementMatcher.Junction<T> erasures(TypeDescription ... type) {
        return ElementMatchers.erasures(Arrays.asList(type));
    }

    public static <T extends Iterable<? extends TypeDescription.Generic>> ElementMatcher.Junction<T> erasures(Iterable<? extends TypeDescription> types) {
        ArrayList<ElementMatcher.Junction> typeMatchers = new ArrayList<ElementMatcher.Junction>();
        for (TypeDescription typeDescription : types) {
            typeMatchers.add(ElementMatchers.is((Object)typeDescription));
        }
        return ElementMatchers.erasures((ElementMatcher)new CollectionOneToOneMatcher(typeMatchers));
    }

    public static <T extends Iterable<? extends TypeDescription.Generic>> ElementMatcher.Junction<T> erasures(ElementMatcher<? super Iterable<? extends TypeDescription>> matcher) {
        return new CollectionErasureMatcher(matcher);
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> isVariable(String symbol) {
        return ElementMatchers.isVariable((ElementMatcher)ElementMatchers.named((String)symbol));
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> isVariable(ElementMatcher<? super NamedElement> matcher) {
        return new TypeSortMatcher((ElementMatcher)ElementMatchers.anyOf((Object[])new Object[]{TypeDefinition.Sort.VARIABLE, TypeDefinition.Sort.VARIABLE_SYMBOLIC})).and(matcher);
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> named(String name) {
        return new NameMatcher((ElementMatcher)new StringMatcher(name, StringMatcher.Mode.EQUALS_FULLY));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> namedOneOf(String ... names) {
        return new NameMatcher((ElementMatcher)new StringSetMatcher(new HashSet<String>(Arrays.asList(names))));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> namedIgnoreCase(String name) {
        return new NameMatcher((ElementMatcher)new StringMatcher(name, StringMatcher.Mode.EQUALS_FULLY_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameStartsWith(String prefix) {
        return new NameMatcher((ElementMatcher)new StringMatcher(prefix, StringMatcher.Mode.STARTS_WITH));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameStartsWithIgnoreCase(String prefix) {
        return new NameMatcher((ElementMatcher)new StringMatcher(prefix, StringMatcher.Mode.STARTS_WITH_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameEndsWith(String suffix) {
        return new NameMatcher((ElementMatcher)new StringMatcher(suffix, StringMatcher.Mode.ENDS_WITH));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameEndsWithIgnoreCase(String suffix) {
        return new NameMatcher((ElementMatcher)new StringMatcher(suffix, StringMatcher.Mode.ENDS_WITH_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameContains(String infix) {
        return new NameMatcher((ElementMatcher)new StringMatcher(infix, StringMatcher.Mode.CONTAINS));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameContainsIgnoreCase(String infix) {
        return new NameMatcher((ElementMatcher)new StringMatcher(infix, StringMatcher.Mode.CONTAINS_IGNORE_CASE));
    }

    public static <T extends NamedElement> ElementMatcher.Junction<T> nameMatches(String regex) {
        return new NameMatcher((ElementMatcher)new StringMatcher(regex, StringMatcher.Mode.MATCHES));
    }

    public static <T extends NamedElement.WithOptionalName> ElementMatcher.Junction<T> isNamed() {
        return new IsNamedMatcher();
    }

    public static <T extends NamedElement.WithDescriptor> ElementMatcher.Junction<T> hasDescriptor(String descriptor) {
        return new DescriptorMatcher((ElementMatcher)new StringMatcher(descriptor, StringMatcher.Mode.EQUALS_FULLY));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(Class<?> type) {
        return ElementMatchers.isDeclaredBy((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(TypeDescription type) {
        return ElementMatchers.isDeclaredBy((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredBy(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isDeclaredByGeneric((ElementMatcher)ElementMatchers.erasure(matcher));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredByGeneric(Type type) {
        return ElementMatchers.isDeclaredByGeneric((TypeDescription.Generic)TypeDefinition.Sort.describe((Type)type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredByGeneric(TypeDescription.Generic type) {
        return ElementMatchers.isDeclaredByGeneric((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isDeclaredByGeneric(ElementMatcher<? super TypeDescription.Generic> matcher) {
        return new DeclaringTypeMatcher(matcher);
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isVisibleTo(Class<?> type) {
        return ElementMatchers.isVisibleTo((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isVisibleTo(TypeDescription type) {
        return new VisibilityMatcher(type);
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isAccessibleTo(Class<?> type) {
        return ElementMatchers.isAccessibleTo((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends ByteCodeElement> ElementMatcher.Junction<T> isAccessibleTo(TypeDescription type) {
        return new AccessibilityMatcher(type);
    }

    public static <T extends ModifierReviewable.OfAbstraction> ElementMatcher.Junction<T> isAbstract() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.ABSTRACT);
    }

    public static <T extends ModifierReviewable.OfEnumeration> ElementMatcher.Junction<T> isEnum() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.ENUMERATION);
    }

    public static <T extends AnnotationSource> ElementMatcher.Junction<T> isAnnotatedWith(Class<? extends Annotation> type) {
        return ElementMatchers.isAnnotatedWith((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends AnnotationSource> ElementMatcher.Junction<T> isAnnotatedWith(TypeDescription type) {
        return ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends AnnotationSource> ElementMatcher.Junction<T> isAnnotatedWith(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.declaresAnnotation((ElementMatcher)ElementMatchers.annotationType(matcher));
    }

    public static <T extends AnnotationSource> ElementMatcher.Junction<T> declaresAnnotation(ElementMatcher<? super AnnotationDescription> matcher) {
        return new DeclaringAnnotationMatcher((ElementMatcher)new CollectionItemMatcher(matcher));
    }

    public static <T extends ModifierReviewable.OfByteCodeElement> ElementMatcher.Junction<T> isPublic() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.PUBLIC);
    }

    public static <T extends ModifierReviewable.OfByteCodeElement> ElementMatcher.Junction<T> isProtected() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.PROTECTED);
    }

    public static <T extends ModifierReviewable.OfByteCodeElement> ElementMatcher.Junction<T> isPackagePrivate() {
        return ElementMatchers.not((ElementMatcher)ElementMatchers.isPublic().or((ElementMatcher)ElementMatchers.isProtected()).or((ElementMatcher)ElementMatchers.isPrivate()));
    }

    public static <T extends ModifierReviewable.OfByteCodeElement> ElementMatcher.Junction<T> isPrivate() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.PRIVATE);
    }

    public static <T extends ModifierReviewable.OfByteCodeElement> ElementMatcher.Junction<T> isStatic() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.STATIC);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isFinal() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.FINAL);
    }

    public static <T extends ModifierReviewable> ElementMatcher.Junction<T> isSynthetic() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.SYNTHETIC);
    }

    public static <T extends ModifierReviewable.ForMethodDescription> ElementMatcher.Junction<T> isSynchronized() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.SYNCHRONIZED);
    }

    public static <T extends ModifierReviewable.ForMethodDescription> ElementMatcher.Junction<T> isNative() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.NATIVE);
    }

    public static <T extends ModifierReviewable.ForMethodDescription> ElementMatcher.Junction<T> isStrict() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.STRICT);
    }

    public static <T extends ModifierReviewable.ForMethodDescription> ElementMatcher.Junction<T> isVarArgs() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.VAR_ARGS);
    }

    public static <T extends ModifierReviewable.ForMethodDescription> ElementMatcher.Junction<T> isBridge() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.BRIDGE);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returnsGeneric(Type type) {
        return ElementMatchers.returnsGeneric((TypeDescription.Generic)TypeDefinition.Sort.describe((Type)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returnsGeneric(TypeDescription.Generic type) {
        return ElementMatchers.returnsGeneric((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(Class<?> type) {
        return ElementMatchers.returnsGeneric((ElementMatcher)ElementMatchers.erasure(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(TypeDescription type) {
        return ElementMatchers.returns((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returns(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.returnsGeneric((ElementMatcher)ElementMatchers.erasure(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> returnsGeneric(ElementMatcher<? super TypeDescription.Generic> matcher) {
        return new MethodReturnTypeMatcher(matcher);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArgument(int index, Type type) {
        return ElementMatchers.takesGenericArgument((int)index, (TypeDescription.Generic)TypeDefinition.Sort.describe((Type)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArgument(int index, TypeDescription.Generic type) {
        return ElementMatchers.takesGenericArgument((int)index, (ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArgument(int index, ElementMatcher<? super TypeDescription.Generic> matcher) {
        return ElementMatchers.takesGenericArguments((ElementMatcher)new CollectionElementMatcher(index, matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(Type ... type) {
        return ElementMatchers.takesGenericArguments((List)new TypeList.Generic.ForLoadedTypes(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(TypeDefinition ... type) {
        return ElementMatchers.takesGenericArguments(Arrays.asList(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(List<? extends TypeDefinition> types) {
        ArrayList<ElementMatcher.Junction> typeMatchers = new ArrayList<ElementMatcher.Junction>();
        for (TypeDefinition typeDefinition : types) {
            typeMatchers.add(ElementMatchers.is((Object)typeDefinition));
        }
        return ElementMatchers.takesGenericArguments((ElementMatcher)new CollectionOneToOneMatcher(typeMatchers));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesGenericArguments(ElementMatcher<? super Iterable<? extends TypeDescription.Generic>> matchers) {
        return new MethodParametersMatcher((ElementMatcher)new MethodParameterTypesMatcher(matchers));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArgument(int index, Class<?> type) {
        return ElementMatchers.takesArgument((int)index, (TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArgument(int index, TypeDescription type) {
        return ElementMatchers.takesArgument((int)index, (ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArgument(int index, ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.takesGenericArgument((int)index, (ElementMatcher)ElementMatchers.erasure(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(Class<?> ... type) {
        return ElementMatchers.takesGenericArguments((ElementMatcher)ElementMatchers.erasures((Class[])type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(TypeDescription ... type) {
        return ElementMatchers.takesGenericArguments((ElementMatcher)ElementMatchers.erasures((TypeDescription[])type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(Iterable<? extends TypeDescription> types) {
        ArrayList<ElementMatcher.Junction> typeMatchers = new ArrayList<ElementMatcher.Junction>();
        for (TypeDescription typeDescription : types) {
            typeMatchers.add(ElementMatchers.erasure((TypeDescription)typeDescription));
        }
        return ElementMatchers.takesGenericArguments((ElementMatcher)new CollectionOneToOneMatcher(typeMatchers));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(ElementMatcher<? super Iterable<? extends TypeDescription>> matchers) {
        return new MethodParametersMatcher((ElementMatcher)new MethodParameterTypesMatcher((ElementMatcher)ElementMatchers.erasures(matchers)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesArguments(int length) {
        return new MethodParametersMatcher((ElementMatcher)new CollectionSizeMatcher(length));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> takesNoArguments() {
        return ElementMatchers.takesArguments((int)0);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> hasParameters(ElementMatcher<? super Iterable<? extends ParameterDescription>> matcher) {
        return new MethodParametersMatcher(matcher);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> canThrow(Class<? extends Throwable> exceptionType) {
        return ElementMatchers.canThrow((TypeDescription)TypeDescription.ForLoadedType.of(exceptionType));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> canThrow(TypeDescription exceptionType) {
        return exceptionType.isAssignableTo(RuntimeException.class) || exceptionType.isAssignableTo(Error.class) ? BooleanMatcher.of((boolean)true) : ElementMatchers.declaresGenericException((ElementMatcher)new CollectionItemMatcher((ElementMatcher)ElementMatchers.erasure((ElementMatcher)ElementMatchers.isSuperTypeOf((TypeDescription)exceptionType))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresGenericException(Type exceptionType) {
        return ElementMatchers.declaresGenericException((TypeDescription.Generic)TypeDefinition.Sort.describe((Type)exceptionType));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresGenericException(TypeDescription.Generic exceptionType) {
        return !exceptionType.getSort().isWildcard() && exceptionType.asErasure().isAssignableTo(Throwable.class) ? ElementMatchers.declaresGenericException((ElementMatcher)new CollectionItemMatcher((ElementMatcher)ElementMatchers.is((Object)exceptionType))) : BooleanMatcher.of((boolean)false);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresException(Class<? extends Throwable> exceptionType) {
        return ElementMatchers.declaresException((TypeDescription)TypeDescription.ForLoadedType.of(exceptionType));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresException(TypeDescription exceptionType) {
        return exceptionType.isAssignableTo(Throwable.class) ? ElementMatchers.declaresGenericException((ElementMatcher)new CollectionItemMatcher((ElementMatcher)ElementMatchers.erasure((TypeDescription)exceptionType))) : BooleanMatcher.of((boolean)false);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> declaresGenericException(ElementMatcher<? super Iterable<? extends TypeDescription.Generic>> matcher) {
        return new MethodExceptionTypeMatcher(matcher);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFrom(Class<?> type) {
        return ElementMatchers.isOverriddenFrom((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFrom(TypeDescription type) {
        return ElementMatchers.isOverriddenFrom((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFrom(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isOverriddenFromGeneric((ElementMatcher)ElementMatchers.erasure(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFromGeneric(Type type) {
        return ElementMatchers.isOverriddenFromGeneric((TypeDescription.Generic)TypeDefinition.Sort.describe((Type)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFromGeneric(TypeDescription.Generic type) {
        return ElementMatchers.isOverriddenFromGeneric((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isOverriddenFromGeneric(ElementMatcher<? super TypeDescription.Generic> matcher) {
        return new MethodOverrideMatcher(matcher);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isInterface() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.INTERFACE);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isAnnotation() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.ANNOTATION);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isMethod() {
        return MethodSortMatcher.of((MethodSortMatcher.Sort)MethodSortMatcher.Sort.METHOD);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isConstructor() {
        return MethodSortMatcher.of((MethodSortMatcher.Sort)MethodSortMatcher.Sort.CONSTRUCTOR);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isTypeInitializer() {
        return MethodSortMatcher.of((MethodSortMatcher.Sort)MethodSortMatcher.Sort.TYPE_INITIALIZER);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isVirtual() {
        return MethodSortMatcher.of((MethodSortMatcher.Sort)MethodSortMatcher.Sort.VIRTUAL);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultMethod() {
        return MethodSortMatcher.of((MethodSortMatcher.Sort)MethodSortMatcher.Sort.DEFAULT_METHOD);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultConstructor() {
        return ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesNoArguments());
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isMain() {
        return ElementMatchers.isMain((boolean)true);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isMain(boolean modernized) {
        if (modernized) {
            return ElementMatchers.named((String)"main").and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{String[].class}).or((ElementMatcher)ElementMatchers.takesArguments((int)0))).and((ElementMatcher)ElementMatchers.returns((TypeDescription)TypeDescription.ForLoadedType.of(Void.TYPE))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isPrivate()));
        }
        return ElementMatchers.named((String)"main").and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{String[].class})).and((ElementMatcher)ElementMatchers.returns((TypeDescription)TypeDescription.ForLoadedType.of(Void.TYPE))).and((ElementMatcher)ElementMatchers.isStatic()).and((ElementMatcher)ElementMatchers.isPublic());
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isDefaultFinalizer() {
        return ElementMatchers.isFinalizer().and((ElementMatcher)ElementMatchers.isDeclaredBy((TypeDescription)TypeDescription.ForLoadedType.of(Object.class)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isFinalizer() {
        return ElementMatchers.named((String)"finalize").and((ElementMatcher)ElementMatchers.takesNoArguments()).and((ElementMatcher)ElementMatchers.returns((TypeDescription)TypeDescription.ForLoadedType.of(Void.TYPE)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isHashCode() {
        return ElementMatchers.named((String)"hashCode").and((ElementMatcher)ElementMatchers.takesNoArguments()).and((ElementMatcher)ElementMatchers.returns(Integer.TYPE));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isEquals() {
        return ElementMatchers.named((String)"equals").and((ElementMatcher)ElementMatchers.takesArguments((TypeDescription[])new TypeDescription[]{TypeDescription.ForLoadedType.of(Object.class)})).and((ElementMatcher)ElementMatchers.returns(Boolean.TYPE));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isClone() {
        return ElementMatchers.named((String)"clone").and((ElementMatcher)ElementMatchers.takesNoArguments());
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isToString() {
        return ElementMatchers.named((String)"toString").and((ElementMatcher)ElementMatchers.takesNoArguments()).and((ElementMatcher)ElementMatchers.returns((TypeDescription)TypeDescription.ForLoadedType.of(String.class)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter() {
        return ElementMatchers.nameStartsWith((String)"set").and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.returns((TypeDescription)TypeDescription.ForLoadedType.of(Void.TYPE)));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(String property) {
        return ElementMatchers.isSetter().and((ElementMatcher)(property.length() == 0 ? ElementMatchers.named((String)"set") : ElementMatchers.named((String)("set" + Character.toUpperCase(property.charAt(0)) + property.substring(1)))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(Class<?> type) {
        return ElementMatchers.isSetter((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericSetter(Type type) {
        return ElementMatchers.isGenericSetter((TypeDescription.Generic)TypeDefinition.Sort.describe((Type)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(TypeDescription type) {
        return ElementMatchers.isSetter((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericSetter(TypeDescription.Generic type) {
        return ElementMatchers.isGenericSetter((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isSetter(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isGenericSetter((ElementMatcher)ElementMatchers.erasure(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericSetter(ElementMatcher<? super TypeDescription.Generic> matcher) {
        return ElementMatchers.isSetter().and((ElementMatcher)ElementMatchers.takesGenericArguments((ElementMatcher)new CollectionOneToOneMatcher(Collections.singletonList(matcher))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter() {
        return ElementMatchers.takesNoArguments().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.returns((TypeDescription)TypeDescription.ForLoadedType.of(Void.TYPE)))).and((ElementMatcher)ElementMatchers.nameStartsWith((String)"get").or((ElementMatcher)ElementMatchers.nameStartsWith((String)"is").and((ElementMatcher)ElementMatchers.returnsGeneric((ElementMatcher)ElementMatchers.anyOf((Type[])new Type[]{Boolean.TYPE, Boolean.class})))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(String property) {
        return ElementMatchers.isGetter().and((ElementMatcher)(property.length() == 0 ? ElementMatchers.named((String)"get").or((ElementMatcher)ElementMatchers.named((String)"is")) : ElementMatchers.named((String)("get" + Character.toUpperCase(property.charAt(0)) + property.substring(1))).or((ElementMatcher)ElementMatchers.named((String)("is" + Character.toUpperCase(property.charAt(0)) + property.substring(1))))));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(Class<?> type) {
        return ElementMatchers.isGetter((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericGetter(Type type) {
        return ElementMatchers.isGenericGetter((TypeDescription.Generic)TypeDefinition.Sort.describe((Type)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(TypeDescription type) {
        return ElementMatchers.isGetter((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericGetter(TypeDescription.Generic type) {
        return ElementMatchers.isGenericGetter((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGetter(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.isGenericGetter((ElementMatcher)ElementMatchers.erasure(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> isGenericGetter(ElementMatcher<? super TypeDescription.Generic> matcher) {
        return ElementMatchers.isGetter().and((ElementMatcher)ElementMatchers.returnsGeneric(matcher));
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> hasMethodName(String internalName) {
        if ("<init>".equals(internalName)) {
            return ElementMatchers.isConstructor();
        }
        if ("<clinit>".equals(internalName)) {
            return ElementMatchers.isTypeInitializer();
        }
        return ElementMatchers.named((String)internalName);
    }

    public static <T extends MethodDescription> ElementMatcher.Junction<T> hasSignature(MethodDescription.SignatureToken token) {
        return new SignatureTokenMatcher((ElementMatcher)ElementMatchers.is((Object)token));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSubTypeOf(Class<?> type) {
        return ElementMatchers.isSubTypeOf((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSubTypeOf(TypeDescription type) {
        return new SubTypeMatcher(type);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSuperTypeOf(Class<?> type) {
        return ElementMatchers.isSuperTypeOf((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> isSuperTypeOf(TypeDescription type) {
        return new SuperTypeMatcher(type);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasSuperClass(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasGenericSuperClass((ElementMatcher)ElementMatchers.erasure(matcher));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasGenericSuperClass(ElementMatcher<? super TypeDescription.Generic> matcher) {
        return new HasSuperClassMatcher(matcher);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasSuperType(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasGenericSuperType((ElementMatcher)ElementMatchers.erasure(matcher));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasGenericSuperType(ElementMatcher<? super TypeDescription.Generic> matcher) {
        return new HasSuperTypeMatcher(matcher);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(Class<?> type) {
        return ElementMatchers.inheritsAnnotation((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(TypeDescription type) {
        return ElementMatchers.inheritsAnnotation((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> inheritsAnnotation(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.hasAnnotation((ElementMatcher)ElementMatchers.annotationType(matcher));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasAnnotation(ElementMatcher<? super AnnotationDescription> matcher) {
        return new InheritedAnnotationMatcher((ElementMatcher)new CollectionItemMatcher(matcher));
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasClassFileVersionAtLeast(ClassFileVersion classFileVersion) {
        return new ClassFileVersionMatcher(classFileVersion, false);
    }

    public static <T extends TypeDescription> ElementMatcher.Junction<T> hasClassFileVersionAtMost(ClassFileVersion classFileVersion) {
        return new ClassFileVersionMatcher(classFileVersion, true);
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> declaresField(ElementMatcher<? super FieldDescription> matcher) {
        return new DeclaringFieldMatcher((ElementMatcher)new CollectionItemMatcher(matcher));
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> declaresMethod(ElementMatcher<? super MethodDescription> matcher) {
        return new DeclaringMethodMatcher((ElementMatcher)new CollectionItemMatcher(matcher));
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> ofSort(TypeDefinition.Sort sort) {
        return ElementMatchers.ofSort((ElementMatcher)ElementMatchers.is((Object)sort));
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> ofSort(ElementMatcher<? super TypeDefinition.Sort> matcher) {
        return new TypeSortMatcher(matcher);
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> isPrimitive() {
        return new PrimitiveTypeMatcher();
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> isArray() {
        return new ArrayTypeMatcher();
    }

    public static <T extends TypeDefinition> ElementMatcher.Junction<T> isRecord() {
        return new RecordMatcher();
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> genericFieldType(Type fieldType) {
        return ElementMatchers.genericFieldType((TypeDescription.Generic)TypeDefinition.Sort.describe((Type)fieldType));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> genericFieldType(TypeDescription.Generic fieldType) {
        return ElementMatchers.genericFieldType((ElementMatcher)ElementMatchers.is((Object)fieldType));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> genericFieldType(ElementMatcher<? super TypeDescription.Generic> matcher) {
        return new FieldTypeMatcher(matcher);
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> fieldType(Class<?> fieldType) {
        return ElementMatchers.fieldType((TypeDescription)TypeDescription.ForLoadedType.of(fieldType));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> fieldType(TypeDescription fieldType) {
        return ElementMatchers.fieldType((ElementMatcher)ElementMatchers.is((Object)fieldType));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> fieldType(ElementMatcher<? super TypeDescription> matcher) {
        return ElementMatchers.genericFieldType((ElementMatcher)ElementMatchers.erasure(matcher));
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> isVolatile() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.VOLATILE);
    }

    public static <T extends FieldDescription> ElementMatcher.Junction<T> isTransient() {
        return ModifierMatcher.of((ModifierMatcher.Mode)ModifierMatcher.Mode.TRANSIENT);
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> annotationType(Class<? extends Annotation> type) {
        return ElementMatchers.annotationType((TypeDescription)TypeDescription.ForLoadedType.of(type));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> annotationType(TypeDescription type) {
        return ElementMatchers.annotationType((ElementMatcher)ElementMatchers.is((Object)type));
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> annotationType(ElementMatcher<? super TypeDescription> matcher) {
        return new AnnotationTypeMatcher(matcher);
    }

    public static <T extends AnnotationDescription> ElementMatcher.Junction<T> targetsElement(ElementType elementType) {
        return new AnnotationTargetMatcher(elementType);
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> isBootstrapClassLoader() {
        return NullMatcher.make();
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> isSystemClassLoader() {
        return new EqualityMatcher((Object)ClassLoader.getSystemClassLoader());
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> isExtensionClassLoader() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader().getParent();
        return classLoader == null ? ElementMatchers.none() : new EqualityMatcher((Object)classLoader);
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> isChildOf(@MaybeNull ClassLoader classLoader) {
        return classLoader == ClassLoadingStrategy.BOOTSTRAP_LOADER ? BooleanMatcher.of((boolean)true) : ElementMatchers.hasChild((ElementMatcher)ElementMatchers.is((Object)classLoader));
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> hasChild(ElementMatcher<? super ClassLoader> matcher) {
        return new ClassLoaderHierarchyMatcher(matcher);
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> isParentOf(@MaybeNull ClassLoader classLoader) {
        return classLoader == ClassLoadingStrategy.BOOTSTRAP_LOADER ? ElementMatchers.isBootstrapClassLoader() : new ClassLoaderParentMatcher(classLoader);
    }

    public static <T extends ClassLoader> ElementMatcher.Junction<T> ofType(ElementMatcher<? super TypeDescription> matcher) {
        return new InstanceTypeMatcher(matcher);
    }

    public static <T extends JavaModule> ElementMatcher.Junction<T> supportsModules() {
        return ElementMatchers.not((ElementMatcher)NullMatcher.make());
    }
}

