/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class CollectionSizeMatcher<T extends Iterable<?>>
extends ElementMatcher.Junction.ForNonNullValues<T> {
    private final int size;

    public CollectionSizeMatcher(int size) {
        this.size = size;
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Iteration required to count size of an iterable.")
    protected boolean doMatch(T target) {
        if (target instanceof Collection) {
            return ((Collection)target).size() == this.size;
        }
        int size = 0;
        for (Object ignored : target) {
            ++size;
        }
        return size == this.size;
    }

    public String toString() {
        return "ofSize(" + this.size + ')';
    }

    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.size == ((CollectionSizeMatcher)object).size;
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.size;
    }
}

