/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance(permitSubclassEquality=true)
public class CachingMatcher<T>
extends ElementMatcher.Junction.AbstractBase<T> {
    private static final Object NULL_VALUE = new Object();
    private final ElementMatcher<? super T> matcher;
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
    protected final ConcurrentMap<? super T, Boolean> map;

    public CachingMatcher(ElementMatcher<? super T> matcher, ConcurrentMap<? super T, Boolean> map) {
        this.matcher = matcher;
        this.map = map;
    }

    public boolean matches(@MaybeNull T target) {
        Boolean cached = (Boolean)this.map.get(target == null ? NULL_VALUE : target);
        if (cached == null) {
            cached = this.onCacheMiss(target);
        }
        return cached;
    }

    protected boolean onCacheMiss(@MaybeNull T target) {
        boolean cached = this.matcher.matches(target);
        this.map.put(target == null ? NULL_VALUE : target, cached);
        return cached;
    }

    public String toString() {
        return "cached(" + this.matcher + ")";
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CachingMatcher)) {
            return false;
        }
        return this.matcher.equals(((CachingMatcher)object).matcher);
    }

    public int hashCode() {
        return CachingMatcher.class.hashCode() * 31 + this.matcher.hashCode();
    }
}

