/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.collection;

import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.collection.CollectionFactory;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Exception performing whole class analysis ignored.
 */
@HashCodeAndEqualsPlugin.Enhance
public class ArrayFactory
implements CollectionFactory {
    private final TypeDescription.Generic componentType;
    private final ArrayCreator arrayCreator;
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
    private final StackManipulation.Size sizeDecrease;

    protected ArrayFactory(TypeDescription.Generic componentType, ArrayCreator arrayCreator) {
        this.componentType = componentType;
        this.arrayCreator = arrayCreator;
        this.sizeDecrease = StackSize.DOUBLE.toDecreasingSize().aggregate(componentType.getStackSize().toDecreasingSize());
    }

    public static ArrayFactory forType(TypeDescription.Generic componentType) {
        return new ArrayFactory(componentType, ArrayFactory.makeArrayCreatorFor((TypeDefinition)componentType));
    }

    private static ArrayCreator makeArrayCreatorFor(TypeDefinition componentType) {
        if (!componentType.isPrimitive()) {
            return new ArrayCreator.ForReferenceType(componentType.asErasure());
        }
        if (componentType.represents(Boolean.TYPE)) {
            return ArrayCreator.ForPrimitiveType.BOOLEAN;
        }
        if (componentType.represents(Byte.TYPE)) {
            return ArrayCreator.ForPrimitiveType.BYTE;
        }
        if (componentType.represents(Short.TYPE)) {
            return ArrayCreator.ForPrimitiveType.SHORT;
        }
        if (componentType.represents(Character.TYPE)) {
            return ArrayCreator.ForPrimitiveType.CHARACTER;
        }
        if (componentType.represents(Integer.TYPE)) {
            return ArrayCreator.ForPrimitiveType.INTEGER;
        }
        if (componentType.represents(Long.TYPE)) {
            return ArrayCreator.ForPrimitiveType.LONG;
        }
        if (componentType.represents(Float.TYPE)) {
            return ArrayCreator.ForPrimitiveType.FLOAT;
        }
        if (componentType.represents(Double.TYPE)) {
            return ArrayCreator.ForPrimitiveType.DOUBLE;
        }
        throw new IllegalArgumentException("Cannot create array of type " + componentType);
    }

    public StackManipulation withValues(List<? extends StackManipulation> stackManipulations) {
        return new ArrayStackManipulation(this, stackManipulations);
    }

    public TypeDescription.Generic getComponentType() {
        return this.componentType;
    }

    static /* synthetic */ ArrayCreator access$000(ArrayFactory x0) {
        return x0.arrayCreator;
    }

    static /* synthetic */ StackManipulation.Size access$100(ArrayFactory x0) {
        return x0.sizeDecrease;
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.componentType.equals(((ArrayFactory)object).componentType)) {
            return false;
        }
        return this.arrayCreator.equals(((ArrayFactory)object).arrayCreator);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.componentType.hashCode()) * 31 + this.arrayCreator.hashCode();
    }
}

