/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.collection;

import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;

public enum ArrayAccess {
    BYTE(51, 84, StackSize.SINGLE),
    SHORT(53, 86, StackSize.SINGLE),
    CHARACTER(52, 85, StackSize.SINGLE),
    INTEGER(46, 79, StackSize.SINGLE),
    LONG(47, 80, StackSize.DOUBLE),
    FLOAT(48, 81, StackSize.SINGLE),
    DOUBLE(49, 82, StackSize.DOUBLE),
    REFERENCE(50, 83, StackSize.SINGLE);

    private final int loadOpcode;
    private final int storeOpcode;
    private final StackSize stackSize;

    private ArrayAccess(int loadOpcode, int storeOpcode, StackSize stackSize) {
        this.loadOpcode = loadOpcode;
        this.storeOpcode = storeOpcode;
        this.stackSize = stackSize;
    }

    public static ArrayAccess of(TypeDefinition componentType) {
        if (!componentType.isPrimitive()) {
            return REFERENCE;
        }
        if (componentType.represents(Boolean.TYPE) || componentType.represents(Byte.TYPE)) {
            return BYTE;
        }
        if (componentType.represents(Short.TYPE)) {
            return SHORT;
        }
        if (componentType.represents(Character.TYPE)) {
            return CHARACTER;
        }
        if (componentType.represents(Integer.TYPE)) {
            return INTEGER;
        }
        if (componentType.represents(Long.TYPE)) {
            return LONG;
        }
        if (componentType.represents(Float.TYPE)) {
            return FLOAT;
        }
        if (componentType.represents(Double.TYPE)) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Not a legal array type: " + componentType);
    }

    public StackManipulation load() {
        return new Loader(this);
    }

    public StackManipulation store() {
        return new Putter(this);
    }

    public StackManipulation forEach(List<? extends StackManipulation> processInstructions) {
        ArrayList<StackManipulation.Compound> stackManipulations = new ArrayList<StackManipulation.Compound>(processInstructions.size());
        int index = 0;
        for (StackManipulation stackManipulation : processInstructions) {
            stackManipulations.add(new StackManipulation.Compound(new StackManipulation[]{Duplication.SINGLE, IntegerConstant.forValue((int)index++), new Loader(this), stackManipulation}));
        }
        return new StackManipulation.Compound(stackManipulations);
    }

    static /* synthetic */ int access$000(ArrayAccess x0) {
        return x0.loadOpcode;
    }

    static /* synthetic */ StackSize access$100(ArrayAccess x0) {
        return x0.stackSize;
    }

    static /* synthetic */ int access$200(ArrayAccess x0) {
        return x0.storeOpcode;
    }
}

