/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.HashCodeMethod;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Exception performing whole class analysis ignored.
 */
@HashCodeAndEqualsPlugin.Enhance
public class HashCodeMethod
implements Implementation {
    private static final int DEFAULT_OFFSET = 17;
    private static final int DEFAULT_MULTIPLIER = 31;
    private static final MethodDescription.InDefinedShape HASH_CODE = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Object.class).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isHashCode())).getOnly();
    private static final MethodDescription.InDefinedShape GET_CLASS = (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Object.class).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"getClass").and((ElementMatcher)ElementMatchers.takesArguments((int)0)))).getOnly();
    private final OffsetProvider offsetProvider;
    private final int multiplier;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> ignored;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> nonNullable;
    private final ElementMatcher.Junction<? super FieldDescription.InDefinedShape> identity;

    protected HashCodeMethod(OffsetProvider offsetProvider) {
        this(offsetProvider, 31, ElementMatchers.none(), ElementMatchers.none(), ElementMatchers.none());
    }

    private HashCodeMethod(OffsetProvider offsetProvider, int multiplier, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> ignored, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> nonNullable, ElementMatcher.Junction<? super FieldDescription.InDefinedShape> identity) {
        this.offsetProvider = offsetProvider;
        this.multiplier = multiplier;
        this.ignored = ignored;
        this.nonNullable = nonNullable;
        this.identity = identity;
    }

    public static HashCodeMethod usingSuperClassOffset() {
        return new HashCodeMethod((OffsetProvider)OffsetProvider.ForSuperMethodCall.INSTANCE);
    }

    public static HashCodeMethod usingTypeHashOffset(boolean dynamic) {
        return new HashCodeMethod((OffsetProvider)(dynamic ? OffsetProvider.ForDynamicTypeHash.INSTANCE : OffsetProvider.ForStaticTypeHash.INSTANCE));
    }

    public static HashCodeMethod usingDefaultOffset() {
        return HashCodeMethod.usingOffset((int)17);
    }

    public static HashCodeMethod usingOffset(int value) {
        return new HashCodeMethod((OffsetProvider)new OffsetProvider.ForFixedValue(value));
    }

    public HashCodeMethod withIgnoredFields(ElementMatcher<? super FieldDescription.InDefinedShape> ignored) {
        return new HashCodeMethod(this.offsetProvider, this.multiplier, this.ignored.or(ignored), this.nonNullable, this.identity);
    }

    public HashCodeMethod withNonNullableFields(ElementMatcher<? super FieldDescription.InDefinedShape> nonNullable) {
        return new HashCodeMethod(this.offsetProvider, this.multiplier, this.ignored, this.nonNullable.or(nonNullable), this.identity);
    }

    public HashCodeMethod withIdentityFields(ElementMatcher<? super FieldDescription.InDefinedShape> identity) {
        return new HashCodeMethod(this.offsetProvider, this.multiplier, this.ignored, this.nonNullable, this.identity.or(identity));
    }

    public HashCodeMethod withMultiplier(int multiplier) {
        if (multiplier == 0) {
            throw new IllegalArgumentException("Hash code multiplier must not be zero");
        }
        return new HashCodeMethod(this.offsetProvider, multiplier, this.ignored, this.nonNullable, this.identity);
    }

    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        if (implementationTarget.getInstrumentedType().isInterface()) {
            throw new IllegalStateException("Cannot implement meaningful hash code method for " + implementationTarget.getInstrumentedType());
        }
        return new Appender(this.offsetProvider.resolve(implementationTarget.getInstrumentedType()), this.multiplier, (List)implementationTarget.getInstrumentedType().getDeclaredFields().filter((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic().or((ElementMatcher)this.ignored))), (ElementMatcher)this.nonNullable, (ElementMatcher)this.identity);
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$000() {
        return HASH_CODE;
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$100() {
        return GET_CLASS;
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.multiplier != ((HashCodeMethod)object).multiplier) {
            return false;
        }
        if (!this.offsetProvider.equals(((HashCodeMethod)object).offsetProvider)) {
            return false;
        }
        if (!this.ignored.equals(((HashCodeMethod)object).ignored)) {
            return false;
        }
        if (!this.nonNullable.equals(((HashCodeMethod)object).nonNullable)) {
            return false;
        }
        return this.identity.equals(((HashCodeMethod)object).identity);
    }

    public int hashCode() {
        return ((((this.getClass().hashCode() * 31 + this.offsetProvider.hashCode()) * 31 + this.multiplier) * 31 + this.ignored.hashCode()) * 31 + this.nonNullable.hashCode()) * 31 + this.identity.hashCode();
    }
}

