/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.LatentMatcher;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class InliningImplementationMatcher
implements LatentMatcher<MethodDescription> {
    private final LatentMatcher<? super MethodDescription> ignoredMethods;
    private final ElementMatcher<? super MethodDescription> predefinedMethodSignatures;

    protected InliningImplementationMatcher(LatentMatcher<? super MethodDescription> ignoredMethods, ElementMatcher<? super MethodDescription> predefinedMethodSignatures) {
        this.ignoredMethods = ignoredMethods;
        this.predefinedMethodSignatures = predefinedMethodSignatures;
    }

    protected static LatentMatcher<MethodDescription> of(LatentMatcher<? super MethodDescription> ignoredMethods, TypeDescription originalType) {
        ElementMatcher.Junction predefinedMethodSignatures = ElementMatchers.none();
        for (MethodDescription methodDescription : originalType.getDeclaredMethods()) {
            ElementMatcher.Junction signature = methodDescription.isConstructor() ? ElementMatchers.isConstructor() : ElementMatchers.named((String)methodDescription.getName());
            signature = signature.and((ElementMatcher)ElementMatchers.returns((TypeDescription)methodDescription.getReturnType().asErasure()));
            signature = signature.and((ElementMatcher)ElementMatchers.takesArguments((Iterable)methodDescription.getParameters().asTypeList().asErasures()));
            predefinedMethodSignatures = predefinedMethodSignatures.or((ElementMatcher)signature);
        }
        return new InliningImplementationMatcher(ignoredMethods, (ElementMatcher)predefinedMethodSignatures);
    }

    public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
        return ElementMatchers.not((ElementMatcher)this.ignoredMethods.resolve(typeDescription)).and((ElementMatcher)ElementMatchers.isVirtual().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isFinal())).or((ElementMatcher)ElementMatchers.isDeclaredBy((TypeDescription)typeDescription))).or((ElementMatcher)ElementMatchers.isDeclaredBy((TypeDescription)typeDescription).and((ElementMatcher)ElementMatchers.not((ElementMatcher)this.predefinedMethodSignatures)));
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.ignoredMethods.equals(((InliningImplementationMatcher)object).ignoredMethods)) {
            return false;
        }
        return this.predefinedMethodSignatures.equals(((InliningImplementationMatcher)object).predefinedMethodSignatures);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.ignoredMethods.hashCode()) * 31 + this.predefinedMethodSignatures.hashCode();
    }
}

