/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.utility.JavaModule;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Exception performing whole class analysis ignored.
 */
@HashCodeAndEqualsPlugin.Enhance
public class ClassReloadingStrategy
implements ClassLoadingStrategy<ClassLoader> {
    protected static final Dispatcher DISPATCHER;
    private final Instrumentation instrumentation;
    private final Strategy strategy;
    private final BootstrapInjection bootstrapInjection;
    private final Map<String, Class<?>> preregisteredTypes;
    private static final boolean ACCESS_CONTROLLER;

    public ClassReloadingStrategy(Instrumentation instrumentation, Strategy strategy) {
        this(instrumentation, strategy, (BootstrapInjection)BootstrapInjection.Disabled.INSTANCE, Collections.emptyMap());
    }

    protected ClassReloadingStrategy(Instrumentation instrumentation, Strategy strategy, BootstrapInjection bootstrapInjection, Map<String, Class<?>> preregisteredTypes) {
        this.instrumentation = instrumentation;
        this.strategy = strategy.validate(instrumentation);
        this.bootstrapInjection = bootstrapInjection;
        this.preregisteredTypes = preregisteredTypes;
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return action.run();
    }

    public static ClassReloadingStrategy of(Instrumentation instrumentation) {
        if (DISPATCHER.isRetransformClassesSupported(instrumentation)) {
            return new ClassReloadingStrategy(instrumentation, Strategy.RETRANSFORMATION);
        }
        if (instrumentation.isRedefineClassesSupported()) {
            return new ClassReloadingStrategy(instrumentation, Strategy.REDEFINITION);
        }
        throw new IllegalArgumentException("Instrumentation does not support reloading of classes: " + instrumentation);
    }

    private static Instrumentation resolveByteBuddyAgentInstrumentation() {
        try {
            Class<?> installer = ClassLoader.getSystemClassLoader().loadClass("net.bytebuddy.agent.Installer");
            JavaModule source = JavaModule.ofType(AgentBuilder.class);
            JavaModule target = JavaModule.ofType(installer);
            if (source != null && !source.canRead(target)) {
                Class<?> module = Class.forName("java.lang.Module");
                module.getMethod("addReads", module).invoke(source.unwrap(), target.unwrap());
            }
            return (Instrumentation)installer.getMethod("getInstrumentation", new Class[0]).invoke(null, new Object[0]);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
        }
    }

    public static ClassReloadingStrategy fromInstalledAgent() {
        return ClassReloadingStrategy.of((Instrumentation)ClassReloadingStrategy.resolveByteBuddyAgentInstrumentation());
    }

    public static ClassReloadingStrategy fromInstalledAgent(Strategy strategy) {
        return new ClassReloadingStrategy(ClassReloadingStrategy.resolveByteBuddyAgentInstrumentation(), strategy);
    }

    public Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        HashMap<String, Class> availableTypes = new HashMap<String, Class>(this.preregisteredTypes);
        for (Class type : this.instrumentation.getInitiatedClasses(classLoader)) {
            availableTypes.put(TypeDescription.ForLoadedType.getName((Class)type), type);
        }
        ConcurrentHashMap<Class, ClassDefinition> classDefinitions = new ConcurrentHashMap<Class, ClassDefinition>();
        HashMap loadedClasses = new HashMap();
        LinkedHashMap unloadedClasses = new LinkedHashMap();
        for (Map.Entry entry : types.entrySet()) {
            Class type = (Class)availableTypes.get(((TypeDescription)entry.getKey()).getName());
            if (type != null) {
                classDefinitions.put(type, new ClassDefinition(type, (byte[])entry.getValue()));
                loadedClasses.put((TypeDescription)entry.getKey(), type);
                continue;
            }
            unloadedClasses.put(entry.getKey(), entry.getValue());
        }
        try {
            this.strategy.apply(this.instrumentation, classDefinitions);
            if (!unloadedClasses.isEmpty()) {
                loadedClasses.putAll((classLoader == null ? this.bootstrapInjection.make(this.instrumentation) : new ClassInjector.UsingReflection(classLoader)).inject(unloadedClasses));
            }
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Could not locate classes for redefinition", exception);
        }
        catch (UnmodifiableClassException exception) {
            throw new IllegalStateException("Cannot redefine specified class", exception);
        }
        return loadedClasses;
    }

    public ClassReloadingStrategy reset(Class<?> ... type) throws IOException {
        return type.length == 0 ? this : this.reset(ClassFileLocator.ForClassLoader.of((ClassLoader)type[0].getClassLoader()), (Class[])type);
    }

    public ClassReloadingStrategy reset(ClassFileLocator classFileLocator, Class<?> ... type) throws IOException {
        if (type.length > 0) {
            try {
                this.strategy.reset(this.instrumentation, classFileLocator, Arrays.asList(type));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalArgumentException("Cannot locate types " + Arrays.toString(type), exception);
            }
            catch (UnmodifiableClassException exception) {
                throw new IllegalStateException("Cannot reset types " + Arrays.toString(type), exception);
            }
        }
        return this;
    }

    public ClassReloadingStrategy enableBootstrapInjection(File folder) {
        return new ClassReloadingStrategy(this.instrumentation, this.strategy, (BootstrapInjection)new BootstrapInjection.Enabled(folder), this.preregisteredTypes);
    }

    public ClassReloadingStrategy preregistered(Class<?> ... type) {
        HashMap preregisteredTypes = new HashMap(this.preregisteredTypes);
        for (Class<?> aType : type) {
            preregisteredTypes.put(TypeDescription.ForLoadedType.getName(aType), aType);
        }
        return new ClassReloadingStrategy(this.instrumentation, this.strategy, this.bootstrapInjection, preregisteredTypes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        DISPATCHER = (Dispatcher)ClassReloadingStrategy.doPrivileged((PrivilegedAction)JavaDispatcher.of(Dispatcher.class));
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.strategy.equals((Object)((ClassReloadingStrategy)object).strategy)) {
            return false;
        }
        if (!this.instrumentation.equals(((ClassReloadingStrategy)object).instrumentation)) {
            return false;
        }
        if (!this.bootstrapInjection.equals(((ClassReloadingStrategy)object).bootstrapInjection)) {
            return false;
        }
        return ((Object)this.preregisteredTypes).equals(((ClassReloadingStrategy)object).preregisteredTypes);
    }

    public int hashCode() {
        return (((this.getClass().hashCode() * 31 + this.instrumentation.hashCode()) * 31 + this.strategy.hashCode()) * 31 + this.bootstrapInjection.hashCode()) * 31 + ((Object)this.preregisteredTypes).hashCode();
    }
}

