/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ByteArrayClassLoader;
import net.bytebuddy.dynamic.loading.ClassFilePostProcessor;
import net.bytebuddy.dynamic.loading.ClassLoaderDecorator;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.InjectionClassLoader;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import net.bytebuddy.utility.GraalImageCode;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class ByteArrayClassLoader
extends InjectionClassLoader {
    public static final String URL_SCHEMA = "bytebuddy";
    private static final int FROM_BEGINNING = 0;
    @AlwaysNull
    private static final URL NO_URL;
    private static final PackageLookupStrategy PACKAGE_LOOKUP_STRATEGY;
    protected static final SynchronizationStrategy.Initializable SYNCHRONIZATION_STRATEGY;
    protected final ConcurrentMap<String, byte[]> typeDefinitions;
    protected final PersistenceHandler persistenceHandler;
    @MaybeNull
    protected final ProtectionDomain protectionDomain;
    protected final PackageDefinitionStrategy packageDefinitionStrategy;
    protected final ClassFilePostProcessor classFilePostProcessor;
    @MaybeNull
    protected final Object accessControlContext;
    private static final boolean ACCESS_CONTROLLER;

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Must be invoked from targeting class loader type.")
    private static void doRegisterAsParallelCapable() {
        try {
            Method method = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return action.run();
    }

    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions) {
        this(parent, true, typeDefinitions);
    }

    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions) {
        this(parent, sealed, typeDefinitions, PersistenceHandler.LATENT);
    }

    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions, PersistenceHandler persistenceHandler) {
        this(parent, true, typeDefinitions, persistenceHandler);
    }

    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions, PersistenceHandler persistenceHandler) {
        this(parent, sealed, typeDefinitions, ClassLoadingStrategy.NO_PROTECTION_DOMAIN, persistenceHandler, (PackageDefinitionStrategy)PackageDefinitionStrategy.Trivial.INSTANCE);
    }

    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy) {
        this(parent, true, typeDefinitions, protectionDomain, persistenceHandler, packageDefinitionStrategy);
    }

    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy) {
        this(parent, sealed, typeDefinitions, protectionDomain, persistenceHandler, packageDefinitionStrategy, (ClassFilePostProcessor)ClassFilePostProcessor.NoOp.INSTANCE);
    }

    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, ClassFilePostProcessor classFilePostProcessor) {
        this(parent, true, typeDefinitions, protectionDomain, persistenceHandler, packageDefinitionStrategy, classFilePostProcessor);
    }

    public ByteArrayClassLoader(@MaybeNull ClassLoader parent, boolean sealed, Map<String, byte[]> typeDefinitions, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, ClassFilePostProcessor classFilePostProcessor) {
        super(parent, sealed);
        this.typeDefinitions = new ConcurrentHashMap<String, byte[]>(typeDefinitions);
        this.protectionDomain = protectionDomain;
        this.persistenceHandler = persistenceHandler;
        this.packageDefinitionStrategy = packageDefinitionStrategy;
        this.classFilePostProcessor = classFilePostProcessor;
        this.accessControlContext = ByteArrayClassLoader.getContext();
    }

    @MaybeNull
    @AccessControllerPlugin.Enhance
    private static Object getContext() {
        if (ACCESS_CONTROLLER) {
            return AccessController.getContext();
        }
        return null;
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction, @MaybeNull Object object) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return AccessController.doPrivileged(privilegedAction, (AccessControlContext)object);
        }
        return action.run();
    }

    private static Object methodHandle() throws Exception {
        return Class.forName("java.lang.invoke.MethodHandles").getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
    }

    public static Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        return ByteArrayClassLoader.load((ClassLoader)classLoader, types, (ProtectionDomain)ClassLoadingStrategy.NO_PROTECTION_DOMAIN, (PersistenceHandler)PersistenceHandler.LATENT, (PackageDefinitionStrategy)PackageDefinitionStrategy.Trivial.INSTANCE, (boolean)false, (boolean)true);
    }

    public static Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting, boolean sealed) {
        return ByteArrayClassLoader.load((ClassLoader)classLoader, types, (ProtectionDomain)protectionDomain, (PersistenceHandler)persistenceHandler, (PackageDefinitionStrategy)packageDefinitionStrategy, (ClassLoaderDecorator.Factory)ClassLoaderDecorator.Factory.NoOp.INSTANCE, (boolean)forbidExisting, (boolean)sealed);
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Assuring privilege is explicit user responsibility.")
    public static Map<TypeDescription, Class<?>> load(@MaybeNull ClassLoader classLoader, Map<TypeDescription, byte[]> types, @MaybeNull ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, ClassLoaderDecorator.Factory classLoaderDecoratorFactory, boolean forbidExisting, boolean sealed) {
        HashMap<String, byte[]> typeDefinitions = new HashMap<String, byte[]>();
        for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
            typeDefinitions.put(entry.getKey().getName(), entry.getValue());
        }
        classLoader = new ByteArrayClassLoader(classLoader, sealed, typeDefinitions, protectionDomain, persistenceHandler, packageDefinitionStrategy, (ClassFilePostProcessor)ClassFilePostProcessor.NoOp.INSTANCE);
        ClassLoaderDecorator classLoaderDecorator = classLoaderDecoratorFactory.make(classLoader, typeDefinitions);
        LinkedHashMap result = new LinkedHashMap();
        for (TypeDescription typeDescription : types.keySet()) {
            if (classLoaderDecorator.isSkipped(typeDescription)) continue;
            try {
                ClassLoader currentClassLoader = classLoaderDecorator.apply(typeDescription);
                Class<?> type = Class.forName(typeDescription.getName(), false, currentClassLoader);
                if (!GraalImageCode.getCurrent().isNativeImageExecution() && forbidExisting && type.getClassLoader() != currentClassLoader) {
                    throw new IllegalStateException("Class already loaded: " + type);
                }
                result.put(typeDescription, type);
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("Cannot load class " + typeDescription, exception);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Class<?>> doDefineClasses(Map<String, byte[]> typeDefinitions) throws ClassNotFoundException {
        HashMap<String, byte[]> previous = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> entry : typeDefinitions.entrySet()) {
            previous.put(entry.getKey(), this.typeDefinitions.putIfAbsent(entry.getKey(), entry.getValue()));
        }
        try {
            LinkedHashMap<String, Class> types = new LinkedHashMap<String, Class>();
            for (String name : typeDefinitions.keySet()) {
                Object object = SYNCHRONIZATION_STRATEGY.initialize().getClassLoadingLock(this, name);
                synchronized (object) {
                    types.put(name, this.loadClass(name));
                }
            }
            LinkedHashMap<String, Class> linkedHashMap = types;
            return linkedHashMap;
        }
        finally {
            for (Map.Entry entry : previous.entrySet()) {
                if (entry.getValue() == null) {
                    this.persistenceHandler.release((String)entry.getKey(), this.typeDefinitions);
                    continue;
                }
                this.typeDefinitions.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] binaryRepresentation = this.persistenceHandler.lookup(name, this.typeDefinitions);
        if (binaryRepresentation == null) {
            throw new ClassNotFoundException(name);
        }
        return (Class)ByteArrayClassLoader.doPrivileged((PrivilegedAction)new ClassDefinitionAction(this, name, this.classFilePostProcessor.transform((ClassLoader)this, name, this.protectionDomain, binaryRepresentation)), (Object)this.accessControlContext);
    }

    @MaybeNull
    protected URL findResource(String name) {
        return this.persistenceHandler.url(name, this.typeDefinitions);
    }

    protected Enumeration<URL> findResources(String name) {
        URL url = this.persistenceHandler.url(name, this.typeDefinitions);
        return url == null ? EmptyEnumeration.INSTANCE : new SingletonEnumeration(url);
    }

    @MaybeNull
    private Package doGetPackage(String name) {
        return this.getPackage(name);
    }

    static /* synthetic */ Object access$000() throws Exception {
        return ByteArrayClassLoader.methodHandle();
    }

    static /* synthetic */ PackageLookupStrategy access$100() {
        return PACKAGE_LOOKUP_STRATEGY;
    }

    static /* synthetic */ Package access$200(ByteArrayClassLoader x0, String x1, String x2, String x3, String x4, String x5, String x6, String x7, URL x8) throws IllegalArgumentException {
        return x0.definePackage(x1, x2, x3, x4, x5, x6, x7, x8);
    }

    static /* synthetic */ Class access$300(ByteArrayClassLoader x0, String x1, byte[] x2, int x3, int x4, ProtectionDomain x5) throws ClassFormatError {
        return x0.defineClass(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ Package access$400(ByteArrayClassLoader x0, String x1) {
        return x0.doGetPackage(x1);
    }

    static /* synthetic */ URL access$600() {
        return NO_URL;
    }

    static /* synthetic */ Object access$700(PrivilegedAction x0) {
        return ByteArrayClassLoader.doPrivileged((PrivilegedAction)x0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class.forName("java.security.AccessController", false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
        NO_URL = null;
        PACKAGE_LOOKUP_STRATEGY = (PackageLookupStrategy)ByteArrayClassLoader.doPrivileged((PrivilegedAction)PackageLookupStrategy.CreationAction.INSTANCE);
        SYNCHRONIZATION_STRATEGY = (SynchronizationStrategy.Initializable)ByteArrayClassLoader.doPrivileged((PrivilegedAction)SynchronizationStrategy.CreationAction.INSTANCE);
        ByteArrayClassLoader.doRegisterAsParallelCapable();
    }
}

