/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build;

import java.util.regex.Pattern;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.RenamingPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.commons.ClassRemapper;
import net.bytebuddy.jar.asm.commons.Remapper;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class RenamingPlugin
extends AsmVisitorWrapper.AbstractBase
implements Plugin,
Plugin.Factory {
    private final Renaming renaming;
    private final ElementMatcher<? super TypeDescription> matcher;

    public RenamingPlugin(String pattern, String replacement) {
        this((Renaming)new Renaming.ForPattern(Pattern.compile(pattern), replacement));
    }

    public RenamingPlugin(String pattern, String replacement, String prefix) {
        this((Renaming)new Renaming.ForPattern(Pattern.compile(pattern), replacement), (ElementMatcher)ElementMatchers.nameStartsWith((String)prefix));
    }

    public RenamingPlugin(Renaming renaming) {
        this(renaming, (ElementMatcher)ElementMatchers.any());
    }

    public RenamingPlugin(Renaming renaming, ElementMatcher<? super TypeDescription> matcher) {
        this.renaming = renaming;
        this.matcher = matcher;
    }

    public Plugin make() {
        return this;
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        return builder.visit((AsmVisitorWrapper)this);
    }

    public boolean matches(@MaybeNull TypeDescription target) {
        return this.matcher.matches((Object)target);
    }

    public void close() {
    }

    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new ClassRemapper(classVisitor, (Remapper)new RenamingRemapper(this.renaming));
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.renaming.equals(((RenamingPlugin)object).renaming)) {
            return false;
        }
        return this.matcher.equals(((RenamingPlugin)object).matcher);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.renaming.hashCode()) * 31 + this.matcher.hashCode();
    }
}

