/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.ModifierAdjustment;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class ModifierAdjustment
extends AsmVisitorWrapper.AbstractBase {
    private final List<Adjustment<TypeDescription>> typeAdjustments;
    private final List<Adjustment<FieldDescription.InDefinedShape>> fieldAdjustments;
    private final List<Adjustment<MethodDescription>> methodAdjustments;

    public ModifierAdjustment() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    protected ModifierAdjustment(List<Adjustment<TypeDescription>> typeAdjustments, List<Adjustment<FieldDescription.InDefinedShape>> fieldAdjustments, List<Adjustment<MethodDescription>> methodAdjustments) {
        this.typeAdjustments = typeAdjustments;
        this.fieldAdjustments = fieldAdjustments;
        this.methodAdjustments = methodAdjustments;
    }

    public ModifierAdjustment withTypeModifiers(ModifierContributor.ForType ... modifierContributor) {
        return this.withTypeModifiers(Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withTypeModifiers(List<? extends ModifierContributor.ForType> modifierContributors) {
        return this.withTypeModifiers((ElementMatcher)ElementMatchers.any(), modifierContributors);
    }

    public ModifierAdjustment withTypeModifiers(ElementMatcher<? super TypeDescription> matcher, ModifierContributor.ForType ... modifierContributor) {
        return this.withTypeModifiers(matcher, Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withTypeModifiers(ElementMatcher<? super TypeDescription> matcher, List<? extends ModifierContributor.ForType> modifierContributors) {
        return new ModifierAdjustment(CompoundList.of((Object)new Adjustment(matcher, ModifierContributor.Resolver.of(modifierContributors)), (List)this.typeAdjustments), this.fieldAdjustments, this.methodAdjustments);
    }

    public ModifierAdjustment withFieldModifiers(ModifierContributor.ForField ... modifierContributor) {
        return this.withFieldModifiers(Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withFieldModifiers(List<? extends ModifierContributor.ForField> modifierContributors) {
        return this.withFieldModifiers((ElementMatcher)ElementMatchers.any(), modifierContributors);
    }

    public ModifierAdjustment withFieldModifiers(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, ModifierContributor.ForField ... modifierContributor) {
        return this.withFieldModifiers(matcher, Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withFieldModifiers(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, List<? extends ModifierContributor.ForField> modifierContributors) {
        return new ModifierAdjustment(this.typeAdjustments, CompoundList.of((Object)new Adjustment(matcher, ModifierContributor.Resolver.of(modifierContributors)), (List)this.fieldAdjustments), this.methodAdjustments);
    }

    public ModifierAdjustment withMethodModifiers(ModifierContributor.ForMethod ... modifierContributor) {
        return this.withMethodModifiers(Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withMethodModifiers(List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return this.withMethodModifiers((ElementMatcher)ElementMatchers.any(), modifierContributors);
    }

    public ModifierAdjustment withMethodModifiers(ElementMatcher<? super MethodDescription> matcher, ModifierContributor.ForMethod ... modifierContributor) {
        return this.withMethodModifiers(matcher, Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withMethodModifiers(ElementMatcher<? super MethodDescription> matcher, List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return this.withInvokableModifiers((ElementMatcher)ElementMatchers.isMethod().and(matcher), modifierContributors);
    }

    public ModifierAdjustment withConstructorModifiers(ModifierContributor.ForMethod ... modifierContributor) {
        return this.withConstructorModifiers(Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withConstructorModifiers(List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return this.withConstructorModifiers((ElementMatcher)ElementMatchers.any(), modifierContributors);
    }

    public ModifierAdjustment withConstructorModifiers(ElementMatcher<? super MethodDescription> matcher, ModifierContributor.ForMethod ... modifierContributor) {
        return this.withConstructorModifiers(matcher, Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withConstructorModifiers(ElementMatcher<? super MethodDescription> matcher, List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return this.withInvokableModifiers((ElementMatcher)ElementMatchers.isConstructor().and(matcher), modifierContributors);
    }

    public ModifierAdjustment withInvokableModifiers(ModifierContributor.ForMethod ... modifierContributor) {
        return this.withInvokableModifiers(Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withInvokableModifiers(List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return this.withInvokableModifiers((ElementMatcher)ElementMatchers.any(), modifierContributors);
    }

    public ModifierAdjustment withInvokableModifiers(ElementMatcher<? super MethodDescription> matcher, ModifierContributor.ForMethod ... modifierContributor) {
        return this.withInvokableModifiers(matcher, Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withInvokableModifiers(ElementMatcher<? super MethodDescription> matcher, List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return new ModifierAdjustment(this.typeAdjustments, this.fieldAdjustments, CompoundList.of((Object)new Adjustment(matcher, ModifierContributor.Resolver.of(modifierContributors)), (List)this.methodAdjustments));
    }

    public ModifierAdjustingClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        HashMap<String, FieldDescription.InDefinedShape> mappedFields = new HashMap<String, FieldDescription.InDefinedShape>();
        for (FieldDescription.InDefinedShape fieldDescription : fields) {
            mappedFields.put(fieldDescription.getInternalName() + fieldDescription.getDescriptor(), fieldDescription);
        }
        HashMap<String, MethodDescription> mappedMethods = new HashMap<String, MethodDescription>();
        for (MethodDescription methodDescription : CompoundList.of(methods, (Object)new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
            mappedMethods.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), methodDescription);
        }
        return new ModifierAdjustingClassVisitor(classVisitor, this.typeAdjustments, this.fieldAdjustments, this.methodAdjustments, instrumentedType, mappedFields, mappedMethods);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!((Object)this.typeAdjustments).equals(((ModifierAdjustment)object).typeAdjustments)) {
            return false;
        }
        if (!((Object)this.fieldAdjustments).equals(((ModifierAdjustment)object).fieldAdjustments)) {
            return false;
        }
        return ((Object)this.methodAdjustments).equals(((ModifierAdjustment)object).methodAdjustments);
    }

    public int hashCode() {
        return ((this.getClass().hashCode() * 31 + ((Object)this.typeAdjustments).hashCode()) * 31 + ((Object)this.fieldAdjustments).hashCode()) * 31 + ((Object)this.methodAdjustments).hashCode();
    }
}

