/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.MemberSubstitution;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class MemberSubstitution
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper {
    protected static final int THIS_REFERENCE = 0;
    private final MethodGraph.Compiler methodGraphCompiler;
    private final TypePoolResolver typePoolResolver;
    private final boolean strict;
    private final boolean failIfNoMatch;
    private final Replacement.Factory replacementFactory;

    protected MemberSubstitution(boolean strict) {
        this(MethodGraph.Compiler.DEFAULT, (TypePoolResolver)TypePoolResolver.OfImplicitPool.INSTANCE, strict, false, (Replacement.Factory)Replacement.NoOp.INSTANCE);
    }

    protected MemberSubstitution(MethodGraph.Compiler methodGraphCompiler, TypePoolResolver typePoolResolver, boolean strict, boolean failIfNoMatch, Replacement.Factory replacementFactory) {
        this.methodGraphCompiler = methodGraphCompiler;
        this.typePoolResolver = typePoolResolver;
        this.failIfNoMatch = failIfNoMatch;
        this.strict = strict;
        this.replacementFactory = replacementFactory;
    }

    public static MemberSubstitution strict() {
        return new MemberSubstitution(true);
    }

    public static MemberSubstitution relaxed() {
        return new MemberSubstitution(false);
    }

    public WithoutSpecification<Target.ForMember> element(ElementMatcher<? super ByteCodeElement.Member> matcher) {
        return new WithoutSpecification.ForMatchedByteCodeElement(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.failIfNoMatch, this.replacementFactory, matcher);
    }

    public WithoutSpecification.ForMatchedField field(ElementMatcher<? super FieldDescription> matcher) {
        return new WithoutSpecification.ForMatchedField(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.failIfNoMatch, this.replacementFactory, matcher);
    }

    public WithoutSpecification.ForMatchedMethod method(ElementMatcher<? super MethodDescription> matcher) {
        return new WithoutSpecification.ForMatchedMethod(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.failIfNoMatch, this.replacementFactory, matcher);
    }

    public WithoutSpecification<Target.ForMember> constructor(ElementMatcher<? super MethodDescription> matcher) {
        return this.invokable((ElementMatcher)ElementMatchers.isConstructor().and(matcher));
    }

    public WithoutSpecification<Target.ForMember> invokable(ElementMatcher<? super MethodDescription> matcher) {
        return new WithoutSpecification.ForMatchedMethod(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.failIfNoMatch, this.replacementFactory, matcher);
    }

    public WithoutSpecification.ForMatchedDynamicInvocation lambdaExpression() {
        return this.dynamic((ElementMatcher)new LambdaMetaFactoryMatcher());
    }

    public WithoutSpecification.ForMatchedDynamicInvocation dynamic(ElementMatcher<? super JavaConstant.MethodHandle> matcher) {
        return new WithoutSpecification.ForMatchedDynamicInvocation(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.failIfNoMatch, this.replacementFactory, matcher, ElementMatchers.any(), ElementMatchers.any(), ElementMatchers.any());
    }

    public MemberSubstitution with(MethodGraph.Compiler methodGraphCompiler) {
        return new MemberSubstitution(methodGraphCompiler, this.typePoolResolver, this.strict, this.failIfNoMatch, this.replacementFactory);
    }

    public MemberSubstitution with(TypePoolResolver typePoolResolver) {
        return new MemberSubstitution(this.methodGraphCompiler, typePoolResolver, this.strict, this.failIfNoMatch, this.replacementFactory);
    }

    public MemberSubstitution failIfNoMatch(boolean failIfNoMatch) {
        return new MemberSubstitution(this.methodGraphCompiler, this.typePoolResolver, this.strict, failIfNoMatch, this.replacementFactory);
    }

    public AsmVisitorWrapper.ForDeclaredMethods on(ElementMatcher<? super MethodDescription> matcher) {
        return new AsmVisitorWrapper.ForDeclaredMethods().invokable(matcher, new AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper[]{this});
    }

    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
        typePool = this.typePoolResolver.resolve(instrumentedType, instrumentedMethod, typePool);
        return new SubstitutingMethodVisitor(methodVisitor, instrumentedType, instrumentedMethod, this.methodGraphCompiler, this.strict, this.failIfNoMatch, this.replacementFactory.make(instrumentedType, instrumentedMethod, typePool), implementationContext, typePool, implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V11));
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.strict != ((MemberSubstitution)object).strict) {
            return false;
        }
        if (this.failIfNoMatch != ((MemberSubstitution)object).failIfNoMatch) {
            return false;
        }
        if (!this.methodGraphCompiler.equals(((MemberSubstitution)object).methodGraphCompiler)) {
            return false;
        }
        if (!this.typePoolResolver.equals(((MemberSubstitution)object).typePoolResolver)) {
            return false;
        }
        return this.replacementFactory.equals(((MemberSubstitution)object).replacementFactory);
    }

    public int hashCode() {
        return ((((this.getClass().hashCode() * 31 + this.methodGraphCompiler.hashCode()) * 31 + this.typePoolResolver.hashCode()) * 31 + this.strict) * 31 + this.failIfNoMatch) * 31 + this.replacementFactory.hashCode();
    }
}

