/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.AsmClassReader;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.visitor.LineNumberPrependingMethodVisitor;

/*
 * Exception performing whole class analysis ignored.
 */
@HashCodeAndEqualsPlugin.Enhance
public class Advice
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper,
Implementation {
    @AlwaysNull
    private static final AsmClassReader UNDEFINED = null;
    private static final MethodDescription.InDefinedShape SKIP_ON;
    private static final MethodDescription.InDefinedShape SKIP_ON_INDEX;
    private static final MethodDescription.InDefinedShape PREPEND_LINE_NUMBER;
    private static final MethodDescription.InDefinedShape INLINE_ENTER;
    private static final MethodDescription.InDefinedShape SUPPRESS_ENTER;
    private static final MethodDescription.InDefinedShape REPEAT_ON;
    private static final MethodDescription.InDefinedShape REPEAT_ON_INDEX;
    private static final MethodDescription.InDefinedShape ON_THROWABLE;
    private static final MethodDescription.InDefinedShape BACKUP_ARGUMENTS;
    private static final MethodDescription.InDefinedShape INLINE_EXIT;
    private static final MethodDescription.InDefinedShape SUPPRESS_EXIT;
    private final Dispatcher.Resolved.ForMethodEnter methodEnter;
    private final Dispatcher.Resolved.ForMethodExit methodExit;
    private final Assigner assigner;
    private final ExceptionHandler exceptionHandler;
    private final Implementation delegate;

    protected Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit) {
        this(methodEnter, methodExit, Assigner.DEFAULT, (ExceptionHandler)ExceptionHandler.Default.SUPPRESSING, (Implementation)SuperMethodCall.INSTANCE);
    }

    private Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, Assigner assigner, ExceptionHandler exceptionHandler, Implementation delegate) {
        this.methodEnter = methodEnter;
        this.methodExit = methodExit;
        this.assigner = assigner;
        this.exceptionHandler = exceptionHandler;
        this.delegate = delegate;
    }

    public static Advice to(Class<?> advice) {
        return Advice.to(advice, (ClassFileLocator)ClassFileLocator.ForClassLoader.of((ClassLoader)advice.getClassLoader()));
    }

    public static Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)TypeDescription.ForLoadedType.of(advice), (ClassFileLocator)classFileLocator);
    }

    public static Advice to(TypeDescription advice) {
        return Advice.to((TypeDescription)advice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    public static Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)advice, (PostProcessor.Factory)PostProcessor.NoOp.INSTANCE, (ClassFileLocator)classFileLocator, Collections.emptyList(), (Delegator.Factory)Delegator.ForRegularInvocation.Factory.INSTANCE, (AsmClassReader.Factory)AsmClassReader.Factory.Default.IMPLICIT);
    }

    protected static Advice to(TypeDescription advice, PostProcessor.Factory postProcessorFactory, ClassFileLocator classFileLocator, List<? extends OffsetMapping.Factory<?>> userFactories, Delegator.Factory delegatorFactory, AsmClassReader.Factory classReaderFactory) {
        Dispatcher.Inactive methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Inactive methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : advice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, (MethodDescription.InDefinedShape)INLINE_ENTER, (Dispatcher.Unresolved)methodEnter, (MethodDescription.InDefinedShape)methodDescription, (Delegator.Factory)delegatorFactory);
            methodExit = Advice.locate(OnMethodExit.class, (MethodDescription.InDefinedShape)INLINE_EXIT, (Dispatcher.Unresolved)methodExit, (MethodDescription.InDefinedShape)methodDescription, (Delegator.Factory)delegatorFactory);
        }
        if (!methodEnter.isAlive() && !methodExit.isAlive()) {
            throw new IllegalArgumentException("No advice defined by " + advice);
        }
        try {
            AsmClassReader classReader = methodEnter.isBinary() || methodExit.isBinary() ? classReaderFactory.make(classFileLocator.locate(advice.getName()).resolve()) : UNDEFINED;
            return new Advice(methodEnter.asMethodEnter(userFactories, classReader, (Dispatcher.Unresolved)methodExit, postProcessorFactory), methodExit.asMethodExit(userFactories, classReader, (Dispatcher.Unresolved)methodEnter, postProcessorFactory));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + advice, exception);
        }
    }

    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
        ClassLoader exitLoader;
        ClassLoader enterLoader = enterAdvice.getClassLoader();
        return Advice.to(enterAdvice, exitAdvice, (ClassFileLocator)(enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of((ClassLoader)enterLoader) : new ClassFileLocator.Compound(new ClassFileLocator[]{ClassFileLocator.ForClassLoader.of((ClassLoader)enterLoader), ClassFileLocator.ForClassLoader.of((ClassLoader)exitLoader)})));
    }

    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)TypeDescription.ForLoadedType.of(enterAdvice), (TypeDescription)TypeDescription.ForLoadedType.of(exitAdvice), (ClassFileLocator)classFileLocator);
    }

    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
        return Advice.to((TypeDescription)enterAdvice, (TypeDescription)exitAdvice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)enterAdvice, (TypeDescription)exitAdvice, (PostProcessor.Factory)PostProcessor.NoOp.INSTANCE, (ClassFileLocator)classFileLocator, Collections.emptyList(), (Delegator.Factory)Delegator.ForRegularInvocation.Factory.INSTANCE, (AsmClassReader.Factory)AsmClassReader.Factory.Default.IMPLICIT);
    }

    protected static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, PostProcessor.Factory postProcessorFactory, ClassFileLocator classFileLocator, List<? extends OffsetMapping.Factory<?>> userFactories, Delegator.Factory delegatorFactory, AsmClassReader.Factory classReaderFactory) {
        Dispatcher.Inactive methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Inactive methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : enterAdvice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, (MethodDescription.InDefinedShape)INLINE_ENTER, (Dispatcher.Unresolved)methodEnter, (MethodDescription.InDefinedShape)methodDescription, (Delegator.Factory)delegatorFactory);
        }
        if (!methodEnter.isAlive()) {
            throw new IllegalArgumentException("No enter advice defined by " + enterAdvice);
        }
        for (MethodDescription.InDefinedShape methodDescription : exitAdvice.getDeclaredMethods()) {
            methodExit = Advice.locate(OnMethodExit.class, (MethodDescription.InDefinedShape)INLINE_EXIT, (Dispatcher.Unresolved)methodExit, (MethodDescription.InDefinedShape)methodDescription, (Delegator.Factory)delegatorFactory);
        }
        if (!methodExit.isAlive()) {
            throw new IllegalArgumentException("No exit advice defined by " + exitAdvice);
        }
        try {
            return new Advice(methodEnter.asMethodEnter(userFactories, methodEnter.isBinary() ? classReaderFactory.make(classFileLocator.locate(enterAdvice.getName()).resolve()) : UNDEFINED, (Dispatcher.Unresolved)methodExit, postProcessorFactory), methodExit.asMethodExit(userFactories, methodExit.isBinary() ? classReaderFactory.make(classFileLocator.locate(exitAdvice.getName()).resolve()) : UNDEFINED, (Dispatcher.Unresolved)methodEnter, postProcessorFactory));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + enterAdvice + " or " + exitAdvice, exception);
        }
    }

    private static Dispatcher.Unresolved locate(Class<? extends Annotation> type, MethodDescription.InDefinedShape property, Dispatcher.Unresolved dispatcher, MethodDescription.InDefinedShape methodDescription, Delegator.Factory delegatorFactory) {
        AnnotationDescription.Loadable annotation = methodDescription.getDeclaredAnnotations().ofType(type);
        if (annotation == null) {
            return dispatcher;
        }
        if (dispatcher.isAlive()) {
            throw new IllegalStateException("Duplicate advice for " + dispatcher + " and " + methodDescription);
        }
        if (!methodDescription.isStatic()) {
            throw new IllegalStateException("Advice for " + methodDescription + " is not static");
        }
        return (Boolean)annotation.getValue(property).resolve(Boolean.class) != false ? new Dispatcher.Inlining(methodDescription) : new Dispatcher.Delegating(methodDescription, delegatorFactory);
    }

    public static WithCustomMapping withCustomMapping() {
        return new WithCustomMapping();
    }

    public AsmVisitorWrapper.ForDeclaredMethods on(ElementMatcher<? super MethodDescription> matcher) {
        return new AsmVisitorWrapper.ForDeclaredMethods().invokable(matcher, new AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper[]{this});
    }

    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
        return instrumentedMethod.isAbstract() || instrumentedMethod.isNative() ? methodVisitor : this.doWrap(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, writerFlags, readerFlags);
    }

    protected MethodVisitor doWrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, int writerFlags, int readerFlags) {
        if (this.methodEnter.isPrependLineNumber()) {
            methodVisitor = new LineNumberPrependingMethodVisitor(methodVisitor);
        }
        if (!this.methodExit.isAlive()) {
            return new AdviceVisitor.WithoutExitAdvice(methodVisitor, implementationContext, this.assigner, this.exceptionHandler.resolve(instrumentedMethod, instrumentedType), instrumentedType, instrumentedMethod, this.methodEnter, writerFlags, readerFlags);
        }
        if (this.methodExit.getThrowable().represents(NoExceptionHandler.class)) {
            return new AdviceVisitor.WithExitAdvice.WithoutExceptionHandling(methodVisitor, implementationContext, this.assigner, this.exceptionHandler.resolve(instrumentedMethod, instrumentedType), instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, writerFlags, readerFlags);
        }
        if (instrumentedMethod.isConstructor()) {
            throw new IllegalStateException("Cannot catch exception during constructor call for " + instrumentedMethod);
        }
        return new AdviceVisitor.WithExitAdvice.WithExceptionHandling(methodVisitor, implementationContext, this.assigner, this.exceptionHandler.resolve(instrumentedMethod, instrumentedType), instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, writerFlags, readerFlags, this.methodExit.getThrowable());
    }

    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.delegate.prepare(instrumentedType);
    }

    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(this, implementationTarget, this.delegate.appender(implementationTarget));
    }

    public Advice withAssigner(Assigner assigner) {
        return new Advice(this.methodEnter, this.methodExit, assigner, this.exceptionHandler, this.delegate);
    }

    public Advice withExceptionPrinting() {
        return this.withExceptionHandler((ExceptionHandler)ExceptionHandler.Default.PRINTING);
    }

    public Advice withExceptionHandler(StackManipulation exceptionHandler) {
        return this.withExceptionHandler((ExceptionHandler)new ExceptionHandler.Simple(exceptionHandler));
    }

    public Advice withExceptionHandler(ExceptionHandler exceptionHandler) {
        return new Advice(this.methodEnter, this.methodExit, this.assigner, exceptionHandler, this.delegate);
    }

    public Implementation wrap(Implementation implementation) {
        return new Advice(this.methodEnter, this.methodExit, this.assigner, this.exceptionHandler, implementation);
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$2700() {
        return ON_THROWABLE;
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$4100() {
        return SUPPRESS_ENTER;
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$4200() {
        return SKIP_ON;
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$4300() {
        return SKIP_ON_INDEX;
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$4400() {
        return PREPEND_LINE_NUMBER;
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$4500() {
        return SUPPRESS_EXIT;
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$4600() {
        return REPEAT_ON;
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$4700() {
        return REPEAT_ON_INDEX;
    }

    static /* synthetic */ MethodDescription.InDefinedShape access$4800() {
        return BACKUP_ARGUMENTS;
    }

    static {
        MethodList enter = TypeDescription.ForLoadedType.of(OnMethodEnter.class).getDeclaredMethods();
        SKIP_ON = (MethodDescription.InDefinedShape)((MethodList)enter.filter((ElementMatcher)ElementMatchers.named((String)"skipOn"))).getOnly();
        SKIP_ON_INDEX = (MethodDescription.InDefinedShape)((MethodList)enter.filter((ElementMatcher)ElementMatchers.named((String)"skipOnIndex"))).getOnly();
        PREPEND_LINE_NUMBER = (MethodDescription.InDefinedShape)((MethodList)enter.filter((ElementMatcher)ElementMatchers.named((String)"prependLineNumber"))).getOnly();
        INLINE_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter((ElementMatcher)ElementMatchers.named((String)"inline"))).getOnly();
        SUPPRESS_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter((ElementMatcher)ElementMatchers.named((String)"suppress"))).getOnly();
        MethodList exit = TypeDescription.ForLoadedType.of(OnMethodExit.class).getDeclaredMethods();
        REPEAT_ON = (MethodDescription.InDefinedShape)((MethodList)exit.filter((ElementMatcher)ElementMatchers.named((String)"repeatOn"))).getOnly();
        REPEAT_ON_INDEX = (MethodDescription.InDefinedShape)((MethodList)exit.filter((ElementMatcher)ElementMatchers.named((String)"repeatOnIndex"))).getOnly();
        ON_THROWABLE = (MethodDescription.InDefinedShape)((MethodList)exit.filter((ElementMatcher)ElementMatchers.named((String)"onThrowable"))).getOnly();
        BACKUP_ARGUMENTS = (MethodDescription.InDefinedShape)((MethodList)exit.filter((ElementMatcher)ElementMatchers.named((String)"backupArguments"))).getOnly();
        INLINE_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter((ElementMatcher)ElementMatchers.named((String)"inline"))).getOnly();
        SUPPRESS_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter((ElementMatcher)ElementMatchers.named((String)"suppress"))).getOnly();
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.methodEnter.equals(((Advice)object).methodEnter)) {
            return false;
        }
        if (!this.methodExit.equals(((Advice)object).methodExit)) {
            return false;
        }
        if (!this.assigner.equals(((Advice)object).assigner)) {
            return false;
        }
        if (!this.exceptionHandler.equals(((Advice)object).exceptionHandler)) {
            return false;
        }
        return this.delegate.equals(((Advice)object).delegate);
    }

    public int hashCode() {
        return ((((this.getClass().hashCode() * 31 + this.methodEnter.hashCode()) * 31 + this.methodExit.hashCode()) * 31 + this.assigner.hashCode()) * 31 + this.exceptionHandler.hashCode()) * 31 + this.delegate.hashCode();
    }
}

