/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.commons.wrappers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.mulesoft.mule.munit.recording.commons.wrappers.RecordedMediaType;
import com.mulesoft.mule.munit.recording.commons.wrappers.RecordedTypedValue;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordedMessage
implements KryoSerializable {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(RecordedMessage.class);
    private RecordedTypedValue payload;
    private RecordedTypedValue attributes;

    RecordedMessage(@NotNull ExpressionLanguage expressionLanguage, @NotNull Message message) {
        Objects.requireNonNull(message, "The message may not be null");
        try {
            this.payload = RecordedTypedValue.valueOf(expressionLanguage, message.getPayload());
        }
        catch (MuleRuntimeException e) {
            String localizedError = e.getMessage().split("\n")[0];
            if (localizedError.contains("empty input")) {
                LOGGER.warn(localizedError + " Using 'null' as default value.");
                this.payload = RecordedTypedValue.valueOf(null, new RecordedMediaType(message.getPayload().getDataType().getMediaType()));
            }
            LOGGER.error(e.getMessage());
            throw new MuleRuntimeException(CoreMessages.expressionEvaluationFailed((String)e.getMessage(), (String)message.getPayload().toString()), (Throwable)e);
        }
        this.attributes = message.getAttributes().getValue() != null ? RecordedTypedValue.valueOf(expressionLanguage, message.getAttributes()) : null;
    }

    private RecordedMessage() {
    }

    @NotNull
    public RecordedTypedValue getPayload() {
        return this.payload;
    }

    @NotNull
    public Optional<RecordedTypedValue> getAttributes() {
        return Optional.ofNullable(this.attributes);
    }

    public String toString() {
        if (this.getAttributes().isPresent()) {
            return String.format("Message {payload: %s, attributes: %s}", this.getPayload(), this.getAttributes().get());
        }
        return String.format("Message {payload: %s}", this.getPayload());
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecordedMessage)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        RecordedMessage that = (RecordedMessage)object;
        return Objects.equals(this.payload, that.payload) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.payload, this.attributes);
    }

    @Override
    public void write(Kryo kryo, Output output) {
        kryo.writeClassAndObject(output, this.payload);
        kryo.writeClassAndObject(output, this.attributes);
    }

    @Override
    public void read(Kryo kryo, Input input) {
        this.payload = (RecordedTypedValue)kryo.readClassAndObject(input);
        this.attributes = (RecordedTypedValue)kryo.readClassAndObject(input);
    }
}

