/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.commons.wrappers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.validation.constraints.NotNull;
import org.mule.runtime.api.metadata.MediaType;

public class RecordedMediaType
implements KryoSerializable {
    private String mimeType;
    private String encoding;
    private Map<String, String> parameters;

    RecordedMediaType(@NotNull MediaType mediaType) {
        Objects.requireNonNull(mediaType, "The media type may not be null");
        try {
            this.mimeType = MediaType.ANY.matches(mediaType) ? null : mediaType.withoutParameters().toRfcString();
            this.encoding = mediaType.getCharset().map(Charset::name).orElse(null);
            this.parameters = Collections.unmodifiableMap(Collections.list(new MimeType(mediaType.withCharset(null).toRfcString()).getParameters().getNames()).parallelStream().collect(Collectors.toMap(name -> name, arg_0 -> ((MediaType)mediaType).getParameter(arg_0))));
        }
        catch (MimeTypeParseException cause) {
            throw new RuntimeException("There was a problem reading the parameters from " + mediaType.toRfcString(), cause);
        }
    }

    private RecordedMediaType() {
    }

    @NotNull
    public Optional<String> getMimeType() {
        return Optional.ofNullable(this.mimeType);
    }

    @NotNull
    public Optional<String> getEncoding() {
        return Optional.ofNullable(this.encoding);
    }

    @NotNull
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "Media Type {" + Arrays.asList(this.getMimeType().map(mimeType -> String.format("mime type: \"%s\"", mimeType)).orElse(null), this.getEncoding().map(encoding -> String.format("encoding: \"%s\"", encoding)).orElse(null), this.getParameters().isEmpty() ? null : "parameters: {" + this.getParameters().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> String.format("\"%s\": \"%s\"", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ")) + "}").parallelStream().filter(Objects::nonNull).collect(Collectors.joining(", ")) + "}";
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecordedMediaType)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        RecordedMediaType that = (RecordedMediaType)object;
        return Objects.equals(this.mimeType, that.mimeType) && Objects.equals(this.encoding, that.encoding) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.mimeType, this.encoding, this.parameters);
    }

    @Override
    public void write(Kryo kryo, Output output) {
        kryo.writeObjectOrNull(output, (Object)this.mimeType, String.class);
        kryo.writeObjectOrNull(output, (Object)this.encoding, String.class);
        output.writeInt(this.parameters.size());
        this.parameters.forEach((key, value) -> {
            kryo.writeObject(output, key);
            kryo.writeObject(output, value);
        });
    }

    @Override
    public void read(Kryo kryo, Input input) {
        this.mimeType = kryo.readObjectOrNull(input, String.class);
        this.encoding = kryo.readObjectOrNull(input, String.class);
        this.parameters = new TreeMap<String, String>();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            this.parameters.put(kryo.readObject(input, String.class), kryo.readObject(input, String.class));
        }
        this.parameters = Collections.unmodifiableMap(this.parameters);
    }
}

