/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.commons.net;

import com.mulesoft.mule.munit.recording.commons.net.Connection;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.validation.constraints.NotNull;

public interface Listener {
    default public void added(@NotNull Connection connection) {
    }

    default public void received(@NotNull Connection connection, Object object) {
    }

    default public void removed(@NotNull Connection connection) {
    }

    public static final class ThreadedListener
    implements Listener {
        private final Listener listener;
        private final ExecutorService threadPool = Executors.newSingleThreadExecutor();

        public ThreadedListener(@NotNull Listener listener) {
            this.listener = Objects.requireNonNull(listener, "The listener may not be null");
        }

        @Override
        public void added(@NotNull Connection connection) {
            this.threadPool.execute(() -> this.listener.added(connection));
        }

        @Override
        public void received(@NotNull Connection connection, Object object) {
            this.threadPool.execute(() -> this.listener.received(connection, object));
        }

        @Override
        public void removed(@NotNull Connection connection) {
            this.threadPool.execute(() -> this.listener.removed(connection));
        }
    }
}

