/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.commons.net;

import com.mulesoft.mule.munit.recording.commons.net.Connection;
import com.mulesoft.mule.munit.recording.commons.net.Listener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;

public abstract class Connector {
    private final Set<Connection> connections = new HashSet<Connection>();
    private final Set<Listener> listeners = new HashSet<Listener>();

    protected Connector(Listener ... listeners) {
        ((Stream)Arrays.stream(Objects.requireNonNull(listeners, "The listeners may not be null")).parallel()).forEach(this::addListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull Listener listener) {
        Connector connector = this;
        synchronized (connector) {
            this.listeners.add(Objects.requireNonNull(listener, "The listener may not be null"));
            this.connections.forEach(listener::added);
        }
    }

    public abstract void connect(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Object object) {
        Connector connector = this;
        synchronized (connector) {
            this.connections.forEach(connection -> connection.send(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Connector connector = this;
        synchronized (connector) {
            this.connections.forEach(Connection::close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull Listener listener) {
        Connector connector = this;
        synchronized (connector) {
            if (this.listeners.contains(Objects.requireNonNull(listener, "The listener may not be null"))) {
                this.connections.forEach(listener::removed);
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        Connector connector = this;
        synchronized (connector) {
            this.listeners.forEach(listener -> this.connections.forEach(listener::removed));
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void opened(Connection connection) {
        Connector connector = this;
        synchronized (connector) {
            this.connections.add(connection);
            this.listeners.forEach(listener -> listener.added(connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void received(Connection connection, Object object) {
        Connector connector = this;
        synchronized (connector) {
            this.listeners.forEach(listener -> listener.received(connection, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closed(Connection connection) {
        Connector connector = this;
        synchronized (connector) {
            this.connections.remove(connection);
            this.listeners.forEach(listener -> listener.removed(connection));
        }
    }
}

