/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.munit.recording.client;

import com.mulesoft.mule.munit.recording.client.IRecordingCallback;
import com.mulesoft.mule.munit.recording.commons.net.Client;
import com.mulesoft.mule.munit.recording.commons.net.Connection;
import com.mulesoft.mule.munit.recording.commons.net.Listener;
import com.mulesoft.mule.munit.recording.commons.wrappers.Container;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingClient
implements Listener {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(RecordingClient.class);
    private final IRecordingCallback callback;
    private final int port;
    private Client client;

    public RecordingClient(int port, @NotNull IRecordingCallback callback) {
        this.callback = Objects.requireNonNull(callback, "The callback may not be null");
        this.port = port;
        this.client = new Client(new Listener.ThreadedListener(this));
    }

    public boolean connect() {
        try {
            this.client.connect(this.port);
            return true;
        }
        catch (IOException | IllegalArgumentException cause) {
            if (!cause.getMessage().contains("Connection refused")) {
                LOGGER.error("Unable to connect to the recording server", cause);
            }
            this.client.close();
            return false;
        }
    }

    @Override
    public synchronized void received(Connection connection, Object object) {
        if (object instanceof Container) {
            Container container = (Container)object;
            try {
                switch (container.type()) {
                    case CHECK: {
                        connection.send(new Container(this.callback.process(container) ? Container.Type.YES : Container.Type.NO, container.id(), new Container.Entry[0]));
                        return;
                    }
                    case BEFORE: {
                        this.callback.before(container);
                        connection.send(new Container(Container.Type.OK, container.id(), new Container.Entry[0]));
                        return;
                    }
                    case AFTER: {
                        this.callback.after(container);
                        connection.send(new Container(Container.Type.OK, container.id(), new Container.Entry[0]));
                        return;
                    }
                    case OK: {
                        return;
                    }
                    case ERROR: {
                        LOGGER.error(String.format("Received an ERROR response: %s", container.get(Container.Key.MESSAGE)));
                        this.callback.error(container);
                        return;
                    }
                }
            }
            catch (Exception cause) {
                StringWriter stringWriter = new StringWriter();
                cause.printStackTrace(new PrintWriter(stringWriter));
                String stackTrace = stringWriter.toString();
                String message = String.format("There was a problem processing the container: %s", stackTrace);
                LOGGER.error(message);
                connection.send(new Container(Container.Type.ERROR, container.id(), new Container.Entry<String>(Container.Key.MESSAGE, message)));
                return;
            }
        }
        LOGGER.error(String.format("Received an unexpected object from the server: '%s'", object));
        connection.send(new Container(Container.Type.ERROR, new Container.Entry<String>(Container.Key.MESSAGE, String.format("Unexpected: '%s'", object))));
    }

    public boolean disconnect() {
        this.client.close();
        return true;
    }

    public boolean dispose() {
        this.client.clearListeners();
        this.client = null;
        return true;
    }
}

