/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.metrics.event.information;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mulesoft.mule.runtime.gw.metrics.event.Event;
import com.mulesoft.mule.runtime.gw.metrics.event.EventVisitor;
import com.mulesoft.mule.runtime.gw.metrics.event.information.AnalyticsInformation;
import com.mulesoft.mule.runtime.gw.metrics.event.information.GatewaySecurityInformation;
import com.mulesoft.mule.runtime.gw.metrics.event.information.PlatformInformation;
import java.util.Objects;

public class GatewayInformation
extends Event {
    private static final long serialVersionUID = -8062965982399373204L;
    @JsonProperty(value="runtime_version")
    private String runtimeVersion;
    @JsonProperty(value="deployment_target")
    private String deploymentTarget;
    @JsonProperty(value="gatekeeper_mode")
    private String gatekeeperMode;
    @JsonProperty(value="cluster_enabled")
    private boolean clusterMode;
    @JsonProperty(value="security")
    private GatewaySecurityInformation gatewaySecurityInformation;
    @JsonProperty(value="platform")
    private PlatformInformation platformInformation;
    @JsonProperty(value="analytics")
    private AnalyticsInformation analyticsInformation;

    public GatewayInformation() {
    }

    public GatewayInformation(String runtimeVersion, String deploymentTarget, String gatekeeperMode, boolean clusterMode, GatewaySecurityInformation gatewaySecurityInformation, PlatformInformation platformInformation, AnalyticsInformation analyticsInformation, long time) {
        super(time);
        this.runtimeVersion = runtimeVersion;
        this.deploymentTarget = deploymentTarget;
        this.gatekeeperMode = gatekeeperMode;
        this.clusterMode = clusterMode;
        this.gatewaySecurityInformation = gatewaySecurityInformation;
        this.platformInformation = platformInformation;
        this.analyticsInformation = analyticsInformation;
    }

    @Override
    public <T> T accept(EventVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayInformation gatewayInformation = (GatewayInformation)o;
        return this.runtimeVersion.equals(gatewayInformation.runtimeVersion) && this.deploymentTarget.equals(gatewayInformation.deploymentTarget) && this.gatekeeperMode.equals(gatewayInformation.gatekeeperMode) && this.clusterMode == gatewayInformation.clusterMode && this.gatewaySecurityInformation.equals(gatewayInformation.gatewaySecurityInformation) && this.platformInformation.equals(gatewayInformation.platformInformation) && this.analyticsInformation.equals(gatewayInformation.analyticsInformation);
    }

    public int hashCode() {
        return Objects.hash(this.runtimeVersion, this.deploymentTarget, this.gatekeeperMode, this.clusterMode, this.gatewaySecurityInformation.hashCode(), this.platformInformation.hashCode(), this.analyticsInformation.hashCode());
    }

    public String toString() {
        return "{runtimeVersion=" + this.runtimeVersion + ", deploymentTarget=" + this.deploymentTarget + ", gatekeeperMode=" + this.gatekeeperMode + ", clusterMode=" + this.clusterMode + ", gatewaySecurityInformation=" + String.valueOf(this.gatewaySecurityInformation) + ", platformInformation=" + String.valueOf(this.platformInformation) + ", analyticsInformation=" + String.valueOf(this.analyticsInformation) + "}";
    }
}

