/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ReplaceJarsInBundle {
    private static final String JAR = ".jar";
    private static final String EXTENSION = ".txt";
    private static final String PROVIDED = "__PROVIDED__";

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            throw new IllegalArgumentException("Should pass the baseDirectory as an argument");
        }
        File repositoryDirectory = new File(args[0]);
        File bundleDirectory = new File(args[1]);
        File baseBundleDirectory = new File(bundleDirectory, args[2]);
        System.out.println("Replacing jars in " + repositoryDirectory + " with the ones already present in " + bundleDirectory);
        HashMap<String, String> index = new HashMap<String, String>();
        ReplaceJarsInBundle.index(bundleDirectory, baseBundleDirectory, index);
        ReplaceJarsInBundle.replaceFiles(repositoryDirectory, index);
        System.out.println("Done");
    }

    private static void replaceFiles(File repositoryDirectory, HashMap<String, String> index) throws IOException {
        File[] listFiles;
        for (File file : listFiles = repositoryDirectory.listFiles()) {
            if (!file.isDirectory()) {
                String fileName = file.getName();
                String pathInSource = index.get(fileName);
                if (pathInSource == null) continue;
                String replacementFileName = PROVIDED + fileName + PROVIDED + EXTENSION;
                File replacementFile = new File(file.getParentFile(), replacementFileName);
                try (FileWriter fileWriter = new FileWriter(replacementFile);){
                    fileWriter.write(pathInSource);
                }
                file.delete();
                System.out.println("Marked " + file.getAbsolutePath() + " for replacement with " + pathInSource);
                continue;
            }
            ReplaceJarsInBundle.replaceFiles(file, index);
        }
    }

    private static void index(File rootDirectory, File directory, Map<String, String> index) {
        File[] listFiles;
        for (File file : listFiles = directory.listFiles()) {
            if (!file.isDirectory()) {
                if (!file.getName().endsWith(JAR)) continue;
                String relativePath = file.getAbsolutePath().substring(rootDirectory.getAbsolutePath().length());
                index.put(file.getName(), relativePath);
                continue;
            }
            ReplaceJarsInBundle.index(rootDirectory, file, index);
        }
    }
}

