/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api.parameter;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.metadata.api.model.UnionType;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.editor.model.element.BaseChildEditorElement;
import org.mule.tooling.editor.model.element.LabelElement;
import org.mule.tooling.editor.model.element.MultiWay;
import org.mule.tooling.extension.api.Activator;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.MultiWayFactory;
import org.mule.tooling.internal.extension.api.parameter.BaseEditorElementFactory;
import org.mule.tooling.internal.extension.api.parameter.FieldDescriptor;

public class UnionParameterProcessorDelegate
extends BaseEditorElementFactory {
    @Override
    protected BaseChildEditorElement doCreateEditor(FieldDescriptor fieldDescriptor, Context context) {
        MultiWay editor;
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        if ("abstract-reconnection-strategy".equals(syntax.getElementName())) {
            MultiWay reconnectionStrategyElement = MultiWayFactory.createFrom(fieldDescriptor, context);
            reconnectionStrategyElement.setAllowSubTypes(false);
            reconnectionStrategyElement.setName(fieldDescriptor.getId());
            reconnectionStrategyElement.setAllowedElements("http://www.mulesoft.org/schema/mule/core/reconnect,http://www.mulesoft.org/schema/mule/core/reconnect-forever");
            reconnectionStrategyElement.setCaption(fieldDescriptor.getCaption());
            editor = reconnectionStrategyElement;
        } else if ("abstract-byte-streaming-strategy".equals(syntax.getElementName()) || "abstract-object-streaming-strategy".equals(syntax.getElementName())) {
            MultiWay childEditorElement = MultiWayFactory.createFrom(fieldDescriptor, context);
            childEditorElement.setAllowSubTypes(true);
            childEditorElement.setName(fieldDescriptor.getId());
            childEditorElement.setAllowedElements(EditorGeneratorUtils.getQName(syntax));
            childEditorElement.setCaption(fieldDescriptor.getCaption());
            if (!fieldDescriptor.getDefaultType().isPresent()) {
                childEditorElement.setDefaultType(this.getStreammingStrategyDefault(syntax.getElementName()));
            }
            editor = childEditorElement;
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "Unsupported Union Type:" + syntax.getElementName(), ((UnionType)fieldDescriptor.getMetadataType()).getTypes().toString()));
            LabelElement label = new LabelElement();
            label.setName(fieldDescriptor.getId());
            label.setDescription("Unsupported Union Type:" + ((UnionType)fieldDescriptor.getMetadataType()).getTypes().toString());
            editor = label;
        }
        return editor;
    }

    private String getStreammingStrategyDefault(String elementName) {
        if ("abstract-byte-streaming-strategy".equals(elementName)) {
            return "http://www.mulesoft.org/schema/mule/ee/core/repeatable-file-store-stream";
        }
        if ("abstract-object-streaming-strategy".equals(elementName)) {
            return "http://www.mulesoft.org/schema/mule/ee/core/repeatable-file-store-iterable";
        }
        throw new IllegalArgumentException("Unsupported streamming strategy");
    }
}

