/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api.parameter;

import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.extension.model.PathModel;
import org.mule.tooling.editor.model.element.BaseChildEditorElement;
import org.mule.tooling.editor.model.element.BaseFieldEditorElement;
import org.mule.tooling.editor.model.element.BaseStringEditor;
import org.mule.tooling.editor.model.element.EnumEditor;
import org.mule.tooling.editor.model.element.FileEditor;
import org.mule.tooling.editor.model.element.Option;
import org.mule.tooling.editor.model.element.PasswordEditor;
import org.mule.tooling.editor.model.element.PathEditor;
import org.mule.tooling.editor.model.element.StringEditor;
import org.mule.tooling.editor.model.element.TextEditor;
import org.mule.tooling.editor.model.element.UrlEditor;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.parameter.BaseEditorElementFactory;
import org.mule.tooling.internal.extension.api.parameter.FieldDescriptor;

public class StringParameterProcessorDelegate
extends BaseEditorElementFactory {
    @Override
    public BaseChildEditorElement doCreateEditor(FieldDescriptor fieldDescriptor, Context context) {
        Object editor;
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        if (EditorGeneratorUtils.isEnum(fieldDescriptor.getMetadataType())) {
            editor = this.createEnumEditor(fieldDescriptor);
        } else if (syntax.getAttributeName().equals("outputMimeType")) {
            editor = EditorGeneratorUtils.createMimeTypeChooser(fieldDescriptor);
        } else if (syntax.getAttributeName().equals("outputEncoding")) {
            editor = EditorGeneratorUtils.createEncodingField(fieldDescriptor);
        } else if (EditorGeneratorUtils.isClassValueField(fieldDescriptor)) {
            editor = EditorGeneratorUtils.createClassField(fieldDescriptor);
        } else {
            editor = fieldDescriptor.isPassword() ? new PasswordEditor() : (fieldDescriptor.isText() ? this.getTextEditor(fieldDescriptor) : (fieldDescriptor.getPathModel().isPresent() ? this.createEditorFromPathModel(fieldDescriptor) : new StringEditor()));
            this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        }
        this.addCapabilities((BaseFieldEditorElement)editor, fieldDescriptor, context);
        return editor;
    }

    private void addCapabilities(BaseFieldEditorElement editor, FieldDescriptor fieldDescriptor, Context context) {
        if (EditorGeneratorUtils.needsMetadataKeyTypeChooser(fieldDescriptor)) {
            this.addTypeChooserComponentToEditor(fieldDescriptor, context, (BaseChildEditorElement)editor);
        }
    }

    private BaseStringEditor createEditorFromPathModel(FieldDescriptor fieldDescriptor) {
        Object editor;
        PathModel pathModel = fieldDescriptor.getPathModel().get();
        if (pathModel.getType().isDirectory()) {
            editor = new PathEditor();
        } else if (pathModel.getType().isFile()) {
            FileEditor fileEditor = new FileEditor();
            if (!pathModel.getFileExtensions().isEmpty()) {
                fileEditor.setExtension(pathModel.getFileExtensions().stream().map(x -> x.contains(".") ? x : "*." + x).collect(Collectors.joining(",")));
            }
            editor = fileEditor;
        } else {
            editor = pathModel.getType().isAny() ? (pathModel.acceptsUrls() ? new UrlEditor() : new PathEditor()) : new StringEditor();
        }
        return editor;
    }

    protected TextEditor getTextEditor(FieldDescriptor fieldDescriptor) {
        TextEditor textEditor = new TextEditor();
        textEditor.setIsToElement(Boolean.valueOf(true));
        textEditor.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
        textEditor.setName(fieldDescriptor.getSyntax().getElementName());
        textEditor.setNestedName(fieldDescriptor.getSyntax().getElementName());
        textEditor.setWrapWithCDATA(Boolean.valueOf(true));
        if (EditorGeneratorUtils.hasMetadataProperty(fieldDescriptor)) {
            textEditor.setIsTypeChooser(Boolean.valueOf(true));
        }
        return textEditor;
    }

    protected EnumEditor createEnumEditor(FieldDescriptor fieldDescriptor) {
        EnumEditor editor = new EnumEditor();
        if (fieldDescriptor.getDefaultValue().isPresent()) {
            editor.setRemoveEmptyOption(Boolean.valueOf(true));
        }
        this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        Object[] objectArray = ((EnumAnnotation)fieldDescriptor.getMetadataType().getAnnotation(EnumAnnotation.class).get()).getValues();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Option option = new Option();
            option.setValue(obj.toString());
            editor.getOptions().add(option);
            ++n2;
        }
        return editor;
    }
}

