/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.core.utils.CoreClassesConstants;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.contribution.global.Global;
import org.mule.tooling.editor.model.element.BaseChildEditorElement;
import org.mule.tooling.editor.model.element.BaseFieldEditorElement;
import org.mule.tooling.editor.model.element.ChildElement;
import org.mule.tooling.editor.model.element.EncodingEditor;
import org.mule.tooling.editor.model.element.MultiWay;
import org.mule.tooling.editor.model.element.StringEditor;
import org.mule.tooling.editor.model.reference.GlobalRef;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.ElementFactory;
import org.mule.tooling.internal.extension.api.MultiWayFactory;
import org.mule.tooling.internal.extension.api.parameter.BaseEditorElementFactory;
import org.mule.tooling.internal.extension.api.parameter.FieldDescriptor;
import org.mule.tooling.internal.extension.api.parameter.MultiWayMode;

public class ObjectParameterProcessorDelegate
extends BaseEditorElementFactory {
    @Override
    public BaseChildEditorElement doCreateEditor(FieldDescriptor fieldDescriptor, Context context) {
        Optional<String> typeId = fieldDescriptor.getMetadataType().getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue);
        Optional<String> typeAlias = fieldDescriptor.getMetadataType().getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue);
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        String attributeName = syntax.getAttributeName();
        if (typeId.isPresent() && typeId.get().equals("org.mule.module.http.api.requester.HttpRequesterConfig")) {
            return this.createHttpRequestConfigEditor(fieldDescriptor);
        }
        if (typeId.isPresent() && typeId.get().equals(CoreClassesConstants.TLS_CONTEXT_FACTORY_TYPE_ID)) {
            return this.createTLSContextEditor(fieldDescriptor);
        }
        if (typeId.isPresent() && typeId.get().equals("org.mule.runtime.core.api.source.scheduler.Scheduler") || typeAlias.isPresent() && typeAlias.get().equals("SchedulingStrategy")) {
            return this.createSchedulerEditor(fieldDescriptor, syntax);
        }
        if (typeId.isPresent() && typeId.get().equals(CoreClassesConstants.POOLING_PROFILE_TYPE_ID)) {
            return this.createPoolingProfileEditor(fieldDescriptor, syntax);
        }
        if (EditorGeneratorUtils.isRedeliveryPolicy(syntax)) {
            return this.createRedeliveryPolicy(fieldDescriptor);
        }
        if (EditorGeneratorUtils.isReconectionElement(syntax)) {
            MultiWay editor = new MultiWay();
            this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
            editor.setCaption("Reconnection");
            editor.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
            editor.setAllowedElements(EditorGeneratorUtils.getQName(syntax));
            editor.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
            editor.setModes(MultiWayMode.INLINE.name());
            return editor;
        }
        if (EditorGeneratorUtils.isExpirationPolicyElement(syntax)) {
            MultiWay editor = new MultiWay();
            this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
            editor.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
            editor.setAllowSubTypes(false);
            editor.setAllowedElements(EditorGeneratorUtils.getQName(syntax));
            editor.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
            editor.setModes(MultiWayMode.INLINE.name());
            return editor;
        }
        if (this.handleEntityOnlyByRef(fieldDescriptor)) {
            StringEditor editor = new StringEditor();
            this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
            return editor;
        }
        if (EditorGeneratorUtils.isContentMetadataParameter(attributeName)) {
            return this.addContentParameter(fieldDescriptor);
        }
        return this.addPojo(fieldDescriptor, context);
    }

    public BaseChildEditorElement createRedeliveryPolicy(FieldDescriptor fieldDescriptor) {
        if (!fieldDescriptor.isRequired()) {
            MultiWay editor = new MultiWay();
            this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
            editor.setCaption("Redelivery policy");
            editor.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
            editor.setAllowedElements("http://www.mulesoft.org/schema/mule/core/redelivery-policy");
            editor.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
            editor.setModes(MultiWayMode.INLINE.name());
            return editor;
        }
        ChildElement childEditorElement = new ChildElement();
        childEditorElement.setInplace(Boolean.valueOf(true));
        childEditorElement.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
        childEditorElement.setName("http://www.mulesoft.org/schema/mule/core/redelivery-policy");
        return childEditorElement;
    }

    public BaseChildEditorElement createPoolingProfileEditor(FieldDescriptor fieldDescriptor, DslElementSyntax syntax) {
        MultiWay editor = new MultiWay();
        this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        editor.setCaption("Pooling profile");
        editor.setName(syntax.getElementName());
        editor.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
        editor.setEmptyLabel("Use default connection pool configuration");
        editor.setAllowedElements(EditorGeneratorUtils.getQName(syntax));
        editor.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
        editor.setModes(MultiWayMode.INLINE.name());
        return editor;
    }

    public BaseChildEditorElement createHttpRequestConfigEditor(FieldDescriptor fieldDescriptor) {
        GlobalRef editor = new GlobalRef();
        this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        editor.setRequiredType("http://www.mulesoft.org/schema/mule/http/request-config");
        return editor;
    }

    private BaseChildEditorElement createSchedulerEditor(FieldDescriptor fieldDescriptor, DslElementSyntax syntax) {
        MultiWay editor = new MultiWay();
        this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        editor.setCaption("Scheduling Strategy");
        editor.setName(syntax.getElementName());
        editor.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
        editor.setEmptyLabel("Use default connection pool configuration");
        editor.setAllowedElements(Arrays.asList("http://www.mulesoft.org/schema/mule/core/fixed-frequency", "http://www.mulesoft.org/schema/mule/core/cron").stream().collect(Collectors.joining(",")));
        editor.setWrapIn("http://www.mulesoft.org/schema/mule/core/scheduling-strategy");
        editor.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
        editor.setModes(MultiWayMode.INLINE.name());
        return editor;
    }

    private boolean handleEntityOnlyByRef(FieldDescriptor fieldDescriptor) {
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        return syntax.supportsAttributeDeclaration() && !syntax.supportsChildDeclaration() && !syntax.supportsTopLevelDeclaration() && !syntax.isWrapped();
    }

    protected BaseChildEditorElement createTLSContextEditor(FieldDescriptor fieldDescriptor) {
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        MultiWay editor = new MultiWay();
        this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        boolean supportsTopLevelDeclaration = syntax.supportsTopLevelDeclaration();
        boolean supportsChildDeclaration = syntax.supportsChildDeclaration();
        ArrayList<String> modes = new ArrayList<String>();
        if (supportsTopLevelDeclaration) {
            modes.add(MultiWayMode.GLOBAL.name());
            editor.setGlobalTypes("http://www.mulesoft.org/schema/mule/tls/globalContext");
        }
        if (supportsChildDeclaration) {
            modes.add(MultiWayMode.INLINE.name());
            editor.setAllowedElements(EditorGeneratorUtils.getQName(syntax));
        }
        editor.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
        editor.setModes(modes.stream().collect(Collectors.joining("|")));
        return editor;
    }

    protected BaseChildEditorElement addContentParameter(FieldDescriptor fieldDescriptor) {
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        if (syntax.getAttributeName().equals("outputMimeType")) {
            return EditorGeneratorUtils.createMimeTypeChooser(fieldDescriptor);
        }
        if (syntax.getAttributeName().equals("outputEncoding")) {
            EncodingEditor editor = new EncodingEditor();
            this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
            editor.setCaption("Encoding");
            return editor;
        }
        throw new RuntimeException("Unsupported field");
    }

    private BaseChildEditorElement addPojo(FieldDescriptor fieldDescriptor, Context context) {
        DslElementSyntax fieldDslSyntax = fieldDescriptor.getSyntax();
        String childElementName = fieldDslSyntax.getElementName();
        String caption = fieldDescriptor.getCaption();
        Nested typeDefinition = null;
        Global globalDefinition = null;
        ObjectType metadataType = (ObjectType)fieldDescriptor.getMetadataType();
        DslElementSyntax typeDslSyntax = (DslElementSyntax)context.getResolver().resolve((MetadataType)metadataType).get();
        if (typeDslSyntax.supportsTopLevelDeclaration()) {
            globalDefinition = ElementFactory.getOrCreateGlobalFrom(context, typeDslSyntax, (MetadataType)metadataType);
        }
        if (typeDslSyntax.supportsChildDeclaration()) {
            typeDefinition = ElementFactory.getOrCreateNestedElement(context, typeDslSyntax, typeDslSyntax.getElementName(), (MetadataType)metadataType);
        }
        if (!context.containsNested(childElementName) && !fieldDslSyntax.isWrapped()) {
            this.addNestedElement(fieldDescriptor, typeDefinition, typeDslSyntax, context);
        } else if (fieldDslSyntax.isWrapped()) {
            this.getOrCreateNestedWrappedElement(fieldDslSyntax, childElementName, metadataType, context);
        }
        String expressionFieldName = String.format("%s-%s", "expression", childElementName);
        String globalFieldName = String.format("%s-%s", "global", childElementName);
        boolean supportsExpression = fieldDescriptor.isSupportsExpression();
        boolean supportsTopLevelDeclaration = typeDslSyntax.supportsTopLevelDeclaration();
        boolean supportsChildDeclaration = fieldDslSyntax.supportsChildDeclaration() || fieldDslSyntax.isWrapped();
        boolean hasSubTypes = context.hasSubTypes((MetadataType)metadataType);
        if (MultiWayFactory.needsMultiWayEditor(fieldDescriptor, context)) {
            MultiWay multiWay = MultiWayFactory.createFrom(fieldDescriptor, context);
            if (supportsTopLevelDeclaration) {
                multiWay.setGlobalTypes(EditorGeneratorUtils.getQName(typeDslSyntax.getNamespace(), globalDefinition.getLocalId()));
            }
            if (supportsChildDeclaration || hasSubTypes) {
                multiWay.setAllowedElements(EditorGeneratorUtils.getQName(fieldDslSyntax.getNamespace(), childElementName));
            }
            multiWay.setCaption(caption);
            multiWay.setName(fieldDescriptor.getId());
            multiWay.setAllowSubTypes(hasSubTypes);
            if (fieldDslSyntax.isWrapped()) {
                multiWay.setWrapIn(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), childElementName));
                String elementName = hasSubTypes ? String.format("abstract-%s", typeDslSyntax.getElementName()) : typeDslSyntax.getElementName();
                multiWay.setAllowedElements(EditorGeneratorUtils.getQName(typeDslSyntax.getNamespace(), elementName));
            }
            return multiWay;
        }
        if (supportsExpression) {
            StringEditor stringFromExpression = new StringEditor();
            stringFromExpression.setSaveAs(fieldDescriptor.getId());
            stringFromExpression.setName(expressionFieldName);
            stringFromExpression.setSingeLineForExpressions(Boolean.valueOf(true));
            stringFromExpression.setSpan(Integer.valueOf(1));
            stringFromExpression.setSupportsExpressions(Boolean.valueOf(true));
            stringFromExpression.setCanonicalPath(fieldDescriptor.getCanonicalPath());
            return stringFromExpression;
        }
        if (supportsTopLevelDeclaration) {
            GlobalRef editor = new GlobalRef();
            editor.setRequired(Boolean.valueOf(false));
            editor.setName(globalFieldName);
            editor.setSpan(Integer.valueOf(1));
            editor.setSaveAs(fieldDescriptor.getId());
            if (hasSubTypes) {
                StringBuilder requiredTypes = new StringBuilder();
                requiredTypes.append("$");
                for (MetadataType metadataType2 : context.getSubTypes((MetadataType)metadataType)) {
                    DslElementSyntax subTypeDsl = (DslElementSyntax)context.getResolver().resolve(metadataType2).get();
                    if (!subTypeDsl.supportsTopLevelDeclaration()) continue;
                    requiredTypes.append(EditorGeneratorUtils.getQName(subTypeDsl.getPrefix(), subTypeDsl.getElementName()));
                    requiredTypes.append(",");
                }
                requiredTypes.deleteCharAt(requiredTypes.length() - 1);
                editor.setRequiredType(requiredTypes.toString());
            } else {
                editor.setRequiredType(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), globalDefinition.getLocalId()));
            }
            return editor;
        }
        ChildElement childEditorElement = new ChildElement();
        childEditorElement.setAllowMultiple(Boolean.valueOf(false));
        childEditorElement.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
        childEditorElement.setInplace(Boolean.valueOf(!context.containsType((MetadataType)metadataType)));
        childEditorElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), childElementName));
        if (supportsTopLevelDeclaration || supportsExpression || hasSubTypes || !childEditorElement.getInplace().booleanValue() || !EditorGeneratorUtils.areAllFieldsSimple(metadataType)) {
            childEditorElement.setIndentation(Integer.valueOf(138));
        }
        if (hasSubTypes && !fieldDslSyntax.isWrapped()) {
            childEditorElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), childElementName));
            childEditorElement.setAllowSubTypes(Boolean.valueOf(true));
        }
        if (childEditorElement.getInplace().booleanValue()) {
            childEditorElement.setIndentation(Integer.valueOf(10));
        }
        return childEditorElement;
    }

    private Nested addNestedElement(FieldDescriptor fieldDescriptor, Nested parentDefinition, DslElementSyntax topLvlDeclarationDsl, Context context) {
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        String itemName = syntax.getElementName();
        Nested nestedItemEditor = EditorGeneratorUtils.createNestedWithId(itemName);
        nestedItemEditor.setDescription("");
        nestedItemEditor.setWindowHeight(Integer.valueOf(270));
        nestedItemEditor.setIgnoreInHierarchy(Boolean.valueOf(true));
        if (!context.belongsToCurrentNamespace(topLvlDeclarationDsl)) {
            if (!syntax.isWrapped()) {
                nestedItemEditor.setExtendsElement(EditorGeneratorUtils.getQName(topLvlDeclarationDsl.getNamespace(), topLvlDeclarationDsl.getElementName()));
            } else {
                ChildElement childElement = new ChildElement();
                childElement.setInplace(Boolean.valueOf(true));
                childElement.setAllowMultiple(Boolean.valueOf(false));
                childElement.setName(EditorGeneratorUtils.getQName(topLvlDeclarationDsl.getNamespace(), topLvlDeclarationDsl.getElementName()));
                childElement.setIndentation(Integer.valueOf(138));
                nestedItemEditor.getChildElements().add(childElement);
            }
        } else if (parentDefinition != null) {
            nestedItemEditor.setExtendsElement(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), parentDefinition.getLocalId()));
        }
        context.addNested(nestedItemEditor);
        return nestedItemEditor;
    }

    private Nested getOrCreateNestedWrappedElement(DslElementSyntax syntax, String fieldName, ObjectType metadataType, Context context) {
        if (context.containsNested(fieldName)) {
            return context.getNested(fieldName);
        }
        Nested nestedElement = EditorGeneratorUtils.createNestedWithId(fieldName);
        nestedElement.setDescription("");
        context.addNested(nestedElement);
        ChildElement childElement = new ChildElement();
        boolean areAllFieldsSimple = EditorGeneratorUtils.areAllFieldsSimple(metadataType);
        childElement.setAllowMultiple(Boolean.valueOf(false));
        Boolean hasSubTypes = context.hasSubTypes((MetadataType)metadataType);
        childElement.setInplace(Boolean.valueOf(areAllFieldsSimple && hasSubTypes == false));
        Optional typeDSL = context.getResolver().resolve((MetadataType)metadataType);
        if (hasSubTypes.booleanValue()) {
            childElement.setAllowSubTypes(Boolean.valueOf(true));
            String baseTypeQName = EditorGeneratorUtils.getQName(((DslElementSyntax)typeDSL.get()).getNamespace(), String.format("abstract-%s", ((DslElementSyntax)typeDSL.get()).getElementName()));
            childElement.setName(baseTypeQName);
        } else {
            DslElementSyntax dslElementSyntax = (DslElementSyntax)typeDSL.get();
            childElement.setName(EditorGeneratorUtils.getQName(dslElementSyntax));
        }
        if (!areAllFieldsSimple || hasSubTypes.booleanValue()) {
            childElement.setIndentation(Integer.valueOf(138));
        }
        nestedElement.getChildElements().add(childElement);
        return nestedElement;
    }
}

