/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api.parameter;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.tooling.editor.model.element.BaseChildEditorElement;
import org.mule.tooling.editor.model.element.BaseFieldEditorElement;
import org.mule.tooling.editor.model.element.IntegerEditor;
import org.mule.tooling.editor.model.element.LongEditor;
import org.mule.tooling.editor.model.element.StringEditor;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.parameter.BaseEditorElementFactory;
import org.mule.tooling.internal.extension.api.parameter.FieldDescriptor;

public class NumberParameterProcessorDelegate
extends BaseEditorElementFactory {
    @Override
    public BaseChildEditorElement doCreateEditor(FieldDescriptor fieldDescriptor, Context context) {
        IntegerEditor editor;
        if (this.isInteger((NumberType)fieldDescriptor.getMetadataType())) {
            editor = new IntegerEditor();
            this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        } else if (this.isLong((NumberType)fieldDescriptor.getMetadataType())) {
            editor = new LongEditor();
            this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        } else {
            editor = new StringEditor();
            this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        }
        return editor;
    }

    private boolean isInteger(NumberType numberType) {
        String typeId = EditorGeneratorUtils.getTypeId((MetadataType)numberType);
        return typeId.equals("int") || typeId.equals(Integer.class.getName());
    }

    private boolean isLong(NumberType numberType) {
        String typeId = EditorGeneratorUtils.getTypeId((MetadataType)numberType);
        return typeId.equals("long") || typeId.equals(Long.class.getName());
    }
}

