/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api.parameter;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.extension.model.ClassValueModel;
import org.mule.tooling.client.api.extension.model.PathModel;
import org.mule.tooling.client.api.extension.model.value.ValueProviderModel;

public class FieldDescriptor {
    private final MetadataType metadataType;
    private final DslElementSyntax syntax;
    private final String id;
    private final String tabContainerName;
    private final String groupContainerName;
    private final String caption;
    private final String description;
    private final boolean isPassword;
    private final boolean isText;
    private final Optional<PathModel> pathModel;
    private final boolean required;
    private final boolean allowesReferences;
    private final boolean supportsExpression;
    private final boolean requiresExpression;
    private final Optional<String> defaultValue;
    private final Optional<MetadataType> defaultType;
    private final int xmlOrder;
    private final Map<Class<?>, Object> modelProperties;
    private final Optional<ValueProviderModel> valueProviderModel;
    private final String canonicalPath;
    private final String example;
    private final Optional<ClassValueModel> classValueModel;

    private FieldDescriptor(FieldDescriptorBuilder builder) {
        this.metadataType = builder.metadataType;
        this.syntax = builder.syntax;
        this.id = builder.id;
        this.tabContainerName = builder.tabContainerName;
        this.groupContainerName = builder.groupContainerName;
        this.caption = builder.caption;
        this.canonicalPath = builder.canonicalPath;
        this.description = builder.description;
        this.isPassword = builder.isPassword;
        this.isText = builder.isText;
        this.pathModel = Optional.ofNullable(builder.pathModel);
        this.required = builder.required;
        this.supportsExpression = builder.supportsExpression;
        this.requiresExpression = builder.requiresExpression;
        this.defaultValue = Optional.ofNullable(builder.defaultValue);
        this.defaultType = Optional.ofNullable(builder.defaultType);
        this.xmlOrder = builder.xmlOrder;
        this.modelProperties = builder.modelProperties;
        this.valueProviderModel = Optional.ofNullable(builder.valueProviderModel);
        this.allowesReferences = builder.allowesReferences;
        this.example = builder.example;
        this.classValueModel = Optional.ofNullable(builder.classValueModel);
    }

    public <T extends MetadataType> T getMetadataType() {
        return (T)this.metadataType;
    }

    public DslElementSyntax getSyntax() {
        return this.syntax;
    }

    public String getId() {
        return this.id;
    }

    public String getTabContainerName() {
        return this.tabContainerName;
    }

    public String getGroupContainerName() {
        return this.groupContainerName;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public boolean isText() {
        return this.isText;
    }

    public Optional<PathModel> getPathModel() {
        return this.pathModel;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSupportsExpression() {
        return this.supportsExpression;
    }

    public Optional<String> getDefaultValue() {
        return this.defaultValue;
    }

    public int getXmlOrder() {
        return this.xmlOrder;
    }

    public <T> Optional<T> getModelProperty(Class<?> clazz) {
        return Optional.ofNullable(this.modelProperties.get(clazz));
    }

    public static FieldDescriptorBuilder builder() {
        return FieldDescriptorBuilder.newInstance();
    }

    public boolean isRequiresExpression() {
        return this.requiresExpression;
    }

    public Optional<ValueProviderModel> getValueProviderModel() {
        return this.valueProviderModel;
    }

    public Optional<MetadataType> getDefaultType() {
        return this.defaultType;
    }

    public boolean isAllowesReferences() {
        return this.allowesReferences;
    }

    public String getExample() {
        return this.example;
    }

    public Optional<ClassValueModel> getClassValueModel() {
        return this.classValueModel;
    }

    public static class FieldDescriptorBuilder {
        private MetadataType metadataType;
        private DslElementSyntax syntax;
        private String id;
        private String tabContainerName;
        private String groupContainerName;
        private String caption;
        private String description;
        private boolean isPassword;
        private boolean isText;
        private PathModel pathModel;
        private boolean required;
        private boolean supportsExpression;
        private boolean requiresExpression;
        private int xmlOrder;
        private String defaultValue;
        private Map<Class<?>, Object> modelProperties = new LinkedHashMap();
        private ValueProviderModel valueProviderModel;
        private MetadataType defaultType;
        private boolean allowesReferences;
        private String example;
        private String canonicalPath;
        private ClassValueModel classValueModel;

        private FieldDescriptorBuilder() {
        }

        public static FieldDescriptorBuilder newInstance() {
            return new FieldDescriptorBuilder();
        }

        public FieldDescriptorBuilder withMetadataType(MetadataType metadataType) {
            this.metadataType = metadataType;
            return this;
        }

        public FieldDescriptorBuilder withSyntax(DslElementSyntax syntax) {
            this.syntax = syntax;
            return this;
        }

        public FieldDescriptorBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public FieldDescriptorBuilder withTabContainerName(String tabContainerName) {
            this.tabContainerName = tabContainerName;
            return this;
        }

        public FieldDescriptorBuilder withGroupContainerName(String groupContainerName) {
            this.groupContainerName = groupContainerName;
            return this;
        }

        public FieldDescriptorBuilder withCaption(String caption) {
            this.caption = caption;
            return this;
        }

        public FieldDescriptorBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public FieldDescriptorBuilder withRequired(boolean required) {
            this.required = required;
            return this;
        }

        public FieldDescriptorBuilder withText(boolean isText) {
            this.isText = isText;
            return this;
        }

        public FieldDescriptorBuilder withPathModel(PathModel pathModel) {
            this.pathModel = pathModel;
            return this;
        }

        public FieldDescriptorBuilder withPassword(boolean isPassword) {
            this.isPassword = isPassword;
            return this;
        }

        public FieldDescriptorBuilder withSupportsExpression(boolean supportsExpression) {
            this.supportsExpression = supportsExpression;
            return this;
        }

        public FieldDescriptorBuilder withRequiresExpression(boolean requiresExpression) {
            this.requiresExpression = requiresExpression;
            return this;
        }

        public FieldDescriptorBuilder withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public FieldDescriptorBuilder withXmlOrder(int xmlOrder) {
            this.xmlOrder = xmlOrder;
            return this;
        }

        public FieldDescriptorBuilder withModelProperty(Class<?> key, Object value) {
            this.modelProperties.put(key, value);
            return this;
        }

        public FieldDescriptorBuilder withValueProviderModel(ValueProviderModel valueProviderModel) {
            this.valueProviderModel = valueProviderModel;
            return this;
        }

        public FieldDescriptorBuilder withDefaultType(MetadataType type) {
            this.defaultType = type;
            return this;
        }

        public FieldDescriptorBuilder withAllowesReferences(Boolean allowesReferences) {
            this.allowesReferences = allowesReferences;
            return this;
        }

        public FieldDescriptorBuilder withCanonicalPath(String canonicalPath) {
            this.canonicalPath = canonicalPath;
            return this;
        }

        public FieldDescriptorBuilder withExample(String example) {
            this.example = example;
            return this;
        }

        public FieldDescriptorBuilder withClassValueModel(ClassValueModel classValueModel) {
            this.classValueModel = classValueModel;
            return this;
        }

        public FieldDescriptor build() {
            return new FieldDescriptor(this);
        }
    }
}

