/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api.parameter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.element.BaseChildEditorElement;
import org.mule.tooling.editor.model.element.ChildElement;
import org.mule.tooling.editor.model.element.Group;
import org.mule.tooling.editor.model.element.MultiWay;
import org.mule.tooling.editor.model.element.StringEditor;
import org.mule.tooling.editor.model.element.TextEditor;
import org.mule.tooling.extension.api.NameUtils;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.ElementFactory;
import org.mule.tooling.internal.extension.api.MultiWayFactory;
import org.mule.tooling.internal.extension.api.parameter.BaseEditorElementFactory;
import org.mule.tooling.internal.extension.api.parameter.FieldDescriptor;
import org.mule.tooling.internal.extension.api.parameter.MultiWayMode;

public class DictionaryParameterProcessorDelegate
extends BaseEditorElementFactory {
    private static final String VALUE_EDITOR_NAME = "value";
    private static final String VALUE_CAPTION = "Value";
    private static final String KEY_EDITOR_NAME = "key";
    private static final String KEY_CAPTION = "Key";

    @Override
    protected BaseChildEditorElement doCreateEditor(FieldDescriptor fieldDescriptor, Context context) {
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        String attributeName = syntax.getAttributeName();
        String childElementName = syntax.getElementName();
        String caption = EditorGeneratorUtils.getCaption(childElementName);
        ObjectType metadataType = (ObjectType)fieldDescriptor.getMetadataType();
        if (syntax.supportsChildDeclaration() && !context.containsNested(childElementName)) {
            MetadataType valueType = (MetadataType)metadataType.getOpenRestriction().get();
            Optional generic = syntax.getGeneric(valueType);
            if (generic.isPresent()) {
                DslElementSyntax mapValueDsl = (DslElementSyntax)generic.get();
                this.addNestedAndGlobalDefinition(mapValueDsl, attributeName, fieldDescriptor.getDescription(), fieldDescriptor.isRequired(), fieldDescriptor.isSupportsExpression(), (MetadataType)metadataType, childElementName, context);
            } else {
                System.out.println("WTF");
            }
        }
        String expressionFieldName = String.format("%s-%s", "expression", childElementName);
        boolean supportsExpression = fieldDescriptor.isSupportsExpression();
        boolean supportsTopLevelDeclaration = syntax.supportsTopLevelDeclaration();
        boolean supportsChildDeclaration = syntax.supportsChildDeclaration();
        ArrayList<String> modes = new ArrayList<String>();
        MultiWay multiWay = new MultiWay();
        multiWay.setCanonicalPath(fieldDescriptor.getCanonicalPath());
        if (supportsExpression) {
            modes.add(MultiWayMode.REF.name());
        }
        if (supportsTopLevelDeclaration) {
            MuleCorePlugin.logWarning((String)"Unexpected scenario. List<String> configured as a global element");
        }
        if (supportsChildDeclaration) {
            modes.add(MultiWayMode.INLINE.name());
            multiWay.setAllowedElements(EditorGeneratorUtils.getQName(syntax.getNamespace(), childElementName));
        }
        if (MultiWayFactory.needsMultiWayEditor(fieldDescriptor, context)) {
            multiWay.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
            multiWay.setCaption(caption);
            multiWay.setName(attributeName);
            multiWay.setDescription(fieldDescriptor.getDescription());
            multiWay.setModes(modes.stream().collect(Collectors.joining("|")));
            multiWay.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
            multiWay.setAllowedElements(EditorGeneratorUtils.getQName(syntax.getNamespace(), childElementName));
            return multiWay;
        }
        if (supportsExpression) {
            StringEditor stringFromExpression = new StringEditor();
            stringFromExpression.setCaption(caption);
            stringFromExpression.setSaveAs(attributeName);
            stringFromExpression.setName(expressionFieldName);
            stringFromExpression.setDescription(fieldDescriptor.getDescription());
            stringFromExpression.setSingeLineForExpressions(Boolean.valueOf(true));
            stringFromExpression.setSpan(Integer.valueOf(1));
            stringFromExpression.setSupportsExpressions(Boolean.valueOf(true));
            return stringFromExpression;
        }
        ChildElement childEditorElement = new ChildElement();
        childEditorElement.setAllowMultiple(Boolean.valueOf(false));
        childEditorElement.setInplace(Boolean.valueOf(true));
        childEditorElement.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
        childEditorElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), childElementName));
        return childEditorElement;
    }

    public void populate(final DslElementSyntax syntax, final String name, String description, final boolean required, final boolean expressionSupport, MetadataType metadataType, final List<BaseChildEditorElement> container, final Context context) {
        StringEditor itemStringValue = new StringEditor();
        itemStringValue.setCaption(KEY_CAPTION);
        itemStringValue.setDescription(description);
        itemStringValue.setRequired(Boolean.valueOf(true));
        itemStringValue.setSingeLineForExpressions(Boolean.valueOf(true));
        itemStringValue.setSupportsExpressions(Boolean.valueOf(true));
        itemStringValue.setName(KEY_EDITOR_NAME);
        container.add((BaseChildEditorElement)itemStringValue);
        final MetadataType genericType = (MetadataType)((ObjectType)metadataType).getOpenRestriction().get();
        genericType.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                Nested nested;
                String typeId = EditorGeneratorUtils.getTypeId(genericType);
                Optional resolve = context.getResolver().resolve(genericType);
                if (typeId.equals(Object.class.getName()) || !resolve.isPresent()) {
                    this.defaultVisit(genericType);
                    return;
                }
                if (!syntax.isWrapped()) {
                    DslElementSyntax genericDsl = (DslElementSyntax)resolve.get();
                    nested = ElementFactory.getOrCreateNestedElement(context, syntax, genericDsl.getElementName(), genericType);
                } else {
                    nested = DictionaryParameterProcessorDelegate.this.getOrCreateNestedWrappedElement(syntax.getElementName(), genericType, context);
                }
                String childElementName = syntax.getElementName();
                String caption = EditorGeneratorUtils.getCaption(childElementName);
                boolean supportsExpression = expressionSupport;
                boolean supportsTopLevelDeclaration = syntax.supportsTopLevelDeclaration();
                boolean supportsChildDeclaration = syntax.supportsChildDeclaration();
                ArrayList<String> modes = new ArrayList<String>();
                MultiWay multiWay = new MultiWay();
                if (supportsExpression) {
                    modes.add(MultiWayMode.REF.name());
                }
                if (supportsTopLevelDeclaration) {
                    MuleCorePlugin.logWarning((String)"Unexpected scenario. List<String> configured as a global element");
                }
                if (supportsChildDeclaration) {
                    modes.add(MultiWayMode.INLINE.name());
                    multiWay.setAllowedElements(EditorGeneratorUtils.getQName(syntax.getNamespace(), childElementName));
                }
                if (modes.size() > 1 || modes.size() == 1 && !required) {
                    multiWay.setRequired(Boolean.valueOf(required));
                    multiWay.setCaption(caption);
                    multiWay.setName(DictionaryParameterProcessorDelegate.VALUE_EDITOR_NAME);
                    multiWay.setModes(modes.stream().collect(Collectors.joining("|")));
                    multiWay.setAllowedElements(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), nested.getLocalId()));
                    container.add(multiWay);
                } else if (supportsExpression) {
                    StringEditor stringFromExpression = new StringEditor();
                    stringFromExpression.setName(DictionaryParameterProcessorDelegate.VALUE_EDITOR_NAME);
                    stringFromExpression.setLoadValueModifier("org.mule.tooling.ui.modules.core.widgets.editors.ClearOnDisabled");
                    stringFromExpression.setSingeLineForExpressions(Boolean.valueOf(true));
                    stringFromExpression.setSpan(Integer.valueOf(1));
                    stringFromExpression.setSupportsExpressions(Boolean.valueOf(true));
                    container.add(stringFromExpression);
                } else {
                    ChildElement childElement = new ChildElement();
                    childElement.setInplace(Boolean.valueOf(!syntax.isWrapped()));
                    childElement.setAllowMultiple(Boolean.valueOf(false));
                    childElement.setIndentation(Integer.valueOf(138));
                    childElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), nested.getLocalId()));
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                Optional generic = syntax.getGeneric(arrayType.getType());
                String fieldName = NameUtils.singularize(NameUtils.hyphenize(name));
                if (generic.isPresent()) {
                    fieldName = ((DslElementSyntax)generic.get()).getElementName();
                }
                Nested nested = DictionaryParameterProcessorDelegate.this.getOrCreateNestedListItemElement(fieldName, context);
                StringEditor stringFromExpression = new StringEditor();
                stringFromExpression.setName(DictionaryParameterProcessorDelegate.VALUE_EDITOR_NAME);
                stringFromExpression.setCaption(DictionaryParameterProcessorDelegate.VALUE_CAPTION);
                stringFromExpression.setLoadValueModifier("org.mule.tooling.ui.modules.core.widgets.editors.ClearOnDisabled");
                stringFromExpression.setSingeLineForExpressions(Boolean.valueOf(true));
                stringFromExpression.setSpan(Integer.valueOf(1));
                stringFromExpression.setSupportsExpressions(Boolean.valueOf(true));
                container.add(stringFromExpression);
                ChildElement childElement = new ChildElement();
                childElement.setInplace(Boolean.valueOf(false));
                childElement.setAllowMultiple(Boolean.valueOf(true));
                childElement.setCaption("List items");
                childElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), nested.getLocalId()));
                container.add(childElement);
            }

            protected void defaultVisit(MetadataType metadataType) {
                TextEditor stringValue = new TextEditor();
                stringValue.setCaption(DictionaryParameterProcessorDelegate.VALUE_CAPTION);
                stringValue.setSupportsExpressions(Boolean.valueOf(true));
                stringValue.setName(DictionaryParameterProcessorDelegate.VALUE_EDITOR_NAME);
                container.add(stringValue);
            }
        });
    }

    private void addNestedAndGlobalDefinition(DslElementSyntax syntax, String parameterModelName, String description, boolean required, boolean expressionSupport, MetadataType metadataType, String fieldName, Context context) {
        String childElementName = syntax.getElementName();
        String caption = EditorGeneratorUtils.getCaption(childElementName);
        Nested nestedItemEditor = new Nested();
        nestedItemEditor.setCaption(EditorGeneratorUtils.getCaption(NameUtils.singularize(parameterModelName)));
        nestedItemEditor.setDescription("");
        nestedItemEditor.setLocalId(childElementName);
        nestedItemEditor.setWindowHeight(Integer.valueOf(370));
        Group itemGroup = EditorGeneratorUtils.createGroupWith(caption);
        nestedItemEditor.getChildElements().add(itemGroup);
        this.populate(syntax, parameterModelName, description, required, expressionSupport, metadataType, itemGroup.getChildElements(), context);
        context.addNested(nestedItemEditor);
        Nested nestedListEditor = new Nested();
        nestedListEditor.setLocalId(fieldName);
        nestedListEditor.setSpecialValuePersistence(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), fieldName));
        context.addNested(nestedListEditor);
        ChildElement nestedChildEditorElement = new ChildElement();
        nestedChildEditorElement.setAllowMultiple(Boolean.valueOf(true));
        nestedChildEditorElement.setInplace(Boolean.valueOf(true));
        nestedChildEditorElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), childElementName));
        nestedListEditor.getChildElements().add(nestedChildEditorElement);
    }

    private Nested getOrCreateNestedWrappedElement(String fieldName, MetadataType metadataType, Context context) {
        if (context.containsNested(fieldName)) {
            return context.getNested(fieldName);
        }
        Nested nestedElement = EditorGeneratorUtils.createNestedWithId(fieldName);
        nestedElement.setDescription("");
        context.addNested(nestedElement);
        ChildElement childElement = new ChildElement();
        childElement.setInplace(Boolean.valueOf(false));
        childElement.setAllowMultiple(Boolean.valueOf(false));
        if (context.hasSubTypes(metadataType).booleanValue()) {
            childElement.setAllowSubTypes(Boolean.valueOf(true));
            String subTypes = context.getSubTypes(metadataType).stream().map(x -> {
                DslElementSyntax dslElementSyntax = (DslElementSyntax)context.getResolver().resolve((MetadataType)x).get();
                return EditorGeneratorUtils.getQName(dslElementSyntax);
            }).collect(Collectors.joining(","));
            childElement.setAllowedSubTypes(subTypes);
            childElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), String.format("abstract-%s", ((DslElementSyntax)context.getResolver().resolve(metadataType).get()).getElementName())));
        } else {
            DslElementSyntax dslElementSyntax = (DslElementSyntax)context.getResolver().resolve(metadataType).get();
            childElement.setName(EditorGeneratorUtils.getQName(dslElementSyntax.getNamespace(), dslElementSyntax.getElementName()));
        }
        childElement.setIndentation(Integer.valueOf(138));
        nestedElement.getChildElements().add(childElement);
        return nestedElement;
    }

    protected Nested getOrCreateNestedListItemElement(String fieldName, Context context) {
        String listItem = fieldName + "-item";
        if (context.containsNested(listItem)) {
            return context.getNested(listItem);
        }
        Nested nestedElement = new Nested();
        nestedElement.setLocalId(listItem);
        nestedElement.setXmlname(fieldName);
        nestedElement.setCaption("List Item");
        nestedElement.setDescription("");
        context.addNested(nestedElement);
        StringEditor editor = new StringEditor();
        editor.setSupportsExpressions(Boolean.valueOf(true));
        editor.setCaption(VALUE_CAPTION);
        editor.setName(VALUE_EDITOR_NAME);
        editor.setDescription("Reference to the object that represents this item");
        nestedElement.getChildElements().add(editor);
        return nestedElement;
    }
}

