/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyPartModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterRole;
import org.mule.tooling.editor.model.element.BaseChildEditorElement;
import org.mule.tooling.editor.model.element.BaseFieldEditorElement;
import org.mule.tooling.editor.model.element.LabelElement;
import org.mule.tooling.editor.model.element.component.TypeChooserComponent;
import org.mule.tooling.editor.model.reference.FlowRef;
import org.mule.tooling.editor.model.reference.GlobalRef;
import org.mule.tooling.extension.api.IFieldEditorProvider;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.customization.CustomizationManager;
import org.mule.tooling.internal.extension.api.DefaultValuePopulator;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.ParameterModelProcessor;
import org.mule.tooling.internal.extension.api.XmlOrderSupplier;
import org.mule.tooling.internal.extension.api.parameter.FieldDescriptor;
import org.mule.tooling.internal.extension.api.parameter.IEditorElementFactory;
import org.mule.tooling.internal.extension.api.parameter.MuleStereotypes;

public abstract class BaseEditorElementFactory
implements IEditorElementFactory {
    protected static final int CHILD_INDENTATION = 138;
    protected static final int INLINE_CHILD_INDENTATION = 10;
    private static final String HTTP_NAMESPACE = "HTTP";

    @Override
    public BaseChildEditorElement createEditor(String operationName, String path, FieldDescriptor fieldDescriptor, Context context, List<StereotypeModel> references) {
        BaseChildEditorElement editor;
        Optional<IFieldEditorProvider> customization = CustomizationManager.getInstance().getCustomizationFor(context.getNamespace().getPrefix(), operationName, path, context.getModel().getVersion());
        if (customization.isPresent()) {
            editor = customization.get().getTemplate();
            if (editor instanceof BaseFieldEditorElement) {
                this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
            } else {
                this.setCommonAttributes(editor, fieldDescriptor);
            }
        } else if (!references.isEmpty()) {
            editor = this.createReferenceEditor(fieldDescriptor, context, references);
        } else if (this.hasContentRole(fieldDescriptor)) {
            editor = EditorGeneratorUtils.createDataWeaveScriptFieldEditor(fieldDescriptor, context);
        } else if (EditorGeneratorUtils.isClassValueField(fieldDescriptor)) {
            editor = EditorGeneratorUtils.createClassField(fieldDescriptor);
            fieldDescriptor.getModelProperty(MetadataKeyPartModel.class).ifPresent(x -> {
                EditorGeneratorUtils.registerKeyPartInContext(fieldDescriptor, context);
                this.addTypeChooserComponentToEditor(fieldDescriptor, context, editor);
            });
        } else if (this.needsMetadataKeyTypeChooser(fieldDescriptor)) {
            EditorGeneratorUtils.registerKeyPartInContext(fieldDescriptor, context);
            editor = EditorGeneratorUtils.createMetadataTypeChooser(fieldDescriptor, context.getKeyPartContainer(), context);
            this.addTypeChooserComponentToEditor(fieldDescriptor, context, editor);
        } else {
            editor = this.needsValueProvider(fieldDescriptor) ? EditorGeneratorUtils.createValueProviderChooser(fieldDescriptor, context.getKeyPartContainer()) : (fieldDescriptor.isRequiresExpression() ? EditorGeneratorUtils.createMuleExpressionLanguageEditor(fieldDescriptor) : this.doCreateEditor(fieldDescriptor, context));
        }
        return editor;
    }

    protected void addTypeChooserComponentToEditor(FieldDescriptor fieldDescriptor, Context context, BaseChildEditorElement editor) {
        boolean hasConfig = context.isProcessingConfiglessElement();
        TypeChooserComponent keyFiekeyFieldld = new TypeChooserComponent();
        EditorGeneratorUtils.configureTypeChooserCapability(keyFiekeyFieldld, fieldDescriptor, context.getKeyPartContainer(), hasConfig);
        ArrayList<TypeChooserComponent> capabilities = new ArrayList<TypeChooserComponent>();
        capabilities.add(keyFiekeyFieldld);
        editor.setComponents(capabilities);
    }

    private boolean needsValueProvider(FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.getValueProviderModel().isPresent();
    }

    private BaseChildEditorElement createReferenceEditor(FieldDescriptor fieldDescriptor, Context context, List<StereotypeModel> references) {
        BaseChildEditorElement editor;
        if (this.isFlowRef(references)) {
            FlowRef flowRef = new FlowRef();
            this.setCommonAttributes((BaseFieldEditorElement)flowRef, fieldDescriptor);
            flowRef.setRemoveEmptyOption(Boolean.valueOf(true));
            flowRef.setAllowsCustom(Boolean.valueOf(true));
            flowRef.setSupportFlow(Boolean.valueOf(true));
            editor = flowRef;
        } else {
            StereotypeModel ref;
            editor = this.isObjectStoreRef(references) ? this.createGlobalRefWithType(fieldDescriptor, "http://www.mulesoft.org/schema/mule/os/object-store") : (references.size() > 1 ? this.doCreateEditor(fieldDescriptor, context) : (this.isObjectStoreConfig(ref = references.get(0)) ? this.createGlobalRefWithType(fieldDescriptor, "http://www.mulesoft.org/schema/mule/os/config") : (this.isHttpRequesterConfigRef(ref) ? this.createGlobalRefWithType(fieldDescriptor, "http://www.mulesoft.org/schema/mule/http/request-config") : (this.isHttpListenerConfigRef(ref) ? this.createGlobalRefWithType(fieldDescriptor, "http://www.mulesoft.org/schema/mule/http/listener-config") : this.doCreateEditor(fieldDescriptor, context)))));
        }
        return editor;
    }

    private BaseChildEditorElement createGlobalRefWithType(FieldDescriptor fieldDescriptor, String type) {
        GlobalRef globalRef = new GlobalRef();
        this.setCommonAttributes((BaseFieldEditorElement)globalRef, fieldDescriptor);
        globalRef.setRequiredType(type);
        return globalRef;
    }

    private boolean isFlowRef(List<StereotypeModel> references) {
        return "FLOW".equals(references.get(0).getType());
    }

    private boolean isObjectStoreConfig(StereotypeModel ref) {
        return "OS".equals(ref.getNamespace());
    }

    private boolean isHttpRequesterConfigRef(StereotypeModel ref) {
        return HTTP_NAMESPACE.equals(ref.getNamespace()) && "REQUEST_CONFIG".equals(ref.getType());
    }

    private boolean isHttpListenerConfigRef(StereotypeModel ref) {
        return HTTP_NAMESPACE.equals(ref.getNamespace()) && "LISTENER_CONFIG".equals(ref.getType());
    }

    private boolean isObjectStoreRef(List<StereotypeModel> references) {
        return MuleStereotypes.isObjectStoreStereotype(references.get(0));
    }

    protected boolean needsMetadataKeyTypeChooser(FieldDescriptor fieldDescriptor) {
        boolean hasMetadatakeyProperty = fieldDescriptor.getModelProperty(MetadataKeyPartModel.class).isPresent();
        return hasMetadatakeyProperty && !fieldDescriptor.isText();
    }

    protected boolean hasContentRole(FieldDescriptor fieldDescriptor) {
        Optional<ParameterRole> annotation = fieldDescriptor.getModelProperty(ParameterRole.class);
        return annotation.map(parameterRole -> parameterRole.isPrimaryContent() || parameterRole.isContent()).orElse(false);
    }

    protected abstract BaseChildEditorElement doCreateEditor(FieldDescriptor var1, Context var2);

    protected void setCommonAttributes(BaseFieldEditorElement editor, FieldDescriptor fieldDescriptor) {
        String caption = fieldDescriptor.getCaption();
        String description = fieldDescriptor.getDescription();
        String placeholder = fieldDescriptor.getExample();
        if (StringUtils.isNotEmpty((String)caption)) {
            editor.setCaption(caption);
        }
        if (StringUtils.isBlank((String)editor.getName())) {
            editor.setName(fieldDescriptor.getId());
        }
        if (StringUtils.isNotEmpty((String)placeholder)) {
            editor.setPlaceholder(placeholder);
        }
        editor.setCanonicalPath(fieldDescriptor.getCanonicalPath());
        editor.setDescription(description);
        editor.setSupportsExpressions(Boolean.valueOf(fieldDescriptor.isSupportsExpression()));
        editor.setRequiresExpression(Boolean.valueOf(fieldDescriptor.isRequiresExpression()));
        editor.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
        DefaultValuePopulator.populate(editor, fieldDescriptor.getDefaultValue().orElse(null));
    }

    protected void setCommonAttributes(BaseChildEditorElement editor, FieldDescriptor fieldDescriptor) {
        editor.setCaption(fieldDescriptor.getCaption());
        editor.setDescription(fieldDescriptor.getDescription());
    }

    public static void processPojoFields(String operationName, String path, DslElementSyntax syntax, List<BaseChildEditorElement> container, Context context, ObjectType objectType) {
        XmlOrderSupplier xmlOrder = new XmlOrderSupplier();
        for (ObjectFieldType objectFieldType : objectType.getFields()) {
            QName qname = objectFieldType.getKey().getName();
            String name = qname.getLocalPart();
            MetadataType metadata = objectFieldType.getValue();
            if (BaseEditorElementFactory.isParameterGroupAtPojoLevel(objectFieldType)) {
                Collection fields = ((ObjectType)objectFieldType.getValue()).getFields();
                for (ObjectFieldType subField : fields) {
                    QName subFieldQname = subField.getKey().getName();
                    String subFieldname = subFieldQname.getLocalPart();
                    MetadataType subFieldMetadata = subField.getValue();
                    BaseEditorElementFactory.processField(operationName, path, syntax, container, context, (ObjectType)objectFieldType.getValue(), subField, subFieldname, subFieldMetadata, xmlOrder.getNextXmlOrder());
                }
                continue;
            }
            BaseEditorElementFactory.processField(operationName, path, syntax, container, context, objectType, objectFieldType, name, metadata, xmlOrder.getNextXmlOrder());
        }
    }

    protected static void processField(String operationName, String path, DslElementSyntax syntax, List<BaseChildEditorElement> container, Context context, ObjectType objectType, ObjectFieldType objectFieldType, String name, MetadataType metadata, int xmlOrder) {
        Optional child = syntax.getContainedElement(name);
        child.ifPresent(fieldSyntax -> {
            FieldDescriptor fieldDescriptor = EditorGeneratorUtils.from(objectFieldType, fieldSyntax, xmlOrder);
            context.pushType((MetadataType)objectType);
            if (EditorGeneratorUtils.needsLabel(fieldDescriptor)) {
                LabelElement label = new LabelElement();
                label.setName("field-label-separator-" + fieldDescriptor.getSyntax().getElementName());
                label.setCaption(fieldDescriptor.getCaption());
            }
            Optional typeRef = objectFieldType.getAnnotation(StereotypeTypeAnnotation.class);
            List<StereotypeModel> ref = typeRef.map(x -> ((StereotypeTypeAnnotation)typeRef.get()).getStereotypeModel()).orElse(Collections.emptyList());
            metadata.accept(ParameterModelProcessor.getInstance().getDataQualifierVisitor(operationName, path, context, fieldDescriptor, container, ref));
            context.popType();
        });
    }

    private static boolean isParameterGroupAtPojoLevel(ObjectFieldType field) {
        return field.getValue() instanceof ObjectType && field.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
    }
}

