/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api.parameter;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.contribution.global.Global;
import org.mule.tooling.editor.model.element.BaseChildEditorElement;
import org.mule.tooling.editor.model.element.BaseFieldEditorElement;
import org.mule.tooling.editor.model.element.ChildElement;
import org.mule.tooling.editor.model.element.Group;
import org.mule.tooling.editor.model.element.MultiWay;
import org.mule.tooling.editor.model.element.StringEditor;
import org.mule.tooling.editor.model.element.macro.ElementControllerList;
import org.mule.tooling.extension.api.Activator;
import org.mule.tooling.extension.api.NameUtils;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.ElementFactory;
import org.mule.tooling.internal.extension.api.MultiWayFactory;
import org.mule.tooling.internal.extension.api.parameter.BaseEditorElementFactory;
import org.mule.tooling.internal.extension.api.parameter.FieldDescriptor;
import org.mule.tooling.utils.ObjectHolder;

public class ArrayParameterProcessorDelegate
extends BaseEditorElementFactory {
    private static final String LIST_ITEM_PREFIX = "listItem-";

    @Override
    public BaseChildEditorElement doCreateEditor(final FieldDescriptor fieldDescriptor, final Context context) {
        final ObjectHolder editorHolder = new ObjectHolder();
        MetadataType arrayType = ((ArrayType)fieldDescriptor.getMetadataType()).getType();
        arrayType.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    StringEditor editor = new StringEditor();
                    ArrayParameterProcessorDelegate.this.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
                    editorHolder.set((Object)editor);
                } else {
                    editorHolder.set((Object)ArrayParameterProcessorDelegate.this.createPojoList(fieldDescriptor, context));
                }
            }

            protected void defaultVisit(MetadataType metadataType) {
                DslElementSyntax syntax = fieldDescriptor.getSyntax();
                Optional itemDsl = syntax.getGeneric(metadataType);
                if (itemDsl.isPresent()) {
                    ElementControllerList elementControllerList = new ElementControllerList();
                    ArrayParameterProcessorDelegate.this.setCommonAttributes((BaseChildEditorElement)elementControllerList, fieldDescriptor);
                    String childElementName = syntax.getElementName();
                    elementControllerList.setLocalName(childElementName);
                    elementControllerList.setItemName(((DslElementSyntax)itemDsl.get()).getElementName());
                    elementControllerList.setListName(childElementName);
                    editorHolder.set((Object)elementControllerList);
                }
            }

            public void visitNumber(NumberType numberType) {
                editorHolder.set((Object)ArrayParameterProcessorDelegate.this.addStringList(fieldDescriptor, context));
            }

            public void visitString(StringType stringType) {
                editorHolder.set((Object)ArrayParameterProcessorDelegate.this.addStringList(fieldDescriptor, context));
            }
        });
        return (BaseChildEditorElement)editorHolder.get();
    }

    private BaseChildEditorElement addStringList(FieldDescriptor fieldDescriptor, Context context) {
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        String childElementName = syntax.getElementName();
        String attributeName = syntax.getAttributeName();
        if (syntax.supportsChildDeclaration() && !context.containsNested(childElementName)) {
            this.addNestedChildDefinitionToContext(fieldDescriptor, context, syntax, childElementName, attributeName);
        }
        boolean supportsExpression = fieldDescriptor.isSupportsExpression();
        if (MultiWayFactory.needsMultiWayEditor(fieldDescriptor, context)) {
            MultiWay multiWay = MultiWayFactory.createFrom(fieldDescriptor, context);
            multiWay.setCaption(fieldDescriptor.getCaption());
            multiWay.setName(attributeName);
            multiWay.setAllowedElements(EditorGeneratorUtils.getQName(syntax));
            return multiWay;
        }
        if (supportsExpression) {
            StringEditor stringFromExpression = new StringEditor();
            stringFromExpression.setSaveAs(attributeName);
            stringFromExpression.setName(String.format("%s-%s", "expression", childElementName));
            stringFromExpression.setDescription(fieldDescriptor.getDescription());
            stringFromExpression.setSingeLineForExpressions(Boolean.valueOf(true));
            stringFromExpression.setSpan(Integer.valueOf(1));
            stringFromExpression.setSupportsExpressions(Boolean.valueOf(true));
            return stringFromExpression;
        }
        ChildElement childEditorElement = new ChildElement();
        childEditorElement.setAllowMultiple(Boolean.valueOf(false));
        childEditorElement.setInplace(Boolean.valueOf(true));
        childEditorElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), childElementName));
        return childEditorElement;
    }

    private void addNestedChildDefinitionToContext(FieldDescriptor fieldDescriptor, Context context, DslElementSyntax syntax, String childElementName, String attributeName) {
        ArrayType metadataType = (ArrayType)fieldDescriptor.getMetadataType();
        Optional genericDsl = syntax.getGeneric(metadataType.getType());
        if (genericDsl.isPresent()) {
            this.addNestedListDefinition((DslElementSyntax)genericDsl.get(), attributeName, fieldDescriptor.getDescription(), fieldDescriptor.isRequired(), fieldDescriptor.isSupportsExpression(), (MetadataType)metadataType, childElementName, new StringEditorPopulator(), context);
        } else {
            Activator plugin = Activator.getDefault();
            plugin.getLog().log((IStatus)new Status(4, "org.mule.tooling.extension.api", String.format("Unexpected error processing extension field: %s. The UI may not be the expected one. The field is marked as supporting child element declaration but no information about its DSL was found. Please contact support.", fieldDescriptor.getCanonicalPath())));
        }
    }

    private void addNestedListDefinition(DslElementSyntax syntax, String parameterModelName, String description, boolean required, boolean expressionSupport, MetadataType metadataType, String fieldName, CollectionPopulator populateChild, Context context) {
        String childElementName = syntax.getElementName();
        String caption = EditorGeneratorUtils.getCaption(childElementName);
        Nested nestedItemEditor = new Nested();
        nestedItemEditor.setCaption(EditorGeneratorUtils.getCaption(NameUtils.singularize(parameterModelName)));
        nestedItemEditor.setDescription("");
        nestedItemEditor.setLocalId(LIST_ITEM_PREFIX + childElementName);
        nestedItemEditor.setWindowHeight(Integer.valueOf(370));
        nestedItemEditor.setXmlname(childElementName);
        Group itemGroup = EditorGeneratorUtils.createGroupWith(null, caption);
        nestedItemEditor.getChildElements().add(itemGroup);
        populateChild.populate(syntax, parameterModelName, description, required, expressionSupport, metadataType, itemGroup.getChildElements(), context);
        context.addNested(nestedItemEditor);
        Nested nestedListEditor = new Nested();
        nestedListEditor.setCaption(EditorGeneratorUtils.getCaption(parameterModelName));
        nestedListEditor.setWindowHeight(Integer.valueOf(370));
        nestedListEditor.setLocalId(fieldName);
        nestedListEditor.setSpecialValuePersistence(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), fieldName));
        nestedListEditor.setXmlname(fieldName);
        context.addNested(nestedListEditor);
        ChildElement nestedChildEditorElement = new ChildElement();
        nestedChildEditorElement.setAllowMultiple(Boolean.valueOf(true));
        nestedChildEditorElement.setInplace(Boolean.valueOf(true));
        if (context.hasSubTypes(metadataType).booleanValue()) {
            nestedChildEditorElement.setAllowSubTypes(Boolean.valueOf(true));
            String elementName = ((DslElementSyntax)context.getResolver().resolve(metadataType).get()).getElementName();
            String subTypes = context.getSubTypes(metadataType).stream().map(x -> {
                Optional dslElementSyntax = context.getResolver().resolve((MetadataType)x);
                return EditorGeneratorUtils.getQName((DslElementSyntax)dslElementSyntax.get());
            }).collect(Collectors.joining(","));
            nestedChildEditorElement.setAllowedSubTypes(subTypes);
            nestedChildEditorElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), String.format("abstract-%s", elementName)));
        } else {
            nestedChildEditorElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), nestedItemEditor.getLocalId()));
        }
        nestedListEditor.getChildElements().add(nestedChildEditorElement);
    }

    protected Nested getOrCreateNestedListItemElement(String fieldName, Context context) {
        String listItemName = String.format("%s-%s", fieldName, "item");
        if (context.containsNested(listItemName)) {
            return context.getNested(listItemName);
        }
        Nested nestedElement = EditorGeneratorUtils.createNestedWithId(listItemName);
        nestedElement.setCaption("List Item");
        nestedElement.setDescription("");
        context.addNested(nestedElement);
        StringEditor editor = new StringEditor();
        editor.setSupportsExpressions(Boolean.valueOf(true));
        editor.setCaption("Value");
        editor.setName("value");
        editor.setDescription("Reference to the object that represents this item");
        nestedElement.getChildElements().add(editor);
        return nestedElement;
    }

    protected Nested getOrCreateNestedWrappedElement(DslElementSyntax syntax, String fieldName, MetadataType metadataType, Context context) {
        if (context.containsNested(fieldName)) {
            return context.getNested(fieldName);
        }
        Nested nestedElement = EditorGeneratorUtils.createNestedWithId(syntax.getElementName());
        nestedElement.setDescription("");
        context.addNested(nestedElement);
        ChildElement childElement = new ChildElement();
        childElement.setInplace(Boolean.valueOf(true));
        childElement.setAllowMultiple(Boolean.valueOf(true));
        if (context.hasSubTypes(metadataType).booleanValue()) {
            childElement.setAllowSubTypes(Boolean.valueOf(true));
            String subTypes = context.getSubTypes(metadataType).stream().map(x -> {
                Optional dslElementSyntax = context.getResolver().resolve((MetadataType)x);
                return EditorGeneratorUtils.getQName((DslElementSyntax)dslElementSyntax.get());
            }).collect(Collectors.joining(","));
            childElement.setAllowedSubTypes(subTypes);
            childElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), String.format("abstract-%s", ((DslElementSyntax)context.getResolver().resolve(metadataType).get()).getElementName())));
        } else {
            DslElementSyntax dslElementSyntax = (DslElementSyntax)context.getResolver().resolve(metadataType).get();
            childElement.setName(EditorGeneratorUtils.getQName(dslElementSyntax));
        }
        nestedElement.getChildElements().add(childElement);
        return nestedElement;
    }

    private BaseChildEditorElement createPojoList(FieldDescriptor fieldDescriptor, Context context) {
        StringEditor editor;
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        ArrayType metadataType = (ArrayType)fieldDescriptor.getMetadataType();
        Optional genericType = syntax.getGeneric(metadataType.getType());
        String attributeName = syntax.getAttributeName();
        boolean hasSubTypes = context.hasSubTypes(metadataType.getType());
        if (((ObjectType)metadataType.getType()).getFields().isEmpty() || !genericType.isPresent()) {
            if (hasSubTypes) {
                Nested nested = this.getOrCreateNestedWrappedElement(syntax, fieldDescriptor.getId(), metadataType.getType(), context);
                ChildElement childEditorElement = new ChildElement();
                childEditorElement.setCaption(fieldDescriptor.getCaption());
                childEditorElement.setAllowMultiple(Boolean.valueOf(false));
                childEditorElement.setInplace(Boolean.valueOf(true));
                childEditorElement.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
                childEditorElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), nested.getLocalId()));
                editor = childEditorElement;
            } else {
                StringEditor stringEditor;
                editor = stringEditor = new StringEditor();
                this.setCommonAttributes((BaseFieldEditorElement)stringEditor, fieldDescriptor);
            }
        } else {
            String childElementName = syntax.getElementName();
            String caption = fieldDescriptor.getCaption();
            Global global = null;
            if (!context.containsNested(childElementName)) {
                this.addNestedListDefinition((DslElementSyntax)genericType.get(), attributeName, fieldDescriptor.getDescription(), fieldDescriptor.isRequired(), fieldDescriptor.isSupportsExpression(), metadataType.getType(), childElementName, new AddClassFieldsAsEditors(), context);
                if (((DslElementSyntax)genericType.get()).supportsTopLevelDeclaration()) {
                    Optional topLvlDeclarationDsl = context.getResolver().resolve(metadataType.getType());
                    global = context.containsGlobal(((DslElementSyntax)topLvlDeclarationDsl.get()).getElementName()) ? context.getGlobal(((DslElementSyntax)topLvlDeclarationDsl.get()).getElementName()) : ElementFactory.getOrCreateGlobalFrom(context, (DslElementSyntax)topLvlDeclarationDsl.get(), metadataType.getType());
                }
            }
            if (MultiWayFactory.needsMultiWayEditor(fieldDescriptor, context)) {
                MultiWay multiWay = MultiWayFactory.createFrom(fieldDescriptor, context);
                if (syntax.supportsTopLevelDeclaration()) {
                    multiWay.setGlobalTypes(EditorGeneratorUtils.getQName(syntax.getNamespace(), global.getLocalId()));
                }
                multiWay.setCaption(caption);
                multiWay.setName(syntax.getAttributeName());
                multiWay.setAllowedElements(EditorGeneratorUtils.getQName(syntax.getNamespace(), childElementName));
                editor = multiWay;
            } else if (syntax.supportsChildDeclaration()) {
                ChildElement childEditorElement = new ChildElement();
                childEditorElement.setCaption(caption);
                childEditorElement.setAllowMultiple(Boolean.valueOf(false));
                childEditorElement.setInplace(Boolean.valueOf(!context.containsType((MetadataType)metadataType)));
                childEditorElement.setAllowSubTypes(Boolean.valueOf(hasSubTypes));
                childEditorElement.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
                childEditorElement.setName(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), childElementName));
                editor = childEditorElement;
            } else {
                editor = new StringEditor();
                this.setCommonAttributes((BaseChildEditorElement)editor, fieldDescriptor);
            }
        }
        return editor;
    }

    class AddClassFieldsAsEditors
    implements CollectionPopulator {
        AddClassFieldsAsEditors() {
        }

        @Override
        public void populate(final DslElementSyntax syntax, final String name, String description, boolean required, boolean expression, MetadataType metadataType, final List<BaseChildEditorElement> container, final Context context) {
            metadataType.accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    ArrayParameterProcessorDelegate.processPojoFields(name, name, syntax, container, context, objectType);
                }
            });
        }
    }

    private static interface CollectionPopulator {
        public void populate(DslElementSyntax var1, String var2, String var3, boolean var4, boolean var5, MetadataType var6, List<BaseChildEditorElement> var7, Context var8);
    }

    class StringEditorPopulator
    implements CollectionPopulator {
        StringEditorPopulator() {
        }

        @Override
        public void populate(DslElementSyntax syntax, String name, String description, boolean required, boolean expression, MetadataType metadataType, List<BaseChildEditorElement> container, Context context) {
            StringEditor itemStringValue = new StringEditor();
            itemStringValue.setCaption("Value");
            itemStringValue.setSingeLineForExpressions(Boolean.valueOf(true));
            itemStringValue.setSupportsExpressions(Boolean.valueOf(true));
            itemStringValue.setName("value");
            container.add((BaseChildEditorElement)itemStringValue);
        }
    }
}

