/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api.generation;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.module.contribution.ExternalContribution;
import org.mule.tooling.extension.api.Activator;

public class ExternalContributionSerializer {
    private Kryo kryo;
    private Path basePath;
    private boolean debugMode = Boolean.valueOf(System.getProperty("org.mule.tooling.debug", "false"));

    public ExternalContributionSerializer(Path path) {
        this.basePath = path;
        this.kryo = new Kryo();
        this.kryo.setClassLoader(Activator.class.getClassLoader());
        this.kryo.register(ExternalContribution.class);
    }

    /*
     * Loose catch block
     */
    public Optional<ExternalContribution> getExternalContributionFor(String muleVersion, MavenDependency dependency) {
        Path contributionPath = this.getContributionPath(muleVersion, dependency);
        if (contributionPath.toFile().exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileInputStream fileStream = new FileInputStream(contributionPath.toFile());){
                    Optional<ExternalContribution> optional;
                    Input input;
                    Throwable throwable2;
                    block23: {
                        throwable2 = null;
                        Object var8_12 = null;
                        input = new Input((InputStream)fileStream);
                        optional = Optional.of((ExternalContribution)this.kryo.readObject(input, ExternalContribution.class));
                        if (input == null) break block23;
                        input.close();
                    }
                    return optional;
                    {
                        catch (Throwable throwable3) {
                            try {
                                if (input != null) {
                                    input.close();
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (Throwable ex) {
                if (this.debugMode) {
                    ex.printStackTrace();
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Path getContributionPath(String muleVersion, MavenDependency dependency) {
        String repositoryPath = MavenResourceUtils.getRepositoryPath((MavenDependency)dependency, (String)File.separator);
        Path filePath = this.basePath.resolve(repositoryPath);
        String contributionPath = dependency.getArtifactId() + "-" + dependency.getVersion() + "-" + muleVersion + ".contribution";
        return filePath.getParent().resolve(contributionPath);
    }

    public void saveExternalContribution(String muleVersion, MavenDependency dependency, ExternalContribution contribution) {
        Path contributionPath = this.getContributionPath(muleVersion, dependency);
        this.createTargetDirIfRequired(contributionPath);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Output output = new Output((OutputStream)new FileOutputStream(contributionPath.toFile()));){
                this.kryo.writeObject(output, (Object)contribution);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            MuleCorePlugin.logError((String)"Unexpected error writing contribution to filesystem", (Throwable)ex);
        }
    }

    private void createTargetDirIfRequired(Path filePath) {
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error creating target directory for module.", e);
        }
    }
}

