/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.editor.model.AbstractBaseEditorElement;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.contribution.global.Global;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.ElementFactory;
import org.mule.tooling.internal.extension.api.ParameterModelProcessor;

public class TypesProcessor
implements Consumer<Context> {
    @Override
    public void accept(Context context) {
        Set types = context.getModel().getTypes();
        types.stream().sorted((o1, o2) -> EditorGeneratorUtils.getTypeId((MetadataType)o1).compareTo(EditorGeneratorUtils.getTypeId((MetadataType)o2))).forEach(type -> {
            Optional resolved = context.getResolver().resolve((MetadataType)type);
            resolved.ifPresent(dslElementSyntax -> {
                String elementName = dslElementSyntax.getElementName();
                if (!context.containsNested(dslElementSyntax.getElementName())) {
                    Optional<MetadataType> baseType = context.getBaseType((ObjectType)type);
                    ParameterModelProcessor parameterModelProcessor = ParameterModelProcessor.getInstance();
                    Optional classInformation = type.getAnnotation(ClassInformationAnnotation.class);
                    if (dslElementSyntax.supportsChildDeclaration()) {
                        this.generateNestedDeclaration(context, (ObjectType)type, (DslElementSyntax)dslElementSyntax, elementName, baseType, parameterModelProcessor, classInformation);
                    }
                    if (dslElementSyntax.supportsTopLevelDeclaration()) {
                        this.generateGlobalDeclaration(context, (ObjectType)type, (DslElementSyntax)dslElementSyntax, baseType, parameterModelProcessor, classInformation);
                    }
                }
            });
        });
    }

    protected void generateGlobalDeclaration(Context context, ObjectType type, DslElementSyntax dslElementSyntax, Optional<MetadataType> baseType, ParameterModelProcessor parameterModelProcessor, Optional<ClassInformationAnnotation> classInformation) {
        Global parentGlobalDefinition = ElementFactory.getOrCreateGlobalFrom(context, dslElementSyntax, (MetadataType)type);
        this.configureClassInformation(context, baseType, classInformation, (AbstractBaseEditorElement)parentGlobalDefinition);
    }

    protected void generateNestedDeclaration(Context context, ObjectType type, DslElementSyntax dslElementSyntax, String elementName, Optional<MetadataType> baseType, ParameterModelProcessor parameterModelProcessor, Optional<ClassInformationAnnotation> classInformation) {
        Nested parentElement = ElementFactory.getOrCreateNestedElement(context, dslElementSyntax, elementName, (MetadataType)type);
        this.configureClassInformation(context, baseType, classInformation, (AbstractBaseEditorElement)parentElement);
    }

    private void configureClassInformation(Context context, Optional<MetadataType> baseType, Optional<ClassInformationAnnotation> classInformation, AbstractBaseEditorElement parentGlobalDefinition) {
        if (classInformation.isPresent()) {
            ClassInformationAnnotation classInfo = classInformation.get();
            if (classInfo.isAbstract()) {
                parentGlobalDefinition.setIsAbstract(Boolean.valueOf(classInfo.isAbstract()));
            }
            if (baseType.isPresent()) {
                DslElementSyntax dslBaseTypeSyntax = (DslElementSyntax)context.getResolver().resolve(baseType.get()).get();
                String baseTypeElementName = String.format("abstract-%s", dslBaseTypeSyntax.getElementName());
                parentGlobalDefinition.setExtendsElement(EditorGeneratorUtils.getQName(dslBaseTypeSyntax.getNamespace(), baseTypeElementName));
            }
        }
    }
}

