/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.extension.model.SubTypesModel;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.contribution.global.Global;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.ElementFactory;
import org.mule.tooling.internal.extension.api.ParameterModelProcessor;

public class SubtypesProcessor
implements Consumer<Context> {
    protected void generateGlobalDeclaration(Context context, SubTypesModel entry, MetadataType baseType, DslElementSyntax dslElementSyntax, Optional<ClassInformationAnnotation> classInformation, Global parentGlobalDefinition, ParameterModelProcessor parameterModelProcessor) {
        for (MetadataType subType : entry.getSubTypes()) {
            Optional dslSyntax = context.getResolver().resolve(subType);
            dslSyntax.ifPresent(dslSubtypeSyntax -> {
                if (dslSubtypeSyntax.supportsTopLevelDeclaration()) {
                    Global subTypeGlobalDefinition = context.containsGlobal(dslSubtypeSyntax.getElementName()) ? context.getGlobal(dslSubtypeSyntax.getElementName()) : ElementFactory.getOrCreateGlobalFrom(context, dslSubtypeSyntax, subType);
                    subTypeGlobalDefinition.setExtendsElement(EditorGeneratorUtils.getQName(dslElementSyntax.getNamespace(), parentGlobalDefinition.getLocalId()));
                }
            });
        }
    }

    protected void generatedNestedDeclaration(Context context, SubTypesModel entry, MetadataType baseType, DslElementSyntax dslElementSyntax, String elementName, Optional<ClassInformationAnnotation> classInformation, Nested parentElement, ParameterModelProcessor parameterModelProcessor) {
        for (MetadataType subType : entry.getSubTypes()) {
            Optional dslSyntax = context.getResolver().resolve(subType);
            dslSyntax.ifPresent(dslSubtypeSyntax -> {
                if (dslSubtypeSyntax.supportsChildDeclaration()) {
                    String subTypeSimpleName = dslSubtypeSyntax.getElementName();
                    Nested nestedSubType = ElementFactory.getOrCreateNestedElement(context, dslSubtypeSyntax, subTypeSimpleName, subType);
                    nestedSubType.setExtendsElement(EditorGeneratorUtils.getQName(dslElementSyntax.getNamespace(), parentElement.getLocalId()));
                }
            });
        }
    }

    public Nested createBaseNestedType(Context context, DslElementSyntax syntax, String fieldName, MetadataType metadataType) {
        Nested nestedElement = EditorGeneratorUtils.createNestedWithId(fieldName);
        if (context.belongsToCurrentNamespace(syntax)) {
            context.addNested(nestedElement);
        }
        return nestedElement;
    }

    public Global createBaseGlobalType(Context context, DslElementSyntax globalDsl, String elementName, MetadataType metadataType) {
        String globalIdCaption = EditorGeneratorUtils.getCaption(elementName);
        Global globalElement = new Global();
        globalElement.setLocalId(elementName);
        globalElement.setVersions("[4.0,10.0]");
        globalElement.setCategory("org.mule.tooling.globalCategory.componentConfigurations");
        globalElement.setCaption(globalIdCaption);
        if (context.belongsToCurrentNamespace(globalDsl)) {
            context.addGlobal(globalElement);
        }
        return globalElement;
    }

    @Override
    public void accept(Context context) {
        Set subtypesProperty = context.getModel().getSubTypes();
        subtypesProperty.stream().sorted((o1, o2) -> EditorGeneratorUtils.getTypeId((MetadataType)o1.getBaseType()).compareTo(EditorGeneratorUtils.getTypeId((MetadataType)o2.getBaseType()))).forEach(entry -> {
            ObjectType baseType = entry.getBaseType();
            DslElementSyntax dslElementSyntax = (DslElementSyntax)context.getResolver().resolve((MetadataType)baseType).get();
            String elementName = String.format("abstract-%s", dslElementSyntax.getElementName());
            Optional classInformation = baseType.getAnnotation(ClassInformationAnnotation.class);
            ParameterModelProcessor parameterModelProcessor = ParameterModelProcessor.getInstance();
            Nested parentElement = this.createBaseNestedType(context, dslElementSyntax, elementName, (MetadataType)baseType);
            if (classInformation.isPresent()) {
                parentElement.setIsAbstract(Boolean.valueOf(((ClassInformationAnnotation)classInformation.get()).isAbstract()));
            }
            this.generatedNestedDeclaration(context, (SubTypesModel)entry, (MetadataType)baseType, dslElementSyntax, elementName, classInformation, parentElement, parameterModelProcessor);
            Global parentGlobalDefinition = this.createBaseGlobalType(context, dslElementSyntax, elementName, (MetadataType)baseType);
            if (classInformation.isPresent()) {
                parentGlobalDefinition.setIsAbstract(Boolean.valueOf(((ClassInformationAnnotation)classInformation.get()).isAbstract()));
            }
            this.generateGlobalDeclaration(context, (SubTypesModel)entry, (MetadataType)baseType, dslElementSyntax, classInformation, parentGlobalDefinition, parameterModelProcessor);
        });
    }
}

