/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.List;
import java.util.Optional;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyIdModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.core.Category;
import org.mule.tooling.editor.model.MessageExchangePattern;
import org.mule.tooling.editor.model.contribution.AbstractContributionEditorElement;
import org.mule.tooling.editor.model.contribution.CloudConnectorMessageSource;
import org.mule.tooling.editor.model.contribution.Endpoint;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.editor.model.element.Group;
import org.mule.tooling.editor.model.reference.GlobalRef;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.AbstractComponentModelProcessorTemplate;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.GlobalRefFactory;
import org.mule.tooling.internal.extension.api.ParameterModelProcessor;
import org.mule.tooling.internal.extension.api.XmlOrderSupplier;
import org.mule.tooling.mule.parameters.ParametersUtils;

public class SourceItemProcessor
extends AbstractComponentModelProcessorTemplate<SourceModel, AbstractContributionEditorElement> {
    @Override
    protected List<SourceModel> getModelRootElements(ExtensionModel extensionModel) {
        return extensionModel.getSourceModels();
    }

    @Override
    protected List<SourceModel> getModelConfigurationElements(ConfigurationModel configModel) {
        return configModel.getSourceModels();
    }

    @Override
    protected DslElementSyntax resolveDslElementSyntax(DslSyntaxResolver resolver, SourceModel sourceModel) {
        return resolver.resolve(sourceModel);
    }

    @Override
    protected AbstractContributionEditorElement createEditorModel(SourceModel componentModel) {
        if (componentModel.hasResponse()) {
            return new Endpoint();
        }
        return new CloudConnectorMessageSource();
    }

    @Override
    protected void doProcess(AbstractContributionEditorElement source, AttributeCategory attributeCategory, SourceModel sourceModel, Context context, DslElementSyntax dslElementSyntax) {
        this.setSpecificInstaceAttributes(source, sourceModel, dslElementSyntax);
        sourceModel.getSuccessCallback().ifPresent(x -> this.configureRequiredSetAlternativesIfRequired(x.getParameterGroupModels(), source));
        sourceModel.getErrorCallback().ifPresent(x -> this.configureRequiredSetAlternativesIfRequired(x.getParameterGroupModels(), source));
        Optional<List<String>> associatedConfigs = context.getSourceAssociatedConfig(source.getLocalId());
        Group basicSettings = new Group();
        basicSettings.setId(context.getNamespace().getPrefix() + "ConnectorGeneric");
        basicSettings.setCaption("Basic Settings");
        if (context.getTotalSources() > 1 || associatedConfigs.isPresent() && !associatedConfigs.get().isEmpty()) {
            attributeCategory.getChildElements().add(basicSettings);
        }
        if (associatedConfigs.isPresent() && !associatedConfigs.get().isEmpty()) {
            GlobalRef createGlobalRefEditor = GlobalRefFactory.createGlobalRefEditor(context, associatedConfigs.get(), context.hasConnectionProviders());
            sourceModel.getAllParameterModels().stream().filter(x -> "config-ref".equals(x.getName())).findFirst().ifPresent(parameter -> createGlobalRefEditor.setRequired(Boolean.valueOf(parameter.isRequired())));
            createGlobalRefEditor.setTopAnchor(null);
            basicSettings.getChildElements().add(createGlobalRefEditor);
        } else {
            EditorGeneratorUtils.configureExternalLibraries(context.getModel().getExternalLibraryModels(), () -> attributeCategory);
        }
    }

    @Override
    protected void postProcessParameters(AbstractContributionEditorElement source, SourceModel sourceModel, Context context, DslElementSyntax dslElementSyntax, XmlOrderSupplier xmlOrder, List<String> processedItems) {
        sourceModel.getSuccessCallback().ifPresent(callback -> callback.getParameterGroupModels().forEach(parameterGroup -> {
            this.processParameterGroup(source, context, dslElementSyntax, xmlOrder, (ParameterGroupModel)parameterGroup);
            if (!parameterGroup.isShowInDsl()) {
                parameterGroup.getParameterModels().stream().map(ParameterModel::getName).forEach(processedItems::add);
            }
        }));
        sourceModel.getErrorCallback().ifPresent(callback -> callback.getParameterGroupModels().forEach(parameterGroupModel -> {
            if (parameterGroupModel.isShowInDsl()) {
                ParameterModelProcessor.getInstance().processParameterGroup(dslElementSyntax.getChild(parameterGroupModel.getName()), source.getLocalId(), ParametersUtils.buildGroupName((ParameterGroupModel)parameterGroupModel), source.getChildElements(), (ParameterGroupModel)parameterGroupModel, context, xmlOrder, dslElementSyntax, false);
            } else {
                ParameterModelProcessor.getInstance().processParameterGroup(source.getLocalId(), ParametersUtils.buildGroupName((ParameterGroupModel)parameterGroupModel), source.getChildElements(), (ParameterGroupModel)parameterGroupModel, dslElementSyntax, context, processedItems, xmlOrder.getNextXmlOrder());
            }
        }));
    }

    private void setSpecificInstaceAttributes(AbstractContributionEditorElement source, SourceModel sourceModel, DslElementSyntax dslElementSyntax) {
        if (sourceModel.hasResponse()) {
            this.setEndpointAttributes(source, dslElementSyntax);
        } else {
            this.setCloudMessageSourceAttributes(source, dslElementSyntax);
        }
    }

    private void setEndpointAttributes(AbstractContributionEditorElement source, DslElementSyntax dslElementSyntax) {
        Endpoint endpoint = (Endpoint)source;
        endpoint.setSupportsInbound(Boolean.valueOf(true));
        endpoint.setCategory(Category.CLOUD_CONNECTORS.getCategoryString());
        endpoint.setSupportsOutbound(Boolean.valueOf(false));
        endpoint.setInboundLocalName(dslElementSyntax.getElementName());
        endpoint.setDefaultMep(MessageExchangePattern.REQUEST_RESPONSE);
    }

    private void setCloudMessageSourceAttributes(AbstractContributionEditorElement source, DslElementSyntax dslElementSyntax) {
        CloudConnectorMessageSource cloudConnector = (CloudConnectorMessageSource)source;
        cloudConnector.setCategory(Category.CLOUD_CONNECTORS.getCategoryString());
        cloudConnector.setSupportsInbound(Boolean.valueOf(true));
        cloudConnector.setSupportsOutbound(Boolean.valueOf(false));
        cloudConnector.setInboundLocalName(dslElementSyntax.getElementName());
    }

    @Override
    protected void addToContext(AbstractContributionEditorElement editorElement, SourceModel componentModel, Context context) {
        context.addSource(editorElement);
    }

    @Override
    protected Optional<MetadataKeyIdModel> getMetadataKeyIdModel(SourceModel componentModel) {
        return componentModel.getMetadataKeyIdModel();
    }
}

