/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.extension.model.LayoutModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.editor.model.element.BaseChildEditorElement;
import org.mule.tooling.editor.model.element.ChildElement;
import org.mule.tooling.editor.model.element.Custom;
import org.mule.tooling.editor.model.element.Group;
import org.mule.tooling.editor.model.element.LabelElement;
import org.mule.tooling.extension.api.Activator;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.extension.api.generation.UnexpectedDslElementSyntaxError;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.ParameterModelComparator;
import org.mule.tooling.internal.extension.api.XmlOrderSupplier;
import org.mule.tooling.internal.extension.api.parameter.ArrayParameterProcessorDelegate;
import org.mule.tooling.internal.extension.api.parameter.BooleanParameterProcessorDelegate;
import org.mule.tooling.internal.extension.api.parameter.DefaultParameterProcessorDelegate;
import org.mule.tooling.internal.extension.api.parameter.DictionaryParameterProcessorDelegate;
import org.mule.tooling.internal.extension.api.parameter.FieldDescriptor;
import org.mule.tooling.internal.extension.api.parameter.IEditorElementFactory;
import org.mule.tooling.internal.extension.api.parameter.NumberParameterProcessorDelegate;
import org.mule.tooling.internal.extension.api.parameter.ObjectParameterProcessorDelegate;
import org.mule.tooling.internal.extension.api.parameter.StringParameterProcessorDelegate;
import org.mule.tooling.internal.extension.api.parameter.UnionParameterProcessorDelegate;
import org.mule.tooling.ui.MuleUIPlugin;

public class ParameterModelProcessor {
    private static ParameterModelProcessor INSTANCE = new ParameterModelProcessor();
    private IEditorElementFactory defaultEditorElementFactory = new DefaultParameterProcessorDelegate();
    private IEditorElementFactory booleanParameterProcessorDelegate = new BooleanParameterProcessorDelegate();
    private IEditorElementFactory numberParameterProcessor = new NumberParameterProcessorDelegate();
    private IEditorElementFactory stringParameterProcessor = new StringParameterProcessorDelegate();
    private IEditorElementFactory objectParameterProcessor = new ObjectParameterProcessorDelegate();
    private IEditorElementFactory arrayParameterProcessor = new ArrayParameterProcessorDelegate();
    private IEditorElementFactory dictionaryParameterProcessor = new DictionaryParameterProcessorDelegate();
    private IEditorElementFactory unionParameterProcessor = new UnionParameterProcessorDelegate();

    private ParameterModelProcessor() {
    }

    public static ParameterModelProcessor getInstance() {
        return INSTANCE;
    }

    public void processParameterGroup(Optional<DslElementSyntax> parameterGroupDsl, String operationName, String path, List<BaseChildEditorElement> attributeCategories, ParameterGroupModel parameterGroup, Context context, XmlOrderSupplier xmlOrder, DslElementSyntax parentDsl, boolean isGlobalElement) {
        context.setOperationName(operationName);
        ParameterModelComparator comparator = new ParameterModelComparator();
        if (parameterGroup.isShowInDsl() && parameterGroupDsl.isPresent()) {
            List<BaseChildEditorElement> container = this.generateNestedForParameterGroup(attributeCategories, parameterGroup, context, parameterGroupDsl.get(), xmlOrder.getNextXmlOrder());
            XmlOrderSupplier xmlOrderSupplier = new XmlOrderSupplier();
            Map<ParameterModel, Integer> xmlOrdersMap = this.getXmlOrdersMapForParameterGroup(parameterGroup, xmlOrderSupplier, isGlobalElement);
            this.getParameterModelsToProcess(parameterGroup, isGlobalElement).sorted(comparator).forEach(parameterModel -> this.addParameter(operationName, path + parameterModel.getName(), (ParameterModel)parameterModel, (DslElementSyntax)((DslElementSyntax)parameterGroupDsl.get()).getContainedElement(parameterModel.getName()).orElseThrow(() -> new UnexpectedDslElementSyntaxError(parameterModel.getName(), (DslElementSyntax)parameterGroupDsl.get())), parameterGroup.getName(), container, context, (Integer)xmlOrdersMap.get(parameterModel)));
        } else {
            List<BaseChildEditorElement> container = attributeCategories;
            Map<ParameterModel, Integer> xmlOrdersMap = this.getXmlOrdersMapForParameterGroup(parameterGroup, xmlOrder, isGlobalElement);
            this.getParameterModelsToProcess(parameterGroup, isGlobalElement).sorted(comparator).forEach(parameterModel -> this.processParameter(operationName, path + parameterModel.getName(), parameterGroup.getName(), container, (ParameterModel)parameterModel, (DslElementSyntax)parentDsl.getContainedElement(parameterModel.getName()).orElseThrow(() -> new UnexpectedDslElementSyntaxError(parameterModel.getName(), parentDsl)), context, (Integer)xmlOrdersMap.get(parameterModel)));
        }
    }

    private Map<ParameterModel, Integer> getXmlOrdersMapForParameterGroup(ParameterGroupModel parameterGroup, XmlOrderSupplier xmlOrderSupplier, boolean isGlobalElement) {
        HashMap<ParameterModel, Integer> xmlOrdersMap = new HashMap<ParameterModel, Integer>();
        this.getParameterModelsToProcess(parameterGroup, isGlobalElement).forEach(parameterModel -> xmlOrdersMap.put((ParameterModel)parameterModel, xmlOrderSupplier.getParameterModelOrder((ParameterModel)parameterModel)));
        return xmlOrdersMap;
    }

    private Stream<ParameterModel> getParameterModelsToProcess(ParameterGroupModel parameterGroup, boolean isGlobalElement) {
        return parameterGroup.getParameterModels().stream().filter(x -> !EditorGeneratorUtils.isReservedParameterName(x.getName(), isGlobalElement));
    }

    protected List<BaseChildEditorElement> generateNestedForParameterGroup(List<BaseChildEditorElement> attributeCategories, ParameterGroupModel parameterGroupModel, Context context, DslElementSyntax childDsl, int xmlOrder) {
        Nested nestedElement = EditorGeneratorUtils.createNestedWithId(childDsl.getElementName());
        nestedElement.setCaption(parameterGroupModel.getName());
        List container = nestedElement.getChildElements();
        context.getNamespace().getComponents().add(nestedElement);
        ChildElement childElement = new ChildElement();
        childElement.setInplace(Boolean.valueOf(true));
        childElement.setAllowMultiple(Boolean.valueOf(false));
        childElement.setXmlOrder(Integer.valueOf(xmlOrder));
        childElement.setName(EditorGeneratorUtils.getQName(childDsl));
        boolean addNewTab = this.areAllParameterInTheSameTab(parameterGroupModel);
        if (addNewTab) {
            this.getOrCreateContainerFromLayout(parameterGroupModel.getName(), attributeCategories, ((ParameterModel)parameterGroupModel.getParameterModels().stream().findFirst().get()).getLayoutModel()).add((BaseChildEditorElement)childElement);
        } else {
            this.getOrCreateContainerFromLayout(parameterGroupModel.getName(), attributeCategories, parameterGroupModel.getLayoutModel()).add((BaseChildEditorElement)childElement);
        }
        return container;
    }

    private boolean areAllParameterInTheSameTab(ParameterGroupModel parameterGroupModel) {
        Set layoutProperties = parameterGroupModel.getParameterModels().stream().map(ParameterModel::getLayoutModel).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (layoutProperties.size() == parameterGroupModel.getParameterModels().size()) {
            Set tabs = layoutProperties.stream().map(LayoutModel::getTabName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            return tabs.size() == 1;
        }
        return false;
    }

    public void processParameterGroup(String operationName, String path, List<BaseChildEditorElement> attributeCategories, ParameterGroupModel parameterGroupModel, DslElementSyntax parameterModelSyntax, Context context, List<String> processedFields, int xmlOrder) {
        context.setOperationName(operationName);
        XmlOrderSupplier xmlOrderSupplier = new XmlOrderSupplier();
        parameterGroupModel.getParameterModels().stream().forEach(parameterModel -> {
            if (!processedFields.contains(parameterModel.getName())) {
                this.processParameter(operationName, path + parameterModel.getName(), parameterGroupModel.getName(), attributeCategories, (ParameterModel)parameterModel, parameterModelSyntax, context, xmlOrderSupplier.getParameterModelOrder((ParameterModel)parameterModel));
            }
        });
    }

    public void processParameter(String operationName, String path, String groupName, List<BaseChildEditorElement> attributeCategories, ParameterModel parameterModel, DslElementSyntax parameterModelSyntax, Context context, int xmlOrder) {
        List<BaseChildEditorElement> container = this.getContainer(groupName, attributeCategories, parameterModel);
        this.addParameter(operationName, path, parameterModel, parameterModelSyntax, groupName, container, context, xmlOrder);
    }

    protected List<BaseChildEditorElement> getContainer(String groupName, List<BaseChildEditorElement> attributeCategories, ParameterModel parameterModel) {
        List container;
        boolean outputOperationType = this.useOutputPage();
        Optional property = parameterModel.getLayoutModel();
        if (EditorGeneratorUtils.isContentMetadataParameter(parameterModel.getName())) {
            Group mimeTypeGroup = outputOperationType ? this.getOrCreateMimeTypeOutputTypeGroup(attributeCategories) : this.getOrCreateMimeTypeGroup(attributeCategories);
            container = mimeTypeGroup.getChildElements();
        } else if (outputOperationType && EditorGeneratorUtils.isTargetMetadataParameter(parameterModel.getName())) {
            Group outputContainer = this.getOrCreateTargetOutputTypeGroup(attributeCategories);
            container = outputContainer.getChildElements();
        } else {
            container = this.getOrCreateContainerFromLayout(groupName, attributeCategories, property);
        }
        return container;
    }

    public boolean useOutputPage() {
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("output_operation_re_type");
    }

    protected List<BaseChildEditorElement> getOrCreateContainerFromLayout(String groupName, List<BaseChildEditorElement> attributeCategories, Optional<LayoutModel> property) {
        List container;
        if (property.isPresent()) {
            LayoutModel layoutModel = property.get();
            String tabName = layoutModel.getTabName().orElse("General");
            if (StringUtils.isEmpty((String)tabName)) {
                tabName = "General";
            }
            AttributeCategory category = this.getOrCreateTab(attributeCategories, tabName);
            Group group = EditorGeneratorUtils.getOrCreateGroup(groupName, category.getChildElements());
            container = group.getChildElements();
        } else {
            String tabName = "General";
            AttributeCategory category = this.getOrCreateTab(attributeCategories, tabName);
            Group group = EditorGeneratorUtils.getOrCreateGroup(groupName, category.getChildElements());
            container = group.getChildElements();
        }
        return container;
    }

    public void addParameter(String operationName, String path, ParameterModel parameterModel, DslElementSyntax parameterModelSyntax, String groupName, List<BaseChildEditorElement> container, Context context, int xmlOrder) {
        FieldDescriptor fieldDescriptor = EditorGeneratorUtils.from(parameterModel, groupName, path, context, xmlOrder, parameterModelSyntax);
        parameterModel.getType().accept(this.getDataQualifierVisitor(operationName, path, context, fieldDescriptor, container, parameterModel.getAllowedStereotypes()));
    }

    public MetadataTypeVisitor getDataQualifierVisitor(final String operationName, final String path, final Context context, final FieldDescriptor fieldDescriptor, final List<BaseChildEditorElement> container, final List<StereotypeModel> references) {
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                if (fieldDescriptor.isSupportsExpression()) {
                    container.add(EditorGeneratorUtils.createMuleExpressionLanguageEditor(fieldDescriptor));
                } else {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "Unhandled Type:" + metadataType.getClass().getName(), "Check:" + path + String.valueOf(fieldDescriptor.getSyntax())));
                }
            }

            public void visitSimpleType(SimpleType simpleType) {
                this.defaultVisit((MetadataType)simpleType);
            }

            public void visitAnyType(AnyType anyType) {
                container.add(ParameterModelProcessor.this.defaultEditorElementFactory.createEditor(operationName, path, fieldDescriptor, context, references));
            }

            public void visitArrayType(ArrayType arrayType) {
                if (EditorGeneratorUtils.needsLabel(fieldDescriptor)) {
                    LabelElement label = this.createLabelFrom(fieldDescriptor);
                    container.add(label);
                }
                container.add(ParameterModelProcessor.this.arrayParameterProcessor.createEditor(operationName, path, fieldDescriptor, context, references));
            }

            public void visitBinaryType(BinaryType binaryType) {
                container.add(ParameterModelProcessor.this.defaultEditorElementFactory.createEditor(operationName, path, fieldDescriptor, context, references));
            }

            public void visitBoolean(BooleanType booleanType) {
                container.add(ParameterModelProcessor.this.booleanParameterProcessorDelegate.createEditor(operationName, path, fieldDescriptor, context, references));
            }

            public void visitDateTime(DateTimeType dateTimeType) {
                container.add(ParameterModelProcessor.this.defaultEditorElementFactory.createEditor(operationName, path, fieldDescriptor, context, references));
            }

            public void visitDate(DateType dateType) {
                container.add(ParameterModelProcessor.this.defaultEditorElementFactory.createEditor(operationName, path, fieldDescriptor, context, references));
            }

            public void visitIntersection(IntersectionType intersectionType) {
                this.defaultVisit((MetadataType)intersectionType);
            }

            public void visitNull(NullType nullType) {
                this.defaultVisit((MetadataType)nullType);
            }

            public void visitNumber(NumberType numberType) {
                container.add(ParameterModelProcessor.this.numberParameterProcessor.createEditor(operationName, path, fieldDescriptor, context, references));
            }

            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    container.add(ParameterModelProcessor.this.dictionaryParameterProcessor.createEditor(operationName, path, fieldDescriptor, context, references));
                } else {
                    if (EditorGeneratorUtils.needsLabel(fieldDescriptor)) {
                        LabelElement label = this.createLabelFrom(fieldDescriptor);
                        container.add(label);
                    }
                    container.add(ParameterModelProcessor.this.objectParameterProcessor.createEditor(operationName, path, fieldDescriptor, context, references));
                }
            }

            private LabelElement createLabelFrom(FieldDescriptor fieldDescriptor2) {
                LabelElement label = new LabelElement();
                label.setName("label-separator-" + fieldDescriptor2.getSyntax().getElementName());
                label.setCaption(fieldDescriptor2.getCaption());
                return label;
            }

            public void visitString(StringType stringType) {
                container.add(ParameterModelProcessor.this.stringParameterProcessor.createEditor(operationName, path, fieldDescriptor, context, references));
            }

            public void visitTime(TimeType timeType) {
                container.add(ParameterModelProcessor.this.defaultEditorElementFactory.createEditor(operationName, path, fieldDescriptor, context, references));
            }

            public void visitTuple(TupleType tupleType) {
                this.defaultVisit((MetadataType)tupleType);
            }

            public void visitUnion(UnionType unionType) {
                container.add(ParameterModelProcessor.this.unionParameterProcessor.createEditor(operationName, path, fieldDescriptor, context, references));
            }

            public void visitObjectKey(ObjectKeyType objectKeyType) {
                this.defaultVisit((MetadataType)objectKeyType);
            }

            public void visitAttributeKey(AttributeKeyType attributeKeyType) {
                this.defaultVisit((MetadataType)attributeKeyType);
            }

            public void visitAttributeField(AttributeFieldType attributeFieldType) {
                this.defaultVisit((MetadataType)attributeFieldType);
            }

            public void visitObjectField(ObjectFieldType objectFieldType) {
                this.defaultVisit((MetadataType)objectFieldType);
            }
        };
    }

    private Group getOrCreateMimeTypeOutputTypeGroup(List<BaseChildEditorElement> parents) {
        return this.getOrCreateGroup(parents, "mimeTypeGroup", "MIME Type");
    }

    private Group getOrCreateGroup(List<BaseChildEditorElement> parents, String groupId, String groupCaption) {
        AttributeCategory attributeCategory = this.getOrCreateOutputAttributeCategory(parents);
        Optional<BaseChildEditorElement> mimeTypeGroup = this.searchGroupById(attributeCategory, groupId);
        if (mimeTypeGroup.isPresent()) {
            return (Group)mimeTypeGroup.get();
        }
        Group newGroup = EditorGeneratorUtils.createGroupWith(groupId, groupCaption);
        attributeCategory.getChildElements().add(newGroup);
        return newGroup;
    }

    private Group getOrCreateTargetOutputTypeGroup(List<BaseChildEditorElement> parents) {
        return this.getOrCreateGroup(parents, "targetGroup", "Target");
    }

    public Optional<BaseChildEditorElement> searchGroupById(AttributeCategory attributeCategory, String groupId) {
        return attributeCategory.getChildElements().stream().filter(child -> {
            if (child instanceof Group) {
                return ((Group)child).getId().equals(groupId);
            }
            return false;
        }).findFirst();
    }

    public AttributeCategory getOrCreateOutputAttributeCategory(List<BaseChildEditorElement> parents) {
        for (BaseChildEditorElement parent : parents) {
            AttributeCategory category;
            if (!(parent instanceof AttributeCategory) || (category = (AttributeCategory)parent).getId() != "outputAttributeCategory") continue;
            return category;
        }
        AttributeCategory outputAttributeCategory = new AttributeCategory();
        outputAttributeCategory.setCaption("Output");
        outputAttributeCategory.setDescription("Configure the output of this message processor.");
        outputAttributeCategory.setId("outputAttributeCategory");
        parents.add((BaseChildEditorElement)outputAttributeCategory);
        Group metadataTypeGroup = EditorGeneratorUtils.createGroupWith("metadataTypeGroup", null);
        outputAttributeCategory.getChildElements().add(metadataTypeGroup);
        Custom metadataFieldEditor = new Custom();
        metadataFieldEditor.setCaption("Metadata");
        metadataFieldEditor.setClassName("org.mule.tooling.ui.modules.core.metadata.multilevel.OutputMetadataChooser");
        metadataTypeGroup.getChildElements().add(metadataFieldEditor);
        return outputAttributeCategory;
    }

    private Group getOrCreateMimeTypeGroup(List<BaseChildEditorElement> parents) {
        for (BaseChildEditorElement parent : parents) {
            AttributeCategory category;
            if (!(parent instanceof AttributeCategory) || (category = (AttributeCategory)parent).getId() != "mimeTypeAttributeCategory") continue;
            return (Group)category.getChildElements().get(0);
        }
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption("MIME Type");
        attributeCategory.setDescription("MIME Type configuration");
        attributeCategory.setId("mimeTypeAttributeCategory");
        Group group = EditorGeneratorUtils.createGroupWith("mimeTypeGroup", "MIME Type");
        attributeCategory.getChildElements().add(group);
        parents.add((BaseChildEditorElement)attributeCategory);
        return group;
    }

    protected AttributeCategory getOrCreateTab(List<BaseChildEditorElement> parents, String tabName) {
        AttributeCategory category = null;
        for (BaseChildEditorElement parent : parents) {
            if (!(parent instanceof AttributeCategory) || !parent.getCaption().equals(tabName)) continue;
            category = (AttributeCategory)parent;
            break;
        }
        if (category == null) {
            category = new AttributeCategory();
            category.setCaption(tabName);
            if ("General".equals(tabName)) {
                parents.add(0, (BaseChildEditorElement)category);
            } else {
                parents.add((BaseChildEditorElement)category);
            }
        }
        return category;
    }
}

