/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.Comparator;
import java.util.Optional;
import org.mule.tooling.client.api.extension.model.LayoutModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;

public class ParameterModelComparator
implements Comparator<ParameterModel> {
    @Override
    public int compare(ParameterModel o1, ParameterModel o2) {
        Optional layout1 = o1.getLayoutModel();
        Optional layout2 = o2.getLayoutModel();
        if (layout1.isPresent() && layout2.isPresent()) {
            String tab2;
            String tab1 = ((LayoutModel)layout1.get()).getTabName().orElse("General");
            if (tab1.equals(tab2 = ((LayoutModel)layout2.get()).getTabName().orElse("General"))) {
                int order2;
                int order1 = ((LayoutModel)layout1.get()).getOrder().orElse(Integer.MAX_VALUE);
                int compare = Integer.compare(order1, order2 = ((LayoutModel)layout2.get()).getOrder().orElse(Integer.MAX_VALUE).intValue());
                if (compare == 0) {
                    return -1 * Boolean.compare(o1.isRequired(), o2.isRequired());
                }
                return compare;
            }
            if ("General".equals(tab1)) {
                return -1;
            }
            if ("General".equals(tab2)) {
                if ("Advanced".equals(tab1)) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
        if (layout1.isPresent() ^ layout2.isPresent()) {
            return 0;
        }
        return -1 * Boolean.compare(o1.isRequired(), o2.isRequired());
    }
}

