/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.List;
import java.util.Optional;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyIdModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.nested.NestedRouteModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.editor.model.EditorElementVisitorAdapter;
import org.mule.tooling.editor.model.IEditorElementVisitor;
import org.mule.tooling.editor.model.contribution.AbstractContributionEditorElement;
import org.mule.tooling.editor.model.contribution.CloudConnector;
import org.mule.tooling.editor.model.contribution.Container;
import org.mule.tooling.editor.model.contribution.Splitter;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.AbstractComponentModelProcessorTemplate;
import org.mule.tooling.internal.extension.api.CloudConnectorItemProcessor;
import org.mule.tooling.internal.extension.api.NestableContainerItemProcessor;
import org.mule.tooling.internal.extension.api.NestableElementModelVisitorAdapter;
import org.mule.tooling.internal.extension.api.NestableSplitterItemProcessor;
import org.mule.tooling.internal.extension.api.XmlOrderSupplier;
import org.mule.tooling.utils.ObjectHolder;

public class OperationItemProcessor
extends AbstractComponentModelProcessorTemplate<OperationModel, AbstractContributionEditorElement> {
    private final NestableContainerItemProcessor delegate = new NestableContainerItemProcessor();
    private final NestableSplitterItemProcessor splitterDelegate = new NestableSplitterItemProcessor();
    private final CloudConnectorItemProcessor cloudConnectorDelegate = new CloudConnectorItemProcessor();

    private boolean hasNestedComponents(OperationModel operationModel) {
        return !operationModel.getNestedComponents().isEmpty();
    }

    @Override
    protected List<OperationModel> getModelRootElements(ExtensionModel extensionModel) {
        return extensionModel.getOperationModels();
    }

    @Override
    protected List<OperationModel> getModelConfigurationElements(ConfigurationModel extensionModel) {
        return extensionModel.getOperationModels();
    }

    @Override
    protected DslElementSyntax resolveDslElementSyntax(DslSyntaxResolver resolver, OperationModel operationModel) {
        return resolver.resolve(operationModel);
    }

    @Override
    protected AbstractContributionEditorElement createEditorModel(OperationModel componentModel) {
        if (componentModel.getStereotype().isFlow()) {
            return this.delegate.createEditorModel((ComponentModel)componentModel);
        }
        if (this.hasNestedComponents(componentModel)) {
            if (this.hasRouteComponents(componentModel.getNestedComponents())) {
                return this.splitterDelegate.createEditorModel((ComponentModel)componentModel);
            }
            return this.delegate.createEditorModel((ComponentModel)componentModel);
        }
        return this.cloudConnectorDelegate.createEditorModel(componentModel);
    }

    private boolean hasRouteComponents(List<? extends NestableElementModel> nestableComponents) {
        final ObjectHolder hasRoutes = new ObjectHolder((Object)false);
        NestableElementModelVisitorAdapter visitor = new NestableElementModelVisitorAdapter(){

            @Override
            public void visit(NestedRouteModel route) {
                hasRoutes.set((Object)true);
            }
        };
        nestableComponents.forEach(nested -> nested.accept(visitor));
        return (Boolean)hasRoutes.get();
    }

    @Override
    protected void doProcess(AbstractContributionEditorElement editorElement, final AttributeCategory attributeCategory, final OperationModel operationModel, final Context context, final DslElementSyntax dslElementSyntax) {
        editorElement.accept((IEditorElementVisitor)new EditorElementVisitorAdapter(){

            public void visit(Container container) {
                OperationItemProcessor.this.delegate.doProcess(container, attributeCategory, (ComponentModel)operationModel, context, dslElementSyntax);
            }

            public void visit(CloudConnector container) {
                OperationItemProcessor.this.cloudConnectorDelegate.doProcess(container, attributeCategory, operationModel, context, dslElementSyntax);
            }

            public void visit(Splitter container) {
                OperationItemProcessor.this.splitterDelegate.doProcess(container, attributeCategory, (ComponentModel)operationModel, context, dslElementSyntax);
            }
        });
    }

    @Override
    protected void addToContext(AbstractContributionEditorElement editorElement, OperationModel operationModel, Context context) {
        context.addOperation(editorElement);
    }

    @Override
    protected Optional<MetadataKeyIdModel> getMetadataKeyIdModel(OperationModel componentModel) {
        return componentModel.getMetadataKeyIdModel();
    }

    @Override
    protected void processNestableElements(AbstractContributionEditorElement editorElement, final OperationModel componentModel, final Context context, final DslElementSyntax dslElementSyntax, final XmlOrderSupplier xmlOrder) {
        editorElement.accept((IEditorElementVisitor)new EditorElementVisitorAdapter(){

            public void visit(Container container) {
                OperationItemProcessor.this.delegate.processNestableElements((AbstractContributionEditorElement)container, (ComponentModel)componentModel, context, dslElementSyntax, xmlOrder);
            }

            public void visit(Splitter container) {
                OperationItemProcessor.this.splitterDelegate.processNestableElements((AbstractContributionEditorElement)container, (ComponentModel)componentModel, context, dslElementSyntax, xmlOrder);
            }
        });
    }
}

