/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.editor.model.element.MultiWay;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.parameter.FieldDescriptor;
import org.mule.tooling.internal.extension.api.parameter.MultiWayMode;

public class MultiWayFactory {
    private MultiWayFactory() {
    }

    public static boolean needsMultiWayEditor(FieldDescriptor fieldDescriptor, Context context) {
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        boolean supportsExpression = fieldDescriptor.isSupportsExpression();
        boolean supportsTopLevelDeclaration = syntax.supportsTopLevelDeclaration();
        boolean allowesReferences = fieldDescriptor.isAllowesReferences() && !syntax.supportsTopLevelDeclaration() && syntax.supportsAttributeDeclaration();
        boolean supportsChildDeclaration = syntax.supportsChildDeclaration() || syntax.isWrapped();
        boolean hasSubTypes = context.hasSubTypes((MetadataType)fieldDescriptor.getMetadataType());
        int totalEditionModes = 0;
        if (supportsExpression) {
            ++totalEditionModes;
        }
        if (allowesReferences) {
            ++totalEditionModes;
        }
        if (supportsTopLevelDeclaration) {
            ++totalEditionModes;
        }
        if (supportsChildDeclaration) {
            ++totalEditionModes;
        }
        if (!fieldDescriptor.isRequired()) {
            ++totalEditionModes;
        }
        if (hasSubTypes) {
            ++totalEditionModes;
        }
        return totalEditionModes > 1;
    }

    public static MultiWay createFrom(FieldDescriptor fieldDescriptor, Context context) {
        MultiWay multiWay = new MultiWay();
        multiWay.setModes(MultiWayFactory.getModesFieldValueFor(fieldDescriptor, context));
        multiWay.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
        multiWay.setDescription(fieldDescriptor.getDescription());
        multiWay.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
        multiWay.setCanonicalPath(fieldDescriptor.getCanonicalPath());
        MultiWayFactory.setDefaultTypeIfProvided(fieldDescriptor, context, multiWay);
        return multiWay;
    }

    private static String getModesFieldValueFor(FieldDescriptor fieldDescriptor, Context context) {
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        boolean supportsExpression = fieldDescriptor.isSupportsExpression();
        boolean allowesReferences = fieldDescriptor.isAllowesReferences() && !syntax.supportsTopLevelDeclaration() && syntax.supportsAttributeDeclaration();
        boolean supportsTopLevelDeclaration = syntax.supportsTopLevelDeclaration();
        boolean supportsChildDeclaration = syntax.supportsChildDeclaration() || syntax.isWrapped();
        boolean hasSubTypes = context.hasSubTypes((MetadataType)fieldDescriptor.getMetadataType());
        ArrayList<String> modes = new ArrayList<String>();
        if (supportsExpression) {
            modes.add(MultiWayMode.REF.name());
        }
        if (allowesReferences) {
            modes.add(MultiWayMode.BEAN.name());
        }
        if (supportsTopLevelDeclaration) {
            modes.add(MultiWayMode.GLOBAL.name());
        }
        if (supportsChildDeclaration || hasSubTypes || syntax.isWrapped()) {
            modes.add(MultiWayMode.INLINE.name());
        }
        return modes.stream().collect(Collectors.joining("|"));
    }

    private static void setDefaultTypeIfProvided(FieldDescriptor fieldDescriptor, Context context, MultiWay multiWayEditor) {
        Optional resolve;
        Optional<MetadataType> defaultType = fieldDescriptor.getDefaultType();
        if (defaultType.isPresent() && (resolve = context.getResolver().resolve(defaultType.get())).isPresent()) {
            DslElementSyntax defaultDsl = (DslElementSyntax)resolve.get();
            multiWayEditor.setDefaultType(EditorGeneratorUtils.getQName(defaultDsl));
        }
    }
}

