/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.editor.model.Activator;

class MulePathUtils {
    public static final String NAME_PATH = "${name}";
    public static final String PROCESSORS_PATH = "processors";
    public static final String SOURCE_PATH = "source";
    public static final String ERROR_HANDLER_PATH = "errorHandler";
    public static final String MULE_NAMESPACE = "MULE";

    private MulePathUtils() {
    }

    public static String getPathExpressionFor(Collection<StereotypeModel> stereotypeModel) {
        return MulePathUtils.getPathExpressionFor(stereotypeModel.iterator().next());
    }

    public static String getPathExpressionFor(StereotypeModel stereotypeModel) {
        Objects.requireNonNull(stereotypeModel, "stereotypeModel must not be null");
        if (stereotypeModel.isSource()) {
            return SOURCE_PATH;
        }
        if (stereotypeModel.isFlow()) {
            return NAME_PATH;
        }
        if (stereotypeModel.isProcessor()) {
            return PROCESSORS_PATH;
        }
        if (stereotypeModel.isModuleConfig()) {
            return NAME_PATH;
        }
        if (MulePathUtils.isErrorHandler(stereotypeModel)) {
            return ERROR_HANDLER_PATH;
        }
        if (MulePathUtils.isOnError(stereotypeModel)) {
            return PROCESSORS_PATH;
        }
        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.mule.tooling.editor.model", "Unknow Stereotype [" + String.valueOf(stereotypeModel) + "]. Element path will be associated to processorsThis may affect how debugger works."));
        return PROCESSORS_PATH;
    }

    public static boolean isOnError(StereotypeModel stereotypeModel) {
        return MULE_NAMESPACE.equals(stereotypeModel.getNamespace()) && "ON_ERROR".equals(stereotypeModel.getType());
    }

    public static boolean isErrorHandler(StereotypeModel stereotypeModel) {
        return MULE_NAMESPACE.equals(stereotypeModel.getNamespace()) && "ERROR_HANDLER".equals(stereotypeModel.getType());
    }
}

