/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.List;
import java.util.Optional;
import org.mule.tooling.editor.model.reference.GlobalRef;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;

public class GlobalRefFactory {
    private GlobalRefFactory() {
    }

    public static GlobalRef createGlobalRefEditor(Context context, List<String> associatedConfigs, boolean hasConnectionProvider) {
        GlobalRef globalRef = new GlobalRef();
        globalRef.setRequired(Boolean.valueOf(!context.areAllConfigsOptionals(associatedConfigs)));
        globalRef.setName("config-ref");
        globalRef.setCaption(hasConnectionProvider ? "Connector configuration" : "Module configuration");
        globalRef.setDescription("Specify which configuration to use for this invocation.");
        if (associatedConfigs.size() == 1) {
            globalRef.setRequiredType(EditorGeneratorUtils.getQName(context.getNamespace().getUrl(), associatedConfigs.iterator().next()));
        } else {
            String url = context.getNamespace().getUrl();
            Optional<String> values = associatedConfigs.stream().sorted().map(x -> EditorGeneratorUtils.getQName(url, x)).reduce((x, y) -> x + ", " + y);
            globalRef.setRequiredType(String.format("$%s", values.get()));
        }
        if (context.getTotalOperations() == 1) {
            globalRef.setTopAnchor("$");
        }
        return globalRef;
    }
}

