/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.editor.model.AbstractBaseEditorElement;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.contribution.global.Global;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.editor.model.element.Group;
import org.mule.tooling.editor.model.element.NameEditor;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.parameter.BaseEditorElementFactory;
import org.mule.tooling.internal.extension.api.parameter.MuleStereotypes;

public class ElementFactory {
    private ElementFactory() {
    }

    public static Global getOrCreateGlobalFrom(final Context context, final DslElementSyntax globalDsl, MetadataType metadataType) {
        final String globalId = globalDsl.getElementName();
        if (context.containsGlobal(globalId)) {
            return context.getGlobal(globalId);
        }
        String globalIdCaption = EditorGeneratorUtils.getCaption(globalId);
        Global globalElement = new Global();
        globalElement.setLocalId(globalId);
        globalElement.setVersions("[4.0,10.0]");
        globalElement.setCategory("org.mule.tooling.globalCategory.componentConfigurations");
        globalElement.setCaption(globalIdCaption);
        if (context.belongsToCurrentNamespace(globalDsl)) {
            ElementFactory.setExtendsElementIfRequired(metadataType, (AbstractBaseEditorElement)globalElement);
            globalElement.setDescription(String.format("Global %s configuration", globalIdCaption));
            EditorGeneratorUtils.setIcons(context.getModuleId(), (AbstractBaseEditorElement)globalElement, context.getNamespace());
            AttributeCategory attributeCategory = new AttributeCategory();
            attributeCategory.setDescription("General Settings");
            attributeCategory.setCaption("General");
            Group group = EditorGeneratorUtils.createGroupWith("basicGenericProperties", "Basic Settings");
            NameEditor name = EditorGeneratorUtils.createNameEditorWithDescription(String.format("Give a name to this %s so it can be later referenced.", globalIdCaption));
            group.getChildElements().add(name);
            attributeCategory.getChildElements().add(group);
            globalElement.getChildElements().add(attributeCategory);
            final Group entityGroup = EditorGeneratorUtils.createGroupWith(globalId, globalIdCaption);
            attributeCategory.getChildElements().add(entityGroup);
            context.addGlobal(globalElement);
            metadataType.accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    BaseEditorElementFactory.processPojoFields(globalId, globalId, globalDsl, entityGroup.getChildElements(), context, objectType);
                }
            });
        }
        return globalElement;
    }

    public static Nested getOrCreateNestedElement(final Context context, final DslElementSyntax syntax, final String fieldName, MetadataType metadataType) {
        if (context.containsNested(fieldName)) {
            return context.getNested(fieldName);
        }
        final Nested nestedElement = EditorGeneratorUtils.createNestedWithId(fieldName);
        ElementFactory.setExtendsElementIfRequired(metadataType, (AbstractBaseEditorElement)nestedElement);
        nestedElement.setDescription("");
        if (context.belongsToCurrentNamespace(syntax)) {
            context.addNested(nestedElement);
            metadataType.accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    BaseEditorElementFactory.processPojoFields(fieldName, fieldName, syntax, nestedElement.getChildElements(), context, objectType);
                }
            });
        }
        return nestedElement;
    }

    private static void setExtendsElementIfRequired(MetadataType metadataType, AbstractBaseEditorElement globalElement) {
        StereotypeModel stereotypeModel;
        StereotypeTypeAnnotation stereotypeTypeAnnotation;
        Optional stereotype = metadataType.getAnnotation(StereotypeTypeAnnotation.class);
        if (stereotype.isPresent() && !(stereotypeTypeAnnotation = (StereotypeTypeAnnotation)stereotype.get()).getStereotypeModel().isEmpty() && MuleStereotypes.isObjectStoreStereotype(stereotypeModel = (StereotypeModel)stereotypeTypeAnnotation.getStereotypeModel().get(0))) {
            globalElement.setExtendsElement("http://www.mulesoft.org/schema/mule/core/abstract-object-store");
        }
    }
}

