/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.declaration.type.annotation.DefaultImplementingTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.DisplayTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.tooling.client.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ExpressionSupport;
import org.mule.tooling.client.api.extension.model.ExternalLibraryModel;
import org.mule.tooling.client.api.extension.model.LayoutModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.metadata.MetadataKeyPartModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterRole;
import org.mule.tooling.client.api.extension.model.value.ValueProviderModel;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.editor.model.AbstractBaseEditorElement;
import org.mule.tooling.editor.model.Namespace;
import org.mule.tooling.editor.model.contribution.Nested;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.editor.model.element.BaseChildEditorElement;
import org.mule.tooling.editor.model.element.BaseFieldEditorElement;
import org.mule.tooling.editor.model.element.ClassNameEditor;
import org.mule.tooling.editor.model.element.ContentEditor;
import org.mule.tooling.editor.model.element.DWScript;
import org.mule.tooling.editor.model.element.EncodingEditor;
import org.mule.tooling.editor.model.element.EnumEditor;
import org.mule.tooling.editor.model.element.Group;
import org.mule.tooling.editor.model.element.NameEditor;
import org.mule.tooling.editor.model.element.StringEditor;
import org.mule.tooling.editor.model.element.component.TypeChooserComponent;
import org.mule.tooling.editor.model.element.library.Jar;
import org.mule.tooling.editor.model.element.library.RequiredLibraries;
import org.mule.tooling.extension.api.NameUtils;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.extension.api.generation.ValuePartContainer;
import org.mule.tooling.internal.extension.api.DefaultValuePopulator;
import org.mule.tooling.internal.extension.api.parameter.FieldDescriptor;
import org.mule.tooling.internal.extension.api.parameter.MuleStereotypes;
import org.mule.tooling.utils.ObjectHolder;

public class EditorGeneratorUtils {
    public static final String GENERAL_CAPTION = "General";
    public static final String ADVANCED_CAPTION = "Advanced";
    private static final String REQUIRED_DRIVER_MESSAGE = "Please add the required driver.";
    public static final String ICONS_SMALL_EXTENSION_PATTERN = "connector:/%s/%s.png";
    public static final String ICONS_LARGE_EXTENSION_PATTERN = "connector:/%s/%s.png";
    private static final Predicate<ConstructModel> isAppConfig = x -> MuleStereotypes.isAppConfig(x.getStereotype());

    private static <T> Predicate<T> not(Predicate<T> p) {
        return o -> !p.test(o);
    }

    private EditorGeneratorUtils() {
    }

    public static String getCaption(String name) {
        if (name.contains("-")) {
            return StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, name)), (char)' ').toLowerCase());
        }
        return StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)name), (char)' ').toLowerCase());
    }

    public static String getCaption(String name, Optional<DisplayModel> displayModel) {
        String generatedCaption = EditorGeneratorUtils.getCaption(name);
        return Optional.ofNullable(displayModel.map(DisplayModel::getDisplayName).orElse(generatedCaption)).orElse(generatedCaption);
    }

    public static String getQName(String baseURL, String localId) {
        return String.format("%s/%s", baseURL, localId);
    }

    public static String getQName(DslElementSyntax syntax) {
        return EditorGeneratorUtils.getQName(syntax.getNamespace(), syntax.getElementName());
    }

    public static void setIcons(String moduleId, AbstractBaseEditorElement abstractBaseEditorElement, Namespace namespace) {
        block31: {
            block32: {
                block30: {
                    if (!"http".equals(namespace.getPrefix())) break block30;
                    List<String> httpElementIds = Arrays.asList("listener", "listener-config", "basic-security-filter", "load-static-resource");
                    if (httpElementIds.contains(abstractBaseEditorElement.getLocalId())) {
                        abstractBaseEditorElement.setIcon("images:/palette/http-listener.png");
                        abstractBaseEditorElement.setImage("images:/canvas/http-listener.png");
                    } else {
                        abstractBaseEditorElement.setIcon(EditorGeneratorUtils.getSmallIconPath(moduleId, namespace));
                        abstractBaseEditorElement.setImage(EditorGeneratorUtils.getLargeIconPath(moduleId, namespace));
                    }
                    break block31;
                }
                if (!"munit-tools".equals(namespace.getPrefix())) break block32;
                switch (abstractBaseEditorElement.getLocalId()) {
                    case "assert-that": {
                        abstractBaseEditorElement.setIcon("images:/palette/munit-assert-that.png");
                        abstractBaseEditorElement.setImage("images:/canvas/munit-assert-that.png");
                        break;
                    }
                    case "assert": {
                        abstractBaseEditorElement.setIcon("images:/palette/munit-assert-dw-expression.png");
                        abstractBaseEditorElement.setImage("images:/canvas/munit-assert-dw-expression.png");
                        break;
                    }
                    case "fail": {
                        abstractBaseEditorElement.setIcon("images:/palette/munit-fail.png");
                        abstractBaseEditorElement.setImage("images:/canvas/munit-fail.png");
                        break;
                    }
                    case "run-custom": {
                        abstractBaseEditorElement.setIcon("images:/palette/munit-assert-custom.png");
                        abstractBaseEditorElement.setImage("images:/canvas/munit-assert-custom.png");
                        break;
                    }
                    case "mock-when": {
                        abstractBaseEditorElement.setIcon("images:/palette/munit-mock.png");
                        abstractBaseEditorElement.setImage("images:/canvas/munit-mock.png");
                        break;
                    }
                    case "verify-call": {
                        abstractBaseEditorElement.setIcon("images:/palette/munit-verify-call.png");
                        abstractBaseEditorElement.setImage("images:/canvas/munit-verify-call.png");
                        break;
                    }
                    case "spy": {
                        abstractBaseEditorElement.setIcon("images:/palette/munit-spy.png");
                        break;
                    }
                    case "assert-equals": {
                        abstractBaseEditorElement.setIcon("images:/palette/munit-assert-equal.png");
                        abstractBaseEditorElement.setImage("images:/canvas/munit-assert-equal.png");
                        break;
                    }
                    default: {
                        abstractBaseEditorElement.setIcon("images:/palette/module-munit-tools.png");
                        abstractBaseEditorElement.setImage(EditorGeneratorUtils.getLargeIconPath(moduleId, namespace));
                        break;
                    }
                }
                break block31;
            }
            abstractBaseEditorElement.setIcon(EditorGeneratorUtils.getSmallIconPath(moduleId, namespace));
            abstractBaseEditorElement.setImage(EditorGeneratorUtils.getLargeIconPath(moduleId, namespace));
        }
    }

    public static String getSmallIconPath(String moduleId, Namespace namespace) {
        switch (namespace.getPrefix()) {
            case "salesforce": {
                return "images:/palette/salesforce.png";
            }
            case "db": {
                return "images:/palette/database.png";
            }
            case "java": {
                return "images:/palette/java.png";
            }
            case "apikit": {
                return "images:/palette/apikit.png";
            }
        }
        return String.format("connector:/%s/%s.png", moduleId, "palette-icon");
    }

    public static String getLargeIconPath(String moduleId, Namespace namespace) {
        switch (namespace.getPrefix()) {
            case "salesforce": {
                return "images:/canvas/salesforce.png";
            }
            case "java": {
                return "images:/canvas/java.png";
            }
            case "db": {
                return "images:/canvas/database.png";
            }
            case "jira": {
                return "images:/canvas/jira.png";
            }
            case "workday": {
                return "images:/canvas/workday.png";
            }
            case "netsuite": {
                return "images:/canvas/netsuite.png";
            }
            case "servicenow": {
                return "images:/canvas/servicenow.png";
            }
        }
        return String.format("connector:/%s/%s.png", moduleId, "canvas-icon");
    }

    public static String getAbstractOperationParentValue(Namespace namespace) {
        return String.format("abstract%sGeneric", StringUtils.capitalize((String)namespace.getPrefix()));
    }

    public static String getAbstractSourceParentValue(Namespace namespace) {
        return String.format("abstract%sSourceGeneric", StringUtils.capitalize((String)namespace.getPrefix()));
    }

    public static String getTypeId(MetadataType metadataType) {
        StringBuilder builder = new StringBuilder();
        EditorGeneratorUtils.doGetTypeId(metadataType, builder);
        return builder.toString();
    }

    private static void doGetTypeId(MetadataType metadataType, final StringBuilder builder) {
        final Optional typeIdAnnotation = metadataType.getAnnotation(TypeIdAnnotation.class);
        if (typeIdAnnotation.isPresent()) {
            metadataType.accept(new MetadataTypeVisitor(){

                public void defaultVisit(MetadataType metadataType) {
                    TypeIdAnnotation typeId = (TypeIdAnnotation)typeIdAnnotation.get();
                    if (typeId != null) {
                        builder.append(typeId.getValue());
                    }
                }

                public void visitArrayType(ArrayType arrayType) {
                    TypeIdAnnotation typeId = (TypeIdAnnotation)typeIdAnnotation.get();
                    if (typeId != null) {
                        builder.append(typeId.getValue());
                        builder.append("<");
                        EditorGeneratorUtils.doGetTypeId(arrayType.getType(), builder);
                        builder.append(">");
                    }
                }

                public void visitObject(ObjectType objectType) {
                    if (objectType.isOpen()) {
                        TypeIdAnnotation typeId = (TypeIdAnnotation)typeIdAnnotation.get();
                        if (typeId != null) {
                            builder.append(typeId.getValue());
                            builder.append("<");
                            EditorGeneratorUtils.doGetTypeId((MetadataType)BaseTypeBuilder.create((MetadataFormat)objectType.getMetadataFormat()).stringType().id(String.class.getName()).build(), builder);
                            builder.append(",");
                            EditorGeneratorUtils.doGetTypeId((MetadataType)objectType.getOpenRestriction().get(), builder);
                            builder.append(">");
                        }
                    } else {
                        TypeIdAnnotation typeId = (TypeIdAnnotation)typeIdAnnotation.get();
                        if (typeId != null) {
                            builder.append(typeId.getValue());
                        }
                    }
                }
            });
        } else {
            Optional classInfo = metadataType.getAnnotation(ClassInformationAnnotation.class);
            if (classInfo.isPresent()) {
                builder.append(((ClassInformationAnnotation)classInfo.get()).getClassname());
            }
        }
    }

    public static boolean isEnum(MetadataType metadataType) {
        return metadataType.getAnnotation(EnumAnnotation.class).isPresent();
    }

    public static boolean isContentMetadataParameter(String name) {
        return "outputEncoding".equals(name) || "outputMimeType".equals(name);
    }

    public static boolean isTargetMetadataParameter(String name) {
        return "target".equals(name) || "targetValue".equals(name);
    }

    public static AttributeCategory getOrCreateTab(List<BaseChildEditorElement> parents, String tabName) {
        AttributeCategory category = null;
        for (BaseChildEditorElement parent : parents) {
            if (!(parent instanceof AttributeCategory) || !parent.getCaption().equals(tabName)) continue;
            category = (AttributeCategory)parent;
            break;
        }
        if (category == null) {
            category = new AttributeCategory();
            category.setCaption(tabName);
            parents.add((BaseChildEditorElement)category);
        }
        return category;
    }

    public static Group getOrCreateGroup(String groupName, List<BaseChildEditorElement> container) {
        Group group = null;
        if (StringUtils.isNotBlank((String)groupName)) {
            for (BaseChildEditorElement child : container) {
                if (!(child instanceof Group) || !groupName.equals(child.getCaption())) continue;
                group = (Group)child;
                break;
            }
            if (group == null) {
                group = EditorGeneratorUtils.createGroupWith(NameUtils.hyphenize(groupName).replace(" ", ""), groupName);
                container.add((BaseChildEditorElement)group);
            }
        }
        return group;
    }

    public static Group createGeneralGroup() {
        return EditorGeneratorUtils.createGroupWith(GENERAL_CAPTION.toLowerCase(), GENERAL_CAPTION);
    }

    public static Group createGroupWith(String caption) {
        return EditorGeneratorUtils.createGroupWith(null, caption);
    }

    public static Group createGroupWith(String id, String caption) {
        Group generalGroup = new Group();
        generalGroup.setId(id);
        generalGroup.setCaption(caption);
        return generalGroup;
    }

    public static boolean areAllFieldsSimple(ObjectType type) {
        final ObjectHolder areAllSimple = new ObjectHolder();
        areAllSimple.set((Object)true);
        for (ObjectFieldType objectFieldType : type.getFields()) {
            objectFieldType.getValue().accept(new MetadataTypeVisitor(){

                protected void defaultVisit(MetadataType metadataType) {
                    areAllSimple.set((Object)false);
                }

                public void visitSimpleType(SimpleType simpleType) {
                }

                public void visitBoolean(BooleanType booleanType) {
                }

                public void visitDateTime(DateTimeType dateTimeType) {
                }

                public void visitDate(DateType dateType) {
                }

                public void visitNumber(NumberType numberType) {
                }

                public void visitString(StringType stringType) {
                }

                public void visitTime(TimeType timeType) {
                }
            });
        }
        return (Boolean)areAllSimple.get();
    }

    public static void sortElementsByCaption(List<BaseChildEditorElement> elements) {
        Collections.sort(elements, (x, y) -> {
            String caption = x.getCaption();
            String caption2 = y.getCaption();
            if (caption != null && caption2 == null) {
                return 1;
            }
            if (caption2 != null && caption == null) {
                return -1;
            }
            if (caption == null && caption2 == null) {
                return 0;
            }
            if (GENERAL_CAPTION.equals(caption)) {
                return -1;
            }
            if (ADVANCED_CAPTION.equals(caption)) {
                return 1;
            }
            if (GENERAL_CAPTION.equals(caption2)) {
                return 1;
            }
            if (ADVANCED_CAPTION.equals(caption2)) {
                return -1;
            }
            return caption.compareTo(caption2);
        });
    }

    public static void configureExternalLibraries(Set<ExternalLibraryModel> externalLibraryModels, Supplier<AttributeCategory> attributeCategoryProvider) {
        if (!externalLibraryModels.isEmpty()) {
            AttributeCategory attributeCategory = attributeCategoryProvider.get();
            RequiredLibraries requirement = new RequiredLibraries();
            EditorGeneratorUtils.addLibrary(externalLibraryModels, requirement);
            if (!requirement.getLibraries().isEmpty()) {
                Group generalGroup = EditorGeneratorUtils.getOrCreateGroup("Required Libraries", attributeCategory.getChildElements());
                generalGroup.getChildElements().add(requirement);
            }
        }
    }

    protected static void addLibrary(Set<ExternalLibraryModel> externalLibraryModels, RequiredLibraries requirement) {
        List libraries = requirement.getLibraries();
        externalLibraryModels.stream().map(EditorGeneratorUtils::toLibDependency).forEach(libraries::add);
    }

    protected static Jar toLibDependency(ExternalLibraryModel externalLibraryModel) {
        Jar jar = new Jar();
        jar.setEmptyLocationLabel(REQUIRED_DRIVER_MESSAGE);
        jar.setName(externalLibraryModel.getName());
        if (externalLibraryModel.isOptional()) {
            jar.setRequired(Boolean.valueOf(false));
        }
        externalLibraryModel.getSuggestedCoordinates().ifPresent(arg_0 -> ((Jar)jar).setSuggestedCoordinates(arg_0));
        EditorGeneratorUtils.configureClassMatcherIfRequired(externalLibraryModel, jar);
        if (!externalLibraryModel.getRequiredClassName().isPresent()) {
            EditorGeneratorUtils.configureFileMatcherIfRequired(externalLibraryModel, jar);
        }
        return jar;
    }

    public static void configureClassMatcherIfRequired(ExternalLibraryModel externalLibraryModel, Jar jar) {
        Optional requiredClassName = externalLibraryModel.getRequiredClassName();
        if (requiredClassName.isPresent()) {
            jar.setClassName((String)requiredClassName.get());
        }
    }

    public static void configureFileMatcherIfRequired(ExternalLibraryModel externalLibraryModel, Jar jar) {
        Optional requiredFileName = externalLibraryModel.getRegexMatcher();
        if (requiredFileName.isPresent()) {
            jar.setFileName((String)requiredFileName.get());
        } else {
            Optional suggestedCoordinates = externalLibraryModel.getSuggestedCoordinates();
            if (suggestedCoordinates.isPresent()) {
                String gav = (String)suggestedCoordinates.get();
                MavenDependency pluginDependency = MavenUtils.getPluginDependency((String)gav);
                jar.setFileName(String.format("%s-.*.jar", pluginDependency.getArtifactId()));
            }
        }
    }

    public static boolean isRedeliveryPolicy(DslElementSyntax dslElementSyntax) {
        return "redelivery-policy".equals(dslElementSyntax.getElementName()) || "abstract-redelivery-policy".equals(dslElementSyntax.getElementName()) && EditorGeneratorUtils.hasCoreNamespace(dslElementSyntax);
    }

    public static boolean isReconectionElement(DslElementSyntax dslElementSyntax) {
        return "reconnection".equals(dslElementSyntax.getElementName()) && EditorGeneratorUtils.hasCoreNamespace(dslElementSyntax);
    }

    public static boolean isExpirationPolicyElement(DslElementSyntax dslElementSyntax) {
        return "expiration-policy".equals(dslElementSyntax.getElementName()) && EditorGeneratorUtils.hasCoreNamespace(dslElementSyntax);
    }

    private static boolean hasCoreNamespace(DslElementSyntax elementName) {
        return "http://www.mulesoft.org/schema/mule/core".equals(elementName.getNamespace());
    }

    public static void removeGeneralLabelsFromGroupsInsideTabs(AbstractBaseEditorElement nested) {
        nested.getChildElements().stream().filter(x -> x instanceof AttributeCategory).map(y -> (AttributeCategory)y).forEach(category -> {
            String categorName = category.getCaption();
            category.getChildElements().stream().filter(w -> w instanceof Group).forEach(group -> {
                if (GENERAL_CAPTION.equals(group.getCaption()) || categorName.equals(group.getCaption())) {
                    group.setCaption(null);
                }
            });
        });
    }

    public static void setCommonValues(String moduleId, AbstractBaseEditorElement element, ComponentModel model, Context ctx, DslElementSyntax syntax) {
        EditorGeneratorUtils.doSetCommonAttributes(moduleId, element, ctx, syntax, model.getName(), model.getDisplayModel(), model.getDescription());
    }

    public static void setCommonValues(String moduleId, AbstractBaseEditorElement element, ConnectionProviderModel model, Context ctx, DslElementSyntax syntax) {
        EditorGeneratorUtils.doSetCommonAttributes(moduleId, element, ctx, syntax, model.getName(), model.getDisplayModel(), model.getDescription());
    }

    public static void setCommonValues(String moduleId, AbstractBaseEditorElement element, ConfigurationModel model, Context ctx, DslElementSyntax syntax) {
        EditorGeneratorUtils.doSetCommonAttributes(moduleId, element, ctx, syntax, model.getName(), model.getDisplayModel(), model.getDescription());
    }

    private static void doSetCommonAttributes(String moduleId, AbstractBaseEditorElement element, Context ctx, DslElementSyntax syntax, String name, Optional<DisplayModel> display, String desc) {
        String caption = EditorGeneratorUtils.getCaption(name, display);
        String description = display.map(DisplayModel::getSummary).orElse(desc);
        element.setCaption(caption);
        element.setVersions("[4.0,10.0]");
        element.setLocalId(syntax.getElementName());
        EditorGeneratorUtils.setIcons(moduleId, element, ctx.getNamespace());
        element.setDescription(description);
    }

    public static AttributeCategory createGeneralTab() {
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(GENERAL_CAPTION);
        attributeCategory.setDescription("Configuration Properties");
        return attributeCategory;
    }

    public static boolean supportsExpression(ExpressionSupport expressionSupport) {
        return expressionSupport.isSupported() || expressionSupport.isRequired();
    }

    public static FieldDescriptor from(ParameterModel parameterModel, String groupName, String canonicalPath, Context context, int xmlOrder, DslElementSyntax parameterSyntax) {
        FieldDescriptor.FieldDescriptorBuilder builder = FieldDescriptor.builder();
        ExpressionSupport expressionSupport = parameterModel.getExpressionSupport();
        builder.withMetadataType(parameterModel.getType());
        String description = parameterModel.getDisplayModel().map(DisplayModel::getSummary).orElse(parameterModel.getDescription());
        builder.withDescription(description);
        builder.withRequired(parameterModel.isRequired());
        builder.withSupportsExpression(EditorGeneratorUtils.supportsExpression(expressionSupport));
        builder.withRequiresExpression(expressionSupport.isRequired());
        builder.withDefaultValue(parameterModel.getDefaultValue() != null ? parameterModel.getDefaultValue().toString() : null);
        builder.withSyntax(parameterSyntax);
        builder.withAllowesReferences(parameterModel.getDslConfiguration().allowsReferences());
        builder.withId(parameterModel.getName());
        String caption = parameterModel.getDisplayModel().map(DisplayModel::getDisplayName).orElse(EditorGeneratorUtils.getCaption(parameterModel.getName()));
        builder.withCaption(caption);
        String example = parameterModel.getDisplayModel().map(DisplayModel::getExample).orElse(null);
        builder.withExample(example);
        builder.withGroupContainerName(groupName);
        builder.withTabContainerName(EditorGeneratorUtils.getTabName(parameterModel));
        Consumer<Object> mapPropertiesPopulator = x -> {
            FieldDescriptor.FieldDescriptorBuilder fieldDescriptorBuilder2 = builder.withModelProperty(x.getClass(), x);
        };
        parameterModel.getInfrastructureParameterModel().ifPresent(mapPropertiesPopulator::accept);
        parameterModel.getMetadataKeyPartModel().ifPresent(mapPropertiesPopulator::accept);
        parameterModel.getDisplayModel().ifPresent(x -> {
            mapPropertiesPopulator.accept(x);
            x.getPathModel().ifPresent(builder::withPathModel);
            x.getClassValueModel().ifEnabled(classValueModel -> classValueModel.ifPresent(builder::withClassValueModel));
        });
        parameterModel.getLayoutModel().ifPresent(x -> {
            mapPropertiesPopulator.accept(x);
            builder.withPassword(x.isPassword());
            builder.withText(x.isText());
        });
        parameterModel.getDefaultImplementingTypeModel().ifPresent(x -> {
            FieldDescriptor.FieldDescriptorBuilder fieldDescriptorBuilder2 = builder.withDefaultType(x.value());
        });
        parameterModel.getValueProviderModel().ifPresent(builder::withValueProviderModel);
        builder.withModelProperty(ParameterRole.class, parameterModel.getRole());
        builder.withXmlOrder(xmlOrder);
        builder.withCanonicalPath(canonicalPath);
        return builder.build();
    }

    public static FieldDescriptor from(ObjectFieldType objectFieldType, DslElementSyntax syntax, int xmlOrder) {
        FieldDescriptor.FieldDescriptorBuilder builder = FieldDescriptor.builder();
        builder.withMetadataType(objectFieldType.getValue());
        String description = objectFieldType.getKey().getDescription().orElse(null);
        builder.withDescription(description);
        builder.withRequired(objectFieldType.isRequired());
        Optional dslAnnotation = objectFieldType.getAnnotation(ParameterDslAnnotation.class);
        dslAnnotation.ifPresent(x -> {
            FieldDescriptor.FieldDescriptorBuilder fieldDescriptorBuilder2 = builder.withAllowesReferences(x.allowsReferences());
        });
        Optional supportAnnotation = objectFieldType.getAnnotation(ExpressionSupportAnnotation.class);
        ExpressionSupport expressionSupport = supportAnnotation.map(ExpressionSupportAnnotation::getExpressionSupport).orElse(ExpressionSupport.supportedExpressionSupport((String)org.mule.runtime.api.meta.ExpressionSupport.SUPPORTED.name()));
        builder.withSupportsExpression(EditorGeneratorUtils.supportsExpression(expressionSupport));
        builder.withRequiresExpression(expressionSupport.isRequired());
        Optional defaultAnnotation = objectFieldType.getAnnotation(DefaultValueAnnotation.class);
        if (defaultAnnotation.isPresent()) {
            builder.withDefaultValue(((DefaultValueAnnotation)defaultAnnotation.get()).getValue());
        }
        Optional layoutTypeAnnotation = objectFieldType.getAnnotation(LayoutTypeAnnotation.class);
        HashMap<Class<DisplayTypeAnnotation>, DisplayTypeAnnotation> modelProperties = new HashMap<Class<DisplayTypeAnnotation>, DisplayTypeAnnotation>();
        if (layoutTypeAnnotation.isPresent()) {
            LayoutTypeAnnotation layout = (LayoutTypeAnnotation)layoutTypeAnnotation.get();
            builder.withTabContainerName(layout.getTabName().orElse(GENERAL_CAPTION));
            builder.withPassword(layout.isPassword());
            builder.withText(layout.isText());
        }
        builder.withSyntax(syntax);
        QName fieldQName = objectFieldType.getKey().getName();
        String fieldName = fieldQName.getLocalPart();
        builder.withId(fieldName);
        Optional displayTypeAnnotation = objectFieldType.getAnnotation(DisplayTypeAnnotation.class);
        if (displayTypeAnnotation.isPresent()) {
            DisplayTypeAnnotation displayType = (DisplayTypeAnnotation)displayTypeAnnotation.get();
            modelProperties.put(DisplayTypeAnnotation.class, displayType);
            builder.withDescription(displayType.getSummary());
            String displayName = displayType.getDisplayName();
            if (StringUtils.isBlank((String)displayName)) {
                displayName = EditorGeneratorUtils.getCaption(fieldName);
            }
            builder.withExample(displayType.getExample());
            builder.withCaption(displayName);
            displayType.getPathModel().ifPresent(builder::withPathModel);
            displayType.getClassValueModel().ifEnabled(classValueModel -> classValueModel.ifPresent(builder::withClassValueModel));
        } else {
            builder.withCaption(EditorGeneratorUtils.getCaption(fieldName));
        }
        Optional defaultImplementingTypeAnnotation = objectFieldType.getAnnotation(DefaultImplementingTypeAnnotation.class);
        defaultImplementingTypeAnnotation.ifPresent(x -> {
            FieldDescriptor.FieldDescriptorBuilder fieldDescriptorBuilder2 = builder.withDefaultType(x.getDefaultType());
        });
        Consumer<Object> mapPropertiesPopulator = x -> {
            FieldDescriptor.FieldDescriptorBuilder fieldDescriptorBuilder2 = builder.withModelProperty(x.getClass(), x);
        };
        objectFieldType.getAnnotations().stream().forEachOrdered(mapPropertiesPopulator);
        builder.withXmlOrder(xmlOrder);
        return builder.build();
    }

    private static String getTabName(ParameterModel parameterModel) {
        return parameterModel.getLayoutModel().map(prop -> prop.getTabName().orElse(GENERAL_CAPTION)).orElse(GENERAL_CAPTION);
    }

    public static BaseChildEditorElement createMuleExpressionLanguageEditor(FieldDescriptor fieldDescriptor) {
        StringEditor editor = new StringEditor();
        EditorGeneratorUtils.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        editor.setSingeLineForExpressions(Boolean.valueOf(true));
        editor.setValuePersistence("expression");
        editor.setCustomValidator("org.mule.tooling.ui.modules.core.widgets.meta.EmptyExpressionCheckValidator");
        fieldDescriptor.getDefaultValue().ifPresent(arg_0 -> ((StringEditor)editor).setDefaultValue(arg_0));
        return editor;
    }

    public static boolean needsMetadataKeyTypeChooser(FieldDescriptor fieldDescriptor) {
        Optional<MetadataKeyPartModel> modelProperty = fieldDescriptor.getModelProperty(MetadataKeyPartModel.class);
        return modelProperty.isPresent() && modelProperty.map(MetadataKeyPartModel::isProvidedByKeyResolver).orElse(false) != false && !EditorGeneratorUtils.hasTextProperty(fieldDescriptor);
    }

    private static boolean hasTextProperty(FieldDescriptor fieldDescriptor) {
        Optional modelProperty = fieldDescriptor.getModelProperty(LayoutModel.class);
        if (modelProperty.isPresent()) {
            LayoutModel layoutModelProperty = (LayoutModel)modelProperty.get();
            return layoutModelProperty.isText();
        }
        Optional layoutTypeAnnotation = fieldDescriptor.getModelProperty(LayoutTypeAnnotation.class);
        if (layoutTypeAnnotation.isPresent()) {
            LayoutTypeAnnotation layoutModelProperty = (LayoutTypeAnnotation)layoutTypeAnnotation.get();
            return layoutModelProperty.isText();
        }
        return false;
    }

    public static void configureTypeChooserCapability(TypeChooserComponent typeChooser, FieldDescriptor fieldDescriptor, ValuePartContainer metadataKeyPartContainer, boolean hasConfig) {
        MetadataKeyPartModel keyPart = (MetadataKeyPartModel)fieldDescriptor.getModelProperty(MetadataKeyPartModel.class).orElseThrow(() -> new IllegalStateException("Cannot call this method with a FieldDescriptor that doesn't have a MetadataKeyPartModel"));
        String collect = metadataKeyPartContainer.getPreviousParameters(keyPart.getOrder()).stream().collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((String)collect)) {
            typeChooser.setKeyParts(collect);
        }
        if (hasConfig) {
            typeChooser.setPrerequisites("config-ref");
        }
    }

    public static BaseChildEditorElement createMetadataTypeChooser(FieldDescriptor fieldDescriptor, ValuePartContainer metadataKeyPartContainer, Context context) {
        boolean operationHasConfig = context.isProcessingConfiglessElement();
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        String name = StringUtils.isEmpty((String)syntax.getAttributeName()) ? syntax.getElementName() : syntax.getAttributeName();
        MetadataKeyPartModel keyPart = (MetadataKeyPartModel)fieldDescriptor.getModelProperty(MetadataKeyPartModel.class).orElseThrow(RuntimeException::new);
        String recalcWhen = metadataKeyPartContainer.getPreviousParameterName(keyPart.getOrder()).orElse(operationHasConfig ? "config-ref" : "");
        EnumEditor editor = new EnumEditor();
        editor.setAllowsCustom(Boolean.valueOf(true));
        editor.setIsTypeChooser(Boolean.valueOf(true));
        editor.setDisableButton(Boolean.valueOf(false));
        if (StringUtils.isNotEmpty((String)recalcWhen)) {
            editor.setRecalcWhen(recalcWhen);
        }
        editor.setSupportsExpressions(Boolean.valueOf(fieldDescriptor.isSupportsExpression()));
        editor.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
        editor.setDefaultValue((String)fieldDescriptor.getDefaultValue().orElse(null));
        if (keyPart.getOrder() == 1) {
            editor.setButtonTooltip("Forces a refresh of the types list for this connector (requires DataSense enabled in the Connector configuration/Config reference)");
            editor.setButtonClass("org.mule.tooling.ui.modules.core.widgets.editors.RefreshTypesAction");
            editor.setButtonImage("/icons/refresh_types.gif");
            editor.setButtonEnablementClass("org.mule.tooling.ui.modules.core.widgets.editors.RefreshTypesButtonEnablement");
            editor.setClassAttribute("org.mule.tooling.ui.modules.core.widgets.editors.MetadataTypesCalculator");
        } else {
            editor.setKeyParts(metadataKeyPartContainer.getPreviousParameters(keyPart.getOrder()).stream().collect(Collectors.joining(",")));
            editor.setClassAttribute("org.mule.tooling.ui.modules.core.widgets.editors.MultiLevelMetadataTypesCalculator");
        }
        if (!operationHasConfig) {
            editor.setButtonTooltip("Forces a refresh of the types list for this connector (requires DataSense enabled in the Connector configuration/Config reference)");
            editor.setButtonClass("org.mule.tooling.ui.modules.core.widgets.editors.ConfiglessRefreshTypesAction");
            editor.setButtonImage("/icons/refresh_types.gif");
            editor.setButtonEnablementClass("org.mule.tooling.ui.modules.core.widgets.editors.ConfiglessRefreshTypesButtonEnablement");
            editor.setClassAttribute("org.mule.tooling.ui.modules.core.widgets.editors.ConfiglessMetadataTypesCalculator");
        }
        editor.setName(name);
        EditorGeneratorUtils.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        return editor;
    }

    private static void setCommonAttributes(BaseFieldEditorElement editor, FieldDescriptor fieldDescriptor) {
        editor.setCaption(fieldDescriptor.getCaption());
        editor.setName(fieldDescriptor.getId());
        editor.setDescription(fieldDescriptor.getDescription());
        editor.setSupportsExpressions(Boolean.valueOf(fieldDescriptor.isSupportsExpression()));
        editor.setRequiresExpression(Boolean.valueOf(fieldDescriptor.isRequiresExpression()));
        editor.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
        editor.setCanonicalPath(fieldDescriptor.getCanonicalPath());
        Optional<DisplayModel> display = fieldDescriptor.getModelProperty(DisplayModel.class);
        String placeholder = display.map(DisplayModel::getExample).orElse("");
        if (StringUtils.isNotEmpty((String)placeholder)) {
            editor.setPlaceholder(placeholder);
        }
        DefaultValuePopulator.populate(editor, fieldDescriptor.getDefaultValue().orElse(null));
    }

    public static Nested createNestedWithId(String localId) {
        Nested nested = new Nested();
        nested.setLocalId(localId);
        nested.setXmlname(localId);
        nested.setCaption(EditorGeneratorUtils.getCaption(localId));
        return nested;
    }

    public static BaseChildEditorElement createDataWeaveScriptFieldEditor(FieldDescriptor fieldDescriptor, Context context) {
        DWScript editor;
        if (EditorGeneratorUtils.needsSimpleMapPlaceholder(fieldDescriptor.getMetadataType())) {
            DWScript script = new DWScript();
            script.setIsToElement(Boolean.valueOf(true));
            EditorGeneratorUtils.setCommonAttributes((BaseFieldEditorElement)script, fieldDescriptor);
            script.setName(fieldDescriptor.getSyntax().getElementName());
            script.setNestedName(fieldDescriptor.getSyntax().getElementName());
            script.setDefaultValue((String)fieldDescriptor.getDefaultValue().orElse(null));
            script.setWrapWithCDATA(Boolean.valueOf(true));
            script.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
            editor = script;
        } else {
            ContentEditor contentEditor = new ContentEditor();
            EditorGeneratorUtils.setCommonAttributes((BaseFieldEditorElement)contentEditor, fieldDescriptor);
            contentEditor.setIsToElement(Boolean.valueOf(true));
            contentEditor.setXmlOrder(Integer.valueOf(fieldDescriptor.getXmlOrder()));
            contentEditor.setName(fieldDescriptor.getSyntax().getElementName());
            contentEditor.setNestedName(fieldDescriptor.getSyntax().getElementName());
            contentEditor.setDefaultValue((String)fieldDescriptor.getDefaultValue().orElse(null));
            contentEditor.setWrapWithCDATA(Boolean.valueOf(true));
            contentEditor.setSingeLineForExpressions(Boolean.valueOf(false));
            contentEditor.setIsTextArea(Boolean.valueOf(true));
            if (EditorGeneratorUtils.hasMetadataProperty(fieldDescriptor)) {
                contentEditor.setIsTypeChooser(Boolean.valueOf(true));
            }
            editor = contentEditor;
        }
        editor.setCaption(fieldDescriptor.getCaption());
        return editor;
    }

    private static boolean needsSimpleMapPlaceholder(MetadataType metadataType) {
        MetadataType valueType;
        Optional openRestriction;
        ObjectType type;
        return metadataType instanceof ObjectType && (type = (ObjectType)metadataType).isOpen() && (openRestriction = type.getOpenRestriction()).isPresent() && (valueType = (MetadataType)openRestriction.get()) instanceof StringType;
    }

    public static boolean needsLabel(FieldDescriptor fieldDescriptor) {
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        if (fieldDescriptor.isRequiresExpression() || EditorGeneratorUtils.isOpenType(fieldDescriptor.getMetadataType()) || EditorGeneratorUtils.hasNoFields(fieldDescriptor) || EditorGeneratorUtils.isArrayWithUndefinedType(fieldDescriptor)) {
            return false;
        }
        Integer editingModes = 0;
        if (!fieldDescriptor.isRequired()) {
            editingModes = editingModes + 1;
        }
        if (fieldDescriptor.isSupportsExpression()) {
            editingModes = editingModes + 1;
        }
        if (syntax.supportsChildDeclaration()) {
            editingModes = editingModes + 1;
        }
        if (syntax.supportsTopLevelDeclaration()) {
            editingModes = editingModes + 1;
        }
        return editingModes <= 1;
    }

    private static boolean hasNoFields(FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.getMetadataType() instanceof ObjectType && fieldDescriptor.getSyntax().getAttributes().isEmpty() && fieldDescriptor.getSyntax().getChilds().isEmpty();
    }

    private static boolean isArrayWithUndefinedType(FieldDescriptor fieldDescriptor) {
        Object metadataType = fieldDescriptor.getMetadataType();
        if (metadataType instanceof ArrayType) {
            ArrayType array = (ArrayType)metadataType;
            MetadataType innerType = array.getType();
            return !fieldDescriptor.getSyntax().getGeneric(innerType).isPresent();
        }
        return false;
    }

    private static boolean isOpenType(MetadataType metadataType) {
        if (metadataType instanceof ObjectType) {
            ObjectType obj = (ObjectType)metadataType;
            return obj.isOpen();
        }
        if (metadataType instanceof ArrayType) {
            ArrayType array = (ArrayType)metadataType;
            return EditorGeneratorUtils.isOpenType(array.getType());
        }
        return false;
    }

    public static EnumEditor createMimeTypeChooser(FieldDescriptor fieldDescriptor) {
        EnumEditor editor = new EnumEditor();
        EditorGeneratorUtils.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        editor.setCaption(null);
        editor.setCaptionIsUp(Boolean.valueOf(true));
        editor.setAllowsCustom(Boolean.valueOf(true));
        editor.setOptionsProvider("org.mule.tooling.ui.modules.core.widgets.meta.creators.MimeTypeOptionsProvider");
        return editor;
    }

    public static EncodingEditor createEncodingField(FieldDescriptor fieldDescriptor) {
        EncodingEditor editor = new EncodingEditor();
        EditorGeneratorUtils.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        editor.setCaption("Encoding");
        return editor;
    }

    public static NameEditor createNameEditorWithDescription(String description) {
        NameEditor name = new NameEditor();
        name.setCaption("Name");
        name.setName("name");
        name.setDescription(description);
        name.setRequired(Boolean.valueOf(true));
        return name;
    }

    public static Boolean hasAnyComponentWithMetadataKeyPart(ConfigurationModel configurationModel) {
        return Streams.concat((Stream[])new Stream[]{configurationModel.getOperationModels().stream().flatMap(x -> x.getParameterGroupModels().stream()), configurationModel.getSourceModels().stream().flatMap(x -> x.getParameterGroupModels().stream())}).flatMap(group -> group.getParameterModels().stream()).anyMatch(param -> param.getMetadataKeyPartModel().isPresent());
    }

    public static BaseChildEditorElement createValueProviderChooser(FieldDescriptor fieldDescriptor, ValuePartContainer metadataKeyPartContainer) {
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        EnumEditor editor = new EnumEditor();
        String name = StringUtils.isEmpty((String)syntax.getAttributeName()) ? syntax.getElementName() : syntax.getAttributeName();
        ValueProviderModel valueProviderModel = fieldDescriptor.getValueProviderModel().orElseThrow(RuntimeException::new);
        metadataKeyPartContainer.addKeyPart(valueProviderModel.getPartOrder(), name);
        String prerequisites = EditorGeneratorUtils.calculatePrerequisites(metadataKeyPartContainer, valueProviderModel);
        String recalcWhen = EditorGeneratorUtils.calculateRecalcWhen(metadataKeyPartContainer, valueProviderModel);
        editor.setButtonEnablementClass("org.mule.tooling.ui.modules.core.widgets.editors.RefreshTypesButtonEnabler");
        editor.setAllowsCustom(Boolean.valueOf(true));
        if (StringUtils.isNotBlank((String)prerequisites)) {
            editor.setPrerequisites(prerequisites);
        }
        if (StringUtils.isNotBlank((String)recalcWhen)) {
            editor.setRecalcWhen(recalcWhen);
        }
        editor.setDisableButton(Boolean.valueOf(false));
        editor.setSupportsExpressions(Boolean.valueOf(fieldDescriptor.isSupportsExpression()));
        editor.setRequired(Boolean.valueOf(fieldDescriptor.isRequired()));
        editor.setDefaultValue((String)fieldDescriptor.getDefaultValue().orElse(null));
        editor.setClassAttribute("org.mule.tooling.ui.modules.core.widgets.editors.ValueProviderCalculator");
        if (valueProviderModel.getPartOrder() == 1) {
            editor.setButtonTooltip("Forces a refresh of the values list for this operation");
            editor.setButtonClass("org.mule.tooling.ui.modules.core.widgets.editors.options.RefreshValuesAction");
            editor.setButtonImage("/icons/refresh_types.gif");
        } else {
            editor.setKeyParts(EditorGeneratorUtils.calculateKeyParts(metadataKeyPartContainer, valueProviderModel));
        }
        editor.setName(name);
        editor.setProviderName(valueProviderModel.getProviderName());
        EditorGeneratorUtils.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        return editor;
    }

    private static String calculateKeyParts(ValuePartContainer metadataKeyPartContainer, ValueProviderModel valueProviderModel) {
        ArrayList keyParts = new ArrayList();
        int keyPartIndex = 1;
        while (keyPartIndex < valueProviderModel.getPartOrder()) {
            Optional<String> previousParameterName = metadataKeyPartContainer.getParameterName(keyPartIndex);
            previousParameterName.ifPresent(keyParts::add);
            ++keyPartIndex;
        }
        return keyParts.stream().collect(Collectors.joining(","));
    }

    private static String calculatePrerequisites(ValuePartContainer metadataKeyPartContainer, ValueProviderModel valueProviderModel) {
        Object recalcWhen = valueProviderModel.getActingParameters().stream().collect(Collectors.joining(","));
        if (valueProviderModel.requiresConnection()) {
            String configRefAttributeName = "config-ref";
            recalcWhen = ((String)recalcWhen).length() == 0 ? configRefAttributeName : configRefAttributeName + "," + (String)recalcWhen;
        }
        if (valueProviderModel.getPartOrder() != 1) {
            String previousPart;
            int partOrder = valueProviderModel.getPartOrder();
            ArrayList<String> previousKeyparts = new ArrayList<String>(valueProviderModel.getPartOrder() - 1);
            while (partOrder > 1) {
                previousPart = metadataKeyPartContainer.getPreviousParameterName(partOrder).get();
                previousKeyparts.add(0, previousPart);
                --partOrder;
            }
            previousPart = previousKeyparts.stream().collect(Collectors.joining(","));
            recalcWhen = ((String)recalcWhen).length() == 0 ? previousPart : (String)recalcWhen + "," + previousPart;
        }
        return recalcWhen;
    }

    private static String calculateRecalcWhen(ValuePartContainer metadataKeyPartContainer, ValueProviderModel valueProviderModel) {
        Object recalcWhen = valueProviderModel.getActingParameters().stream().collect(Collectors.joining(","));
        if (valueProviderModel.requiresConnection()) {
            String configRefAttributeName = "config-ref";
            recalcWhen = ((String)recalcWhen).length() == 0 ? configRefAttributeName : configRefAttributeName + "," + (String)recalcWhen;
        }
        if (valueProviderModel.getPartOrder() != 1) {
            String previousPart = metadataKeyPartContainer.getPreviousParameterName(valueProviderModel.getPartOrder()).get();
            recalcWhen = previousPart;
        }
        return recalcWhen;
    }

    public static void removeEmptyTabs(AbstractBaseEditorElement editorElement) {
        editorElement.getChildElements().removeAll(editorElement.getChildElements().stream().filter(x -> x instanceof AttributeCategory).map(y -> (AttributeCategory)y).filter(x -> x.getChildElements().isEmpty()).collect(Collectors.toList()));
    }

    public static List<ConstructModel> getAppConfigConstructs(Collection<ConstructModel> models) {
        return models.stream().filter(isAppConfig).collect(Collectors.toList());
    }

    public static List<ConstructModel> getNotAppConfigConstructs(Collection<ConstructModel> models) {
        return models.stream().filter(EditorGeneratorUtils.not(isAppConfig)).collect(Collectors.toList());
    }

    public static boolean hasMetadataProperty(FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.getModelProperty(MetadataKeyPartModel.class).isPresent();
    }

    public static BaseFieldEditorElement createClassField(FieldDescriptor fieldDescriptor) {
        ClassNameEditor editor = new ClassNameEditor();
        EditorGeneratorUtils.setCommonAttributes((BaseFieldEditorElement)editor, fieldDescriptor);
        List assignableFrom = fieldDescriptor.getClassValueModel().get().getAssignableFrom();
        if (!assignableFrom.isEmpty()) {
            editor.setAssignableFrom((String)assignableFrom.get(0));
        }
        return editor;
    }

    public static boolean isClassValueField(FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.getClassValueModel().isPresent();
    }

    public static void registerKeyPartInContext(FieldDescriptor fieldDescriptor, Context context) {
        MetadataKeyPartModel keyPart = (MetadataKeyPartModel)fieldDescriptor.getModelProperty(MetadataKeyPartModel.class).orElseThrow(() -> new IllegalArgumentException());
        DslElementSyntax syntax = fieldDescriptor.getSyntax();
        String name = StringUtils.isEmpty((String)syntax.getAttributeName()) ? syntax.getElementName() : syntax.getAttributeName();
        context.getKeyPartContainer().addKeyPart(keyPart.getOrder(), name);
    }

    public static boolean isReservedParameterName(String name, boolean isGlobalElement) {
        return isGlobalElement ? "config-ref".equals(name) || "name".equals(name) : "config-ref".equals(name);
    }
}

