/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.editor.model.EditorElementVisitorAdapter;
import org.mule.tooling.editor.model.IEditorElementVisitor;
import org.mule.tooling.editor.model.element.BaseFieldEditorElement;
import org.mule.tooling.editor.model.element.BooleanEditor;
import org.mule.tooling.editor.model.element.EnumEditor;
import org.mule.tooling.editor.model.element.FileEditor;
import org.mule.tooling.editor.model.element.IntegerEditor;
import org.mule.tooling.editor.model.element.LongEditor;
import org.mule.tooling.editor.model.element.NameEditor;
import org.mule.tooling.editor.model.element.PathEditor;
import org.mule.tooling.editor.model.element.StringEditor;
import org.mule.tooling.editor.model.element.UrlEditor;

public class DefaultValuePopulator {
    public static void populate(BaseFieldEditorElement editor, final String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            editor.accept((IEditorElementVisitor)new EditorElementVisitorAdapter(){

                public void visit(BooleanEditor booleanEditor) {
                    booleanEditor.setDefaultValue(Boolean.valueOf(value));
                }

                public void visit(EnumEditor enumEditor) {
                    enumEditor.setDefaultValue(value);
                }

                public void visit(FileEditor fileEditor) {
                    fileEditor.setDefaultValue(value);
                }

                public void visit(IntegerEditor integerEditor) {
                    try {
                        integerEditor.setDefaultValue(Integer.valueOf(value));
                    }
                    catch (Exception exception) {}
                }

                public void visit(LongEditor longEditor) {
                    longEditor.setDefaultValue(Long.valueOf(value));
                }

                public void visit(NameEditor nameEditor) {
                    nameEditor.setDefaultValue(value);
                }

                public void visit(PathEditor pathEditor) {
                    pathEditor.setDefaultValue(value);
                }

                public void visit(StringEditor stringEditor) {
                    stringEditor.setDefaultValue(value);
                }

                public void visit(UrlEditor urlEditor) {
                    urlEditor.setDefaultValue(value);
                }
            });
        }
    }
}

