/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal.extension.api;

import java.util.List;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.nested.NestedRouteModel;
import org.mule.tooling.editor.model.EditorElementVisitorAdapter;
import org.mule.tooling.editor.model.IEditorElementVisitor;
import org.mule.tooling.editor.model.contribution.AbstractContributionEditorElement;
import org.mule.tooling.editor.model.contribution.Container;
import org.mule.tooling.editor.model.contribution.Splitter;
import org.mule.tooling.editor.model.element.AttributeCategory;
import org.mule.tooling.extension.api.generation.Context;
import org.mule.tooling.internal.extension.api.AbstractComponentModelProcessorTemplate;
import org.mule.tooling.internal.extension.api.EditorGeneratorUtils;
import org.mule.tooling.internal.extension.api.NestableContainerItemProcessor;
import org.mule.tooling.internal.extension.api.NestableElementModelVisitorAdapter;
import org.mule.tooling.internal.extension.api.NestableSplitterItemProcessor;
import org.mule.tooling.internal.extension.api.XmlOrderSupplier;
import org.mule.tooling.utils.ObjectHolder;

public class ConstructsItemProcessor
extends AbstractComponentModelProcessorTemplate<ConstructModel, AbstractContributionEditorElement> {
    private NestableContainerItemProcessor containerDelegate = new NestableContainerItemProcessor();
    private NestableSplitterItemProcessor splitterDelegate = new NestableSplitterItemProcessor();

    @Override
    protected List<ConstructModel> getModelRootElements(ExtensionModel extensionModel) {
        return EditorGeneratorUtils.getNotAppConfigConstructs(extensionModel.getConstructModels());
    }

    @Override
    protected DslElementSyntax resolveDslElementSyntax(DslSyntaxResolver resolver, ConstructModel componentModel) {
        return resolver.resolve(componentModel);
    }

    @Override
    protected AbstractContributionEditorElement createEditorModel(ConstructModel componentModel) {
        if (this.hasRouteComponents(componentModel.getNestedComponents())) {
            return this.splitterDelegate.createEditorModel((ComponentModel)componentModel);
        }
        return this.containerDelegate.createEditorModel((ComponentModel)componentModel);
    }

    private boolean hasRouteComponents(List<? extends NestableElementModel> nestableComponents) {
        final ObjectHolder hasRoutes = new ObjectHolder((Object)false);
        NestableElementModelVisitorAdapter visitor = new NestableElementModelVisitorAdapter(){

            @Override
            public void visit(NestedRouteModel route) {
                hasRoutes.set((Object)true);
            }
        };
        nestableComponents.forEach(nested -> nested.accept(visitor));
        return (Boolean)hasRoutes.get();
    }

    @Override
    protected void doProcess(AbstractContributionEditorElement editorElement, AttributeCategory attributeCategory, ConstructModel componentModel, Context context, DslElementSyntax dslElementSyntax) {
        if (editorElement instanceof Container) {
            this.containerDelegate.doProcess((Container)editorElement, attributeCategory, (ComponentModel)componentModel, context, dslElementSyntax);
        } else {
            this.splitterDelegate.doProcess((Splitter)editorElement, attributeCategory, (ComponentModel)componentModel, context, dslElementSyntax);
        }
    }

    @Override
    protected void processParameters(AbstractContributionEditorElement editorElement, final ConstructModel componentModel, final Context context, final DslElementSyntax dslElementSyntax, final XmlOrderSupplier xmlOrder, final List<String> processedItems) {
        editorElement.accept((IEditorElementVisitor)new EditorElementVisitorAdapter(){

            public void visit(Container container) {
                ConstructsItemProcessor.this.containerDelegate.processParameters(container, componentModel, context, dslElementSyntax, xmlOrder, processedItems);
            }

            public void visit(Splitter container) {
                ConstructsItemProcessor.this.splitterDelegate.processParameters(container, componentModel, context, dslElementSyntax, xmlOrder, processedItems);
            }
        });
    }

    @Override
    protected void addToContext(AbstractContributionEditorElement editorElement, ConstructModel componentModel, Context context) {
        context.addOperation(editorElement);
    }

    @Override
    protected void processNestableElements(AbstractContributionEditorElement editorElement, final ConstructModel componentModel, final Context context, final DslElementSyntax dslElementSyntax, final XmlOrderSupplier xmlOrder) {
        editorElement.accept((IEditorElementVisitor)new EditorElementVisitorAdapter(){

            public void visit(Container container) {
                ConstructsItemProcessor.this.containerDelegate.processNestableElements((AbstractContributionEditorElement)container, (ComponentModel)componentModel, context, dslElementSyntax, xmlOrder);
            }

            public void visit(Splitter container) {
                ConstructsItemProcessor.this.splitterDelegate.processNestableElements((AbstractContributionEditorElement)container, (ComponentModel)componentModel, context, dslElementSyntax, xmlOrder);
            }
        });
    }
}

